/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.dom;

import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomDocumentFragment;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.impl.SimpleRange;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstant;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.ClientRect;
import com.gargoylesoftware.htmlunit.javascript.host.ClientRectList;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Document;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Node;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import java.util.HashSet;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.apache.commons.logging.LogFactory;

@JsxClass
public class Range
extends SimpleScriptable {
    @JsxConstant
    public static final short START_TO_START = 0;
    @JsxConstant
    public static final short START_TO_END = 1;
    @JsxConstant
    public static final short END_TO_END = 2;
    @JsxConstant
    public static final short END_TO_START = 3;
    private Node startContainer_;
    private Node endContainer_;
    private int startOffset_;
    private int endOffset_;

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68, SupportedBrowser.FF60})
    public Range() {
    }

    public Range(Document document) {
        this.startContainer_ = document;
        this.endContainer_ = document;
    }

    Range(org.w3c.dom.ranges.Range w3cRange) {
        DomNode domNodeStartContainer = (DomNode)w3cRange.getStartContainer();
        this.startContainer_ = (Node)domNodeStartContainer.getScriptableObject();
        this.startOffset_ = w3cRange.getStartOffset();
        DomNode domNodeEndContainer = (DomNode)w3cRange.getEndContainer();
        this.endContainer_ = (Node)domNodeEndContainer.getScriptableObject();
        this.endOffset_ = w3cRange.getEndOffset();
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        if (this.getPrototype() == null) {
            return super.getDefaultValue(hint);
        }
        return this.toW3C().toString();
    }

    @JsxGetter
    public Object getStartContainer() {
        if (this.startContainer_ == null) {
            return Undefined.instance;
        }
        return this.startContainer_;
    }

    @JsxGetter
    public Object getEndContainer() {
        if (this.endContainer_ == null) {
            return Undefined.instance;
        }
        return this.endContainer_;
    }

    @JsxGetter
    public int getStartOffset() {
        return this.startOffset_;
    }

    @JsxGetter
    public int getEndOffset() {
        return this.endOffset_;
    }

    @JsxFunction
    public void setStart(Node refNode, int offset) {
        if (refNode == null) {
            throw Context.reportRuntimeError("It is illegal to call Range.setStart() with a null node.");
        }
        this.startContainer_ = refNode;
        this.startOffset_ = offset;
    }

    @JsxFunction
    public void setStartAfter(Node refNode) {
        if (refNode == null) {
            throw Context.reportRuntimeError("It is illegal to call Range.setStartAfter() with a null node.");
        }
        this.startContainer_ = refNode.getParent();
        this.startOffset_ = Range.getPositionInContainer(refNode) + 1;
    }

    @JsxFunction
    public void setStartBefore(Node refNode) {
        if (refNode == null) {
            throw Context.reportRuntimeError("It is illegal to call Range.setStartBefore() with a null node.");
        }
        this.startContainer_ = refNode.getParent();
        this.startOffset_ = Range.getPositionInContainer(refNode);
    }

    private static int getPositionInContainer(Node refNode) {
        int i = 0;
        Node node = refNode;
        while (node.getPreviousSibling() != null) {
            node = node.getPreviousSibling();
            ++i;
        }
        return i;
    }

    @JsxGetter
    public boolean isCollapsed() {
        return this.startContainer_ == this.endContainer_ && this.startOffset_ == this.endOffset_;
    }

    @JsxFunction
    public void setEnd(Node refNode, int offset) {
        if (refNode == null) {
            throw Context.reportRuntimeError("It is illegal to call Range.setEnd() with a null node.");
        }
        this.endContainer_ = refNode;
        this.endOffset_ = offset;
    }

    @JsxFunction
    public void setEndAfter(Node refNode) {
        if (refNode == null) {
            throw Context.reportRuntimeError("It is illegal to call Range.setEndAfter() with a null node.");
        }
        this.endContainer_ = refNode.getParent();
        this.endOffset_ = Range.getPositionInContainer(refNode) + 1;
    }

    @JsxFunction
    public void setEndBefore(Node refNode) {
        if (refNode == null) {
            throw Context.reportRuntimeError("It is illegal to call Range.setEndBefore() with a null node.");
        }
        this.startContainer_ = refNode.getParent();
        this.startOffset_ = Range.getPositionInContainer(refNode);
    }

    @JsxFunction
    public void selectNodeContents(Node refNode) {
        this.startContainer_ = refNode;
        this.startOffset_ = 0;
        this.endContainer_ = refNode;
        this.endOffset_ = refNode.getChildNodes().getLength();
    }

    @JsxFunction
    public void selectNode(Node refNode) {
        this.setStartBefore(refNode);
        this.setEndAfter(refNode);
    }

    @JsxFunction
    public void collapse(boolean toStart) {
        if (toStart) {
            this.endContainer_ = this.startContainer_;
            this.endOffset_ = this.startOffset_;
        } else {
            this.startContainer_ = this.endContainer_;
            this.startOffset_ = this.endOffset_;
        }
    }

    @JsxGetter
    public Object getCommonAncestorContainer() {
        Node ancestor;
        HashSet<Node> startAncestors = new HashSet<Node>();
        for (ancestor = this.startContainer_; ancestor != null; ancestor = ancestor.getParent()) {
            startAncestors.add(ancestor);
        }
        for (ancestor = this.endContainer_; ancestor != null; ancestor = ancestor.getParent()) {
            if (!startAncestors.contains(ancestor)) continue;
            return ancestor;
        }
        return Undefined.instance;
    }

    @JsxFunction
    public Object createContextualFragment(String valueAsString) {
        SgmlPage page = this.startContainer_.getDomNodeOrDie().getPage();
        DomDocumentFragment fragment = new DomDocumentFragment(page);
        try {
            page.getWebClient().getPageCreator().getHtmlParser().parseFragment(fragment, this.startContainer_.getDomNodeOrDie(), valueAsString);
        }
        catch (Exception e) {
            LogFactory.getLog(Range.class).error((Object)"Unexpected exception occurred in createContextualFragment", (Throwable)e);
            throw Context.reportRuntimeError("Unexpected exception occurred in createContextualFragment: " + e.getMessage());
        }
        return fragment.getScriptableObject();
    }

    @JsxFunction
    public Object extractContents() {
        return this.toW3C().extractContents().getScriptableObject();
    }

    public SimpleRange toW3C() {
        return new SimpleRange(this.startContainer_.getDomNodeOrNull(), this.startOffset_, this.endContainer_.getDomNodeOrDie(), this.endOffset_);
    }

    @JsxFunction
    public Object compareBoundaryPoints(int how, Range sourceRange) {
        int offsetForOther;
        Node nodeForOther;
        int containingMoficator;
        int offsetForThis;
        Node nodeForThis;
        if (0 == how || 3 == how) {
            nodeForThis = this.startContainer_;
            offsetForThis = this.startOffset_;
            containingMoficator = 1;
        } else {
            nodeForThis = this.endContainer_;
            offsetForThis = this.endOffset_;
            containingMoficator = -1;
        }
        if (1 == how || 0 == how) {
            nodeForOther = sourceRange.startContainer_;
            offsetForOther = sourceRange.startOffset_;
        } else {
            nodeForOther = sourceRange.endContainer_;
            offsetForOther = sourceRange.endOffset_;
        }
        if (nodeForThis == nodeForOther) {
            if (offsetForThis < offsetForOther) {
                return -1;
            }
            if (offsetForThis > offsetForOther) {
                return 1;
            }
            return 0;
        }
        byte nodeComparision = (byte)nodeForThis.compareDocumentPosition(nodeForOther);
        if ((nodeComparision & 0x10) != 0) {
            return -1 * containingMoficator;
        }
        if ((nodeComparision & 2) != 0) {
            return -1;
        }
        return 1;
    }

    @JsxFunction
    public Object cloneContents() {
        return this.toW3C().cloneContents().getScriptableObject();
    }

    @JsxFunction
    public void deleteContents() {
        this.toW3C().deleteContents();
    }

    @JsxFunction
    public void insertNode(Node newNode) {
        this.toW3C().insertNode(newNode.getDomNodeOrDie());
    }

    @JsxFunction
    public void surroundContents(Node newNode) {
        this.toW3C().surroundContents(newNode.getDomNodeOrDie());
    }

    @JsxFunction
    public Object cloneRange() {
        return new Range(this.toW3C().cloneRange());
    }

    @JsxFunction
    public void detach() {
    }

    @JsxFunction
    public String toString() {
        return this.toW3C().toString();
    }

    @Override
    protected Object equivalentValues(Object value) {
        if (!(value instanceof Range)) {
            return false;
        }
        Range other = (Range)value;
        return this.startContainer_ == other.startContainer_ && this.endContainer_ == other.endContainer_ && this.startOffset_ == other.startOffset_ && this.endOffset_ == other.endOffset_;
    }

    @JsxFunction
    public ClientRectList getClientRects() {
        Window w = this.getWindow();
        ClientRectList rectList = new ClientRectList();
        rectList.setParentScope(w);
        rectList.setPrototype(this.getPrototype(rectList.getClass()));
        for (DomNode node : this.toW3C().containedNodes()) {
            ScriptableObject scriptable = (ScriptableObject)node.getScriptableObject();
            if (!(scriptable instanceof HTMLElement)) continue;
            ClientRect rect = new ClientRect(0, 0, 1, 1);
            rect.setParentScope(w);
            rect.setPrototype(this.getPrototype(rect.getClass()));
            rectList.add(rect);
        }
        return rectList;
    }

    @JsxFunction
    public ClientRect getBoundingClientRect() {
        ClientRect rect = new ClientRect();
        rect.setParentScope(this.getWindow());
        rect.setPrototype(this.getPrototype(rect.getClass()));
        for (DomNode node : this.toW3C().containedNodes()) {
            ScriptableObject scriptable = (ScriptableObject)node.getScriptableObject();
            if (!(scriptable instanceof HTMLElement)) continue;
            ClientRect childRect = ((HTMLElement)scriptable).getBoundingClientRect();
            rect.setTop(Math.min(rect.getTop(), childRect.getTop()));
            rect.setLeft(Math.min(rect.getLeft(), childRect.getLeft()));
            rect.setRight(Math.max(rect.getRight(), childRect.getRight()));
            rect.setBottom(Math.max(rect.getBottom(), childRect.getBottom()));
        }
        return rect;
    }
}

