/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.canvas;

import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.canvas.rendering.RenderingBackend;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.typedarrays.NativeArrayBuffer;
import net.sourceforge.htmlunit.corejs.javascript.typedarrays.NativeUint8ClampedArray;

@JsxClass
public class ImageData
extends SimpleScriptable {
    private final byte[] bytes_;
    private final int width_;
    private final int height_;
    private NativeUint8ClampedArray data_;

    public ImageData() {
        this(null, 0, 0, 0, 0);
    }

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68, SupportedBrowser.FF60})
    public static Scriptable jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) {
        int height;
        int width;
        if (args.length < 2) {
            throw Context.reportRuntimeError("ImageData ctor - too less arguments");
        }
        NativeUint8ClampedArray data = null;
        if (args[0] instanceof NativeUint8ClampedArray) {
            data = (NativeUint8ClampedArray)args[0];
            if (data.getArrayLength() % 4 != 0) {
                throw Context.reportRuntimeError("ImageData ctor - data length mod 4 not zero");
            }
            width = (int)ScriptRuntime.toInteger(args[1]);
            if (args.length < 3) {
                height = data.getArrayLength() / 4 / width;
                if (data.getArrayLength() != 4 * width * height) {
                    throw Context.reportRuntimeError("ImageData ctor - width not correct");
                }
            } else {
                height = (int)ScriptRuntime.toInteger(args[2]);
            }
            if (data.getArrayLength() != 4 * width * height) {
                throw Context.reportRuntimeError("ImageData ctor - width/height not correct");
            }
        } else {
            width = (int)ScriptRuntime.toInteger(args[0]);
            height = (int)ScriptRuntime.toInteger(args[1]);
        }
        if (width < 0) {
            throw Context.reportRuntimeError("ImageData ctor - width negative");
        }
        if (height < 0) {
            throw Context.reportRuntimeError("ImageData ctor - height negative");
        }
        ImageData result = new ImageData(null, 0, 0, width, height);
        if (data != null) {
            byte[] bytes = data.getBuffer().getBuffer();
            System.arraycopy(bytes, 0, result.bytes_, 0, Math.min(bytes.length, result.bytes_.length));
        }
        return result;
    }

    ImageData(RenderingBackend context, int x, int y, int width, int height) {
        this.bytes_ = context == null ? new byte[width * height * 4] : context.getBytes(width, height, x, y);
        this.width_ = width;
        this.height_ = height;
    }

    @JsxGetter
    public int getWidth() {
        return this.width_;
    }

    @JsxGetter
    public int getHeight() {
        return this.height_;
    }

    @JsxGetter
    public NativeUint8ClampedArray getData() {
        if (this.data_ == null) {
            NativeArrayBuffer arrayBuffer = new NativeArrayBuffer(this.bytes_.length);
            System.arraycopy(this.bytes_, 0, arrayBuffer.getBuffer(), 0, this.bytes_.length);
            this.data_ = new NativeUint8ClampedArray(arrayBuffer, 0, this.bytes_.length);
            this.data_.setParentScope(this.getParentScope());
            this.data_.setPrototype(ScriptableObject.getClassPrototype(ImageData.getWindow(this), this.data_.getClassName()));
        }
        return this.data_;
    }
}

