/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HtmlInlineFrame;
import com.gargoylesoftware.htmlunit.html.HtmlNoFrames;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.ScriptElement;
import com.gargoylesoftware.htmlunit.javascript.AbstractJavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.PostponedAction;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import com.gargoylesoftware.htmlunit.javascript.host.event.EventHandler;
import com.gargoylesoftware.htmlunit.javascript.host.event.EventTarget;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLDocument;
import com.gargoylesoftware.htmlunit.util.EncodingSniffer;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ScriptElementSupport {
    private static final Log LOG = LogFactory.getLog(ScriptElementSupport.class);
    private static final String SLASH_SLASH_COLON = "//:";

    private ScriptElementSupport() {
    }

    public static void onAllChildrenAddedToPage(final DomElement element, boolean postponed) {
        if (element.getOwnerDocument() instanceof XmlPage) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Script node added: " + element.asXml()));
        }
        if (!element.getPage().getWebClient().isJavaScriptEngineEnabled()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"SvgScript found but not executed because javascript engine is disabled");
            }
            return;
        }
        PostponedAction action = new PostponedAction(element.getPage(), "Execution of script " + element){

            @Override
            public void execute() {
                HTMLDocument jsDoc = (HTMLDocument)((Window)element.getPage().getEnclosingWindow().getScriptableObject()).getDocument();
                jsDoc.setExecutingDynamicExternalPosponed(element.getStartLineNumber() == -1 && ((ScriptElement)((Object)element)).getSrcAttribute() != DomElement.ATTRIBUTE_NOT_DEFINED);
                try {
                    ScriptElementSupport.executeScriptIfNeeded(element);
                }
                finally {
                    jsDoc.setExecutingDynamicExternalPosponed(false);
                }
            }
        };
        AbstractJavaScriptEngine<?> engine = element.getPage().getWebClient().getJavaScriptEngine();
        if (element.hasAttribute("async") && !engine.isScriptRunning()) {
            HtmlPage owningPage = element.getHtmlPageOrNull();
            owningPage.addAfterLoadAction(action);
        } else if (element.hasAttribute("async") || postponed && StringUtils.isBlank(element.getTextContent())) {
            engine.addPostponedAction(action);
        } else {
            try {
                action.execute();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void executeScriptIfNeeded(DomElement element) {
        if (!ScriptElementSupport.isExecutionNeeded(element)) {
            return;
        }
        HtmlPage page = (HtmlPage)element.getPage();
        String src = ((ScriptElement)((Object)element)).getSrcAttribute();
        if (src.equals(SLASH_SLASH_COLON)) {
            ScriptElementSupport.executeEvent(element, "error");
            return;
        }
        if (src != DomElement.ATTRIBUTE_NOT_DEFINED) {
            if (src.startsWith("javascript:")) return;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Loading external JavaScript: " + src));
            }
            try {
                HtmlPage.JavaScriptLoadResult result;
                ScriptElement scriptElement = (ScriptElement)((Object)element);
                scriptElement.setExecuted(true);
                Charset charset = EncodingSniffer.toCharset(scriptElement.getCharsetAttribute());
                if (charset == null) {
                    charset = page.getCharset();
                }
                if ((result = page.loadExternalJavaScriptFile(src, charset)) == HtmlPage.JavaScriptLoadResult.SUCCESS || result == HtmlPage.JavaScriptLoadResult.NO_CONTENT) {
                    ScriptElementSupport.executeEvent(element, "load");
                    return;
                }
                if (result != HtmlPage.JavaScriptLoadResult.DOWNLOAD_ERROR) return;
                ScriptElementSupport.executeEvent(element, "error");
                return;
            }
            catch (FailingHttpStatusCodeException e) {
                ScriptElementSupport.executeEvent(element, "error");
                throw e;
            }
        } else {
            if (element.getFirstChild() == null) return;
            ScriptElementSupport.executeInlineScriptIfNeeded(element);
            if (!element.hasFeature(BrowserVersionFeatures.EVENT_ONLOAD_INTERNAL_JAVASCRIPT)) return;
            ScriptElementSupport.executeEvent(element, "load");
        }
    }

    private static boolean isExecutionNeeded(DomElement element) {
        String l;
        if (((ScriptElement)((Object)element)).isExecuted()) {
            return false;
        }
        if (!element.isAttachedToPage()) {
            return false;
        }
        SgmlPage page = element.getPage();
        if (!page.getWebClient().isJavaScriptEnabled()) {
            return false;
        }
        HtmlPage htmlPage = element.getHtmlPageOrNull();
        if (htmlPage != null && htmlPage.isParsingHtmlSnippet()) {
            return false;
        }
        for (DomNode o = element; o != null; o = o.getParentNode()) {
            if (!(o instanceof HtmlInlineFrame) && !(o instanceof HtmlNoFrames)) continue;
            return false;
        }
        if (page.getEnclosingWindow() != null && page.getEnclosingWindow().getEnclosedPage() != page) {
            return false;
        }
        String t = element.getAttributeDirect("type");
        if (!ScriptElementSupport.isJavaScript(element, t, l = element.getAttributeDirect("language"))) {
            LOG.warn((Object)("Script is not JavaScript (type: '" + t + "', language: '" + l + "'). Skipping execution."));
            return false;
        }
        return element.getPage().isAncestorOf(element);
    }

    public static boolean isJavaScript(DomElement element, String typeAttribute, String languageAttribute) {
        BrowserVersion browserVersion = element.getPage().getWebClient().getBrowserVersion();
        if (browserVersion.hasFeature(BrowserVersionFeatures.HTMLSCRIPT_TRIM_TYPE)) {
            typeAttribute = typeAttribute.trim();
        }
        if (StringUtils.isNotEmpty(typeAttribute)) {
            if ("text/javascript".equalsIgnoreCase(typeAttribute) || "text/ecmascript".equalsIgnoreCase(typeAttribute)) {
                return true;
            }
            return "application/javascript".equalsIgnoreCase(typeAttribute) || "application/ecmascript".equalsIgnoreCase(typeAttribute) || "application/x-javascript".equalsIgnoreCase(typeAttribute);
        }
        if (StringUtils.isNotEmpty(languageAttribute)) {
            return StringUtils.startsWithIgnoreCase(languageAttribute, "javascript");
        }
        return true;
    }

    private static void executeEvent(DomElement element, String type) {
        EventTarget eventTarget = (EventTarget)element.getScriptableObject();
        Event event = new Event(element, type);
        eventTarget.executeEventLocally(event);
    }

    private static void executeInlineScriptIfNeeded(DomElement element) {
        if (!ScriptElementSupport.isExecutionNeeded(element)) {
            return;
        }
        String src = ((ScriptElement)((Object)element)).getSrcAttribute();
        if (src != DomElement.ATTRIBUTE_NOT_DEFINED) {
            return;
        }
        String forr = element.getAttributeDirect("for");
        String event = element.getAttributeDirect("event");
        if (event.endsWith("()")) {
            event = event.substring(0, event.length() - 2);
        }
        String scriptCode = ScriptElementSupport.getScriptCode(element);
        if (event != DomElement.ATTRIBUTE_NOT_DEFINED && forr != DomElement.ATTRIBUTE_NOT_DEFINED && element.hasFeature(BrowserVersionFeatures.JS_SCRIPT_SUPPORTS_FOR_AND_EVENT_WINDOW) && "window".equals(forr)) {
            Window window = (Window)element.getPage().getEnclosingWindow().getScriptableObject();
            EventHandler function = new EventHandler(element, event, scriptCode);
            window.getEventListenersContainer().addEventListener(StringUtils.substring(event, 2), function, false);
            return;
        }
        if (forr == DomElement.ATTRIBUTE_NOT_DEFINED || "onload".equals(event)) {
            String url = element.getPage().getUrl().toExternalForm();
            int line1 = element.getStartLineNumber();
            int line2 = element.getEndLineNumber();
            int col1 = element.getStartColumnNumber();
            int col2 = element.getEndColumnNumber();
            String desc = "script in " + url + " from (" + line1 + ", " + col1 + ") to (" + line2 + ", " + col2 + ")";
            ((ScriptElement)((Object)element)).setExecuted(true);
            ((HtmlPage)element.getPage()).executeJavaScript(scriptCode, desc, line1);
        }
    }

    private static String getScriptCode(DomElement element) {
        Iterable<DomNode> textNodes = element.getChildren();
        StringBuilder scriptCode = new StringBuilder();
        for (DomNode node : textNodes) {
            if (!(node instanceof DomText)) continue;
            DomText domText = (DomText)node;
            scriptCode.append(domText.getData());
        }
        return scriptCode.toString();
    }
}

