/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.TagLibrary;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.parser.XMLParser;
import org.apache.commons.jelly.util.ClassLoaderUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JellyContext {
    private static final Log log = LogFactory.getLog(JellyContext.class);
    private static final boolean DEFAULT_INHERIT = true;
    private static final boolean DEFAULT_EXPORT = false;
    private static final boolean DEFAULT_ALLOW_DTD_CALLS_TO_EXTERNAL_ENTITIES = false;
    private static final String BAD_PARSE = "Could not parse Jelly script";
    protected ClassLoader classLoader;
    protected boolean useContextClassLoader = false;
    private URL rootURL;
    private URL currentURL;
    private Map taglibs = new Hashtable();
    private Map variables = new HashMap();
    private JellyContext parent;
    private boolean inherit = true;
    private boolean export = false;
    private boolean allowDtdToCallExternalEntities = false;
    private boolean exportLibraries = true;
    private boolean cacheTags = false;

    public JellyContext() {
        this.currentURL = this.rootURL;
        this.init();
    }

    public JellyContext(URL rootURL) {
        this(rootURL, rootURL);
    }

    public JellyContext(URL rootURL, URL currentURL) {
        this.rootURL = rootURL;
        this.currentURL = currentURL;
        this.init();
    }

    public JellyContext(JellyContext parent) {
        this.parent = parent;
        this.rootURL = parent.rootURL;
        this.currentURL = parent.currentURL;
        this.variables.put("parentScope", parent.variables);
        this.cacheTags = parent.cacheTags;
        this.init();
    }

    public JellyContext(JellyContext parentJellyContext, URL currentURL) {
        this(parentJellyContext);
        this.currentURL = currentURL;
    }

    public JellyContext(JellyContext parentJellyContext, URL rootURL, URL currentURL) {
        this(parentJellyContext, currentURL);
        this.rootURL = rootURL;
    }

    private void init() {
        this.variables.put("context", this);
        try {
            this.variables.put("systemScope", System.getProperties());
        }
        catch (SecurityException e) {
            log.debug((Object)"security exception accessing system properties", (Throwable)e);
        }
    }

    public JellyContext getParent() {
        return this.parent;
    }

    public JellyContext getScope(String name) {
        if ("parent".equals(name)) {
            return this.getParent();
        }
        return null;
    }

    public Object findVariable(String name) {
        boolean definedHere;
        Object answer = this.variables.get(name);
        boolean bl = definedHere = answer != null || this.variables.containsKey(name);
        if (definedHere) {
            return answer;
        }
        if (answer == null && this.parent != null) {
            answer = this.parent.findVariable(name);
        }
        if (answer == null) {
            answer = this.getSystemProperty(name);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("findVariable: " + name + " value: " + answer));
        }
        return answer;
    }

    public Object getVariable(String name) {
        Object value = this.getVariableWithDefaultValue(name, null);
        if (value == null) {
            value = this.getSystemProperty(name);
        }
        return value;
    }

    public Object getVariableWithDefaultValue(String name, Object defaultValue) {
        JellyContext parentContext;
        boolean definedHere;
        Object value = this.variables.get(name);
        boolean bl = definedHere = value != null || this.variables.containsKey(name);
        if (definedHere) {
            return value;
        }
        value = defaultValue;
        if (this.isInherit() && (parentContext = this.getParent()) != null) {
            value = parentContext.getVariableWithDefaultValue(name, defaultValue);
        }
        return value;
    }

    private Object getSystemProperty(String name) {
        try {
            if (name == null || name.length() == 0) {
                return null;
            }
            return System.getProperty(name);
        }
        catch (SecurityException e) {
            log.debug((Object)"security exception accessing system properties", (Throwable)e);
            return null;
        }
    }

    public Object getVariable(String name, String scopeName) {
        JellyContext scope = this.getScope(scopeName);
        if (scope != null) {
            return scope.getVariable(name);
        }
        return null;
    }

    public void setVariable(String name, Object value) {
        if (this.isExport()) {
            this.getParent().setVariable(name, value);
            return;
        }
        this.variables.put(name, value);
    }

    public void setVariable(String name, String scopeName, Object value) {
        JellyContext scope = this.getScope(scopeName);
        if (scope != null) {
            scope.setVariable(name, value);
        }
    }

    public void removeVariable(String name) {
        this.variables.remove(name);
    }

    public void removeVariable(String name, String scopeName) {
        JellyContext scope = this.getScope(scopeName);
        if (scope != null) {
            scope.removeVariable(name);
        }
    }

    public Iterator getVariableNames() {
        return this.variables.keySet().iterator();
    }

    public Map getVariables() {
        return this.variables;
    }

    public void setVariables(Map variables) {
        this.variables.putAll(variables);
    }

    public JellyContext newJellyContext(Map newVariables) {
        JellyContext answer = this.createChildContext();
        answer.setVariables(newVariables);
        answer.setVariable("parentScope", this.variables);
        return answer;
    }

    public JellyContext newJellyContext() {
        return this.createChildContext();
    }

    public void clear() {
        this.clearVariables();
    }

    protected void clearVariables() {
        this.variables.clear();
    }

    public void registerTagLibrary(String namespaceURI, TagLibrary taglib) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registering tag library to: " + namespaceURI + " taglib: " + taglib));
        }
        this.taglibs.put(namespaceURI, taglib);
        if (this.isExportLibraries() && this.parent != null) {
            this.parent.registerTagLibrary(namespaceURI, taglib);
        }
    }

    public void registerTagLibrary(String namespaceURI, String className) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registering tag library to: " + namespaceURI + " taglib: " + className));
        }
        this.taglibs.put(namespaceURI, className);
        if (this.isExportLibraries() && this.parent != null) {
            this.parent.registerTagLibrary(namespaceURI, className);
        }
    }

    public boolean isTagLibraryRegistered(String namespaceURI) {
        boolean answer = this.taglibs.containsKey(namespaceURI);
        if (answer) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.isTagLibraryRegistered(namespaceURI);
        }
        return false;
    }

    public TagLibrary getTagLibrary(String namespaceURI) {
        Object answer = this.taglibs.get(namespaceURI);
        if (answer == null && this.parent != null) {
            answer = this.parent.getTagLibrary(namespaceURI);
        }
        if (answer instanceof TagLibrary) {
            return (TagLibrary)answer;
        }
        if (answer instanceof String) {
            String className = (String)answer;
            Class<?> theClass = null;
            try {
                theClass = this.getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                log.error((Object)("Could not find the class: " + className), (Throwable)e);
            }
            if (theClass != null) {
                try {
                    Object object = theClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    if (object instanceof TagLibrary) {
                        this.taglibs.put(namespaceURI, object);
                        return (TagLibrary)object;
                    }
                    log.error((Object)("The tag library object mapped to: " + namespaceURI + " is not a TagLibrary. Object = " + object));
                }
                catch (Exception e) {
                    log.error((Object)("Could not instantiate instance of class: " + className + ". Reason: " + e), (Throwable)e);
                }
            }
        }
        return null;
    }

    public Script compileScript(String uri) throws JellyException {
        XMLParser parser = this.getXMLParser();
        parser.setContext(this);
        InputStream in = this.getResourceAsStream(uri);
        if (in == null) {
            throw new JellyException("Could not find Jelly script: " + uri);
        }
        Script script = null;
        try {
            script = parser.parse(in);
        }
        catch (IOException e) {
            throw new JellyException("Could not parse Jelly script : " + uri, e);
        }
        catch (SAXException e) {
            throw new JellyException("Could not parse Jelly script : " + uri, e);
        }
        return script.compile();
    }

    public Script compileScript(URL url) throws JellyException {
        Script script;
        XMLParser parser = this.getXMLParser();
        parser.setContext(this);
        try {
            script = parser.parse(url.toString());
        }
        catch (IOException e) {
            throw new JellyException("Could not parse Jelly script : " + url, e);
        }
        catch (SAXException e) {
            throw new JellyException("Could not parse Jelly script : " + url, e);
        }
        return script.compile();
    }

    public Script compileScript(InputSource source) throws JellyException {
        XMLParser parser = this.getXMLParser();
        parser.setContext(this);
        Script script = null;
        try {
            script = parser.parse(source);
        }
        catch (IOException e) {
            throw new JellyException("Could not parse Jelly script : " + source.getSystemId(), e);
        }
        catch (SAXException e) {
            throw new JellyException("Could not parse Jelly script : " + source.getSystemId(), e);
        }
        return script.compile();
    }

    protected XMLParser getXMLParser() {
        XMLParser parser = this.createXMLParser();
        return parser;
    }

    protected XMLParser createXMLParser() {
        return new XMLParser(this.allowDtdToCallExternalEntities);
    }

    public JellyContext runScript(File file, XMLOutput output) throws JellyException {
        try {
            return this.runScript(file.toURL(), output, false, true);
        }
        catch (MalformedURLException e) {
            throw new JellyException(e.toString());
        }
    }

    public JellyContext runScript(URL url, XMLOutput output) throws JellyException {
        return this.runScript(url, output, false, true);
    }

    public JellyContext runScript(InputSource source, XMLOutput output) throws JellyException {
        return this.runScript(source, output, false, true);
    }

    public JellyContext runScript(String uri, XMLOutput output) throws JellyException {
        URL url = null;
        try {
            url = this.getResource(uri);
        }
        catch (MalformedURLException e) {
            throw new JellyException(e.toString());
        }
        if (url == null) {
            throw new JellyException("Could not find Jelly script: " + url);
        }
        return this.runScript(url, output, false, true);
    }

    public JellyContext runScript(String uri, XMLOutput output, boolean export, boolean inherit) throws JellyException {
        URL url = null;
        try {
            url = this.getResource(uri);
        }
        catch (MalformedURLException e) {
            throw new JellyException(e.toString());
        }
        if (url == null) {
            throw new JellyException("Could not find Jelly script: " + url);
        }
        return this.runScript(url, output, export, inherit);
    }

    public JellyContext runScript(File file, XMLOutput output, boolean export, boolean inherit) throws JellyException {
        try {
            return this.runScript(file.toURL(), output, export, inherit);
        }
        catch (MalformedURLException e) {
            throw new JellyException(e.toString());
        }
    }

    public JellyContext runScript(URL url, XMLOutput output, boolean export, boolean inherit) throws JellyException {
        return this.runScript(new InputSource(url.toString()), output, export, inherit);
    }

    public JellyContext runScript(InputSource source, XMLOutput output, boolean export, boolean inherit) throws JellyException {
        Script script = this.compileScript(source);
        URL newJellyContextURL = null;
        try {
            newJellyContextURL = this.getJellyContextURL(source);
        }
        catch (MalformedURLException e) {
            throw new JellyException(e.toString());
        }
        JellyContext newJellyContext = this.newJellyContext();
        newJellyContext.setRootURL(newJellyContextURL);
        newJellyContext.setCurrentURL(newJellyContextURL);
        newJellyContext.setExport(export);
        newJellyContext.setInherit(inherit);
        if (inherit) {
            newJellyContext.variables = this.variables;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("About to run script: " + source.getSystemId()));
            log.debug((Object)("root context URL: " + newJellyContext.rootURL));
            log.debug((Object)("current context URL: " + newJellyContext.currentURL));
        }
        script.run(newJellyContext, output);
        return newJellyContext;
    }

    public URL getResource(String uri) throws MalformedURLException {
        if (uri.startsWith("/")) {
            return this.createRelativeURL(this.rootURL, uri.substring(1));
        }
        try {
            return new URL(uri);
        }
        catch (MalformedURLException e) {
            try {
                return this.createRelativeURL(this.currentURL, uri);
            }
            catch (MalformedURLException e2) {
                throw e;
            }
        }
    }

    public InputStream getResourceAsStream(String uri) {
        try {
            URL url = this.getResource(uri);
            return url.openStream();
        }
        catch (Exception e) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Caught exception attempting to open: " + uri + ". Exception: " + e), (Throwable)e);
            }
            return null;
        }
    }

    public URL getRootURL() {
        return this.rootURL;
    }

    public void setRootURL(URL rootURL) {
        this.rootURL = rootURL;
    }

    public URL getCurrentURL() {
        return this.currentURL;
    }

    public void setCurrentURL(URL currentURL) {
        this.currentURL = currentURL;
    }

    public boolean isCacheTags() {
        return this.cacheTags;
    }

    public void setCacheTags(boolean cacheTags) {
        this.cacheTags = cacheTags;
    }

    public boolean isExportLibraries() {
        return this.exportLibraries;
    }

    public void setExportLibraries(boolean exportLibraries) {
        this.exportLibraries = exportLibraries;
    }

    public void setExport(boolean export) {
        this.export = export;
    }

    public boolean isExport() {
        return this.export;
    }

    public void setInherit(boolean inherit) {
        this.inherit = inherit;
    }

    public boolean isInherit() {
        return this.inherit;
    }

    public void setAllowDtdToCallExternalEntities(boolean allowDtdToCallExternalEntities) {
        this.allowDtdToCallExternalEntities = allowDtdToCallExternalEntities;
    }

    public boolean isAllowDtdToCallExternalEntities() {
        return this.allowDtdToCallExternalEntities;
    }

    public ClassLoader getClassLoader() {
        return ClassLoaderUtils.getClassLoader(this.classLoader, this.useContextClassLoader, this.getClass());
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public boolean getUseContextClassLoader() {
        return this.useContextClassLoader;
    }

    public void setUseContextClassLoader(boolean use) {
        this.useContextClassLoader = use;
    }

    protected URL createRelativeURL(URL rootURL, String relativeURI) throws MalformedURLException {
        URL url = rootURL;
        if (url == null) {
            File file = new File(System.getProperty("user.dir"));
            url = file.toURL();
        }
        String urlText = url.toString() + relativeURI;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Attempting to open url: " + urlText));
        }
        return new URL(urlText);
    }

    protected URL getJellyContextURL(URL url) throws MalformedURLException {
        String text = url.toString();
        int idx = text.lastIndexOf(47);
        text = text.substring(0, idx + 1);
        return new URL(text);
    }

    protected URL getJellyContextURL(InputSource source) throws MalformedURLException {
        String text = source.getSystemId();
        if (text != null) {
            int idx = text.lastIndexOf(47);
            text = text.substring(0, idx + 1);
            return new URL(text);
        }
        return null;
    }

    protected JellyContext createChildContext() {
        return new JellyContext(this);
    }

    protected void setParent(JellyContext context) {
        this.parent = context;
        this.variables.put("parentScope", this.parent.variables);
        if (this.isExportLibraries() && this.parent != null) {
            for (String namespaceURI : this.taglibs.keySet()) {
                Object tagLibOrClassName = this.taglibs.get(namespaceURI);
                if (tagLibOrClassName instanceof TagLibrary) {
                    this.parent.registerTagLibrary(namespaceURI, (TagLibrary)tagLibOrClassName);
                    continue;
                }
                this.parent.registerTagLibrary(namespaceURI, (String)tagLibOrClassName);
            }
        }
    }
}

