/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.repository.extrnal;

import com.alibaba.nacos.common.utils.MD5Utils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.constant.Constants;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.model.ConfigInfoBetaWrapper;
import com.alibaba.nacos.config.server.model.ConfigInfoStateWrapper;
import com.alibaba.nacos.config.server.model.ConfigOperateResult;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoBetaPersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigRowMapperInjector;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.persistence.configuration.condition.ConditionOnExternalStorage;
import com.alibaba.nacos.persistence.datasource.DataSourceService;
import com.alibaba.nacos.persistence.datasource.DynamicDataSource;
import com.alibaba.nacos.persistence.model.Page;
import com.alibaba.nacos.persistence.repository.PaginationHelper;
import com.alibaba.nacos.persistence.repository.extrnal.ExternalStoragePaginationHelperImpl;
import com.alibaba.nacos.plugin.datasource.MapperManager;
import com.alibaba.nacos.plugin.datasource.mapper.ConfigInfoBetaMapper;
import com.alibaba.nacos.plugin.datasource.model.MapperContext;
import com.alibaba.nacos.plugin.datasource.model.MapperResult;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import org.springframework.context.annotation.Conditional;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Conditional(value={ConditionOnExternalStorage.class})
@Service(value="externalConfigInfoBetaPersistServiceImpl")
public class ExternalConfigInfoBetaPersistServiceImpl
implements ConfigInfoBetaPersistService {
    private DataSourceService dataSourceService = DynamicDataSource.getInstance().getDataSource();
    protected JdbcTemplate jt = this.dataSourceService.getJdbcTemplate();
    protected TransactionTemplate tjt = this.dataSourceService.getTransactionTemplate();
    private MapperManager mapperManager;

    public ExternalConfigInfoBetaPersistServiceImpl() {
        Boolean isDataSourceLogEnable = (Boolean)EnvUtil.getProperty((String)"nacos.plugin.datasource.log.enabled", Boolean.class, (Object)false);
        this.mapperManager = MapperManager.instance((boolean)isDataSourceLogEnable);
    }

    @Override
    public <E> PaginationHelper<E> createPaginationHelper() {
        return new ExternalStoragePaginationHelperImpl(this.jt);
    }

    @Override
    public ConfigOperateResult addConfigInfo4Beta(ConfigInfo configInfo, String betaIps, String srcIp, String srcUser) {
        String appNameTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getAppName());
        String tenantTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getTenant());
        String md5 = MD5Utils.md5Hex((String)configInfo.getContent(), (String)Constants.PERSIST_ENCODE);
        String encryptedDataKey = StringUtils.defaultEmptyIfBlank((String)configInfo.getEncryptedDataKey());
        try {
            ConfigInfoBetaMapper configInfoBetaMapper = (ConfigInfoBetaMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_beta");
            Timestamp time = new Timestamp(System.currentTimeMillis());
            this.jt.update(configInfoBetaMapper.insert(Arrays.asList("data_id", "group_id", "tenant_id", "app_name", "content", "md5", "beta_ips", "src_ip", "src_user", "gmt_create", "gmt_modified", "encrypted_data_key")), new Object[]{configInfo.getDataId(), configInfo.getGroup(), tenantTmp, appNameTmp, configInfo.getContent(), md5, betaIps, srcIp, srcUser, time, time, encryptedDataKey});
            return this.getBetaOperateResult(configInfo.getDataId(), configInfo.getGroup(), tenantTmp);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public ConfigOperateResult insertOrUpdateBeta(ConfigInfo configInfo, String betaIps, String srcIp, String srcUser) {
        ConfigInfoStateWrapper configInfo4BetaState = this.findConfigInfo4BetaState(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant());
        if (configInfo4BetaState == null) {
            return this.addConfigInfo4Beta(configInfo, betaIps, srcIp, srcUser);
        }
        return this.updateConfigInfo4Beta(configInfo, betaIps, srcIp, srcUser);
    }

    @Override
    public ConfigOperateResult insertOrUpdateBetaCas(ConfigInfo configInfo, String betaIps, String srcIp, String srcUser) {
        ConfigInfoStateWrapper configInfo4BetaState = this.findConfigInfo4BetaState(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant());
        if (configInfo4BetaState == null) {
            return this.addConfigInfo4Beta(configInfo, betaIps, srcIp, srcUser);
        }
        return this.updateConfigInfo4BetaCas(configInfo, betaIps, srcIp, srcUser);
    }

    @Override
    public void removeConfigInfo4Beta(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        this.tjt.execute(status -> {
            try {
                ConfigInfoStateWrapper configInfo = this.findConfigInfo4BetaState(dataId, group, tenant);
                if (configInfo != null) {
                    ConfigInfoBetaMapper configInfoBetaMapper = (ConfigInfoBetaMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_beta");
                    this.jt.update(configInfoBetaMapper.delete(Arrays.asList("data_id", "group_id", "tenant_id")), new Object[]{dataId, group, tenantTmp});
                }
            }
            catch (CannotGetJdbcConnectionException e) {
                LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
                throw e;
            }
            return Boolean.TRUE;
        });
    }

    @Override
    public ConfigOperateResult updateConfigInfo4Beta(ConfigInfo configInfo, String betaIps, String srcIp, String srcUser) {
        String appNameTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getAppName());
        String tenantTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getTenant());
        String md5 = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
        String encryptedDataKey = StringUtils.defaultEmptyIfBlank((String)configInfo.getEncryptedDataKey());
        try {
            ConfigInfoBetaMapper configInfoBetaMapper = (ConfigInfoBetaMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_beta");
            Timestamp time = new Timestamp(System.currentTimeMillis());
            this.jt.update(configInfoBetaMapper.update(Arrays.asList("content", "md5", "beta_ips", "src_ip", "src_user", "gmt_modified", "app_name", "encrypted_data_key"), Arrays.asList("data_id", "group_id", "tenant_id")), new Object[]{configInfo.getContent(), md5, betaIps, srcIp, srcUser, time, appNameTmp, encryptedDataKey, configInfo.getDataId(), configInfo.getGroup(), tenantTmp});
            return this.getBetaOperateResult(configInfo.getDataId(), configInfo.getGroup(), tenantTmp);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public ConfigInfoStateWrapper findConfigInfo4BetaState(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        try {
            return (ConfigInfoStateWrapper)this.jt.queryForObject("SELECT id,data_id,group_id,tenant_id,gmt_modified FROM config_info_beta WHERE data_id=? AND group_id=? AND tenant_id=? ", new Object[]{dataId, group, tenantTmp}, (RowMapper)ConfigRowMapperInjector.CONFIG_INFO_STATE_WRAPPER_ROW_MAPPER);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    private ConfigOperateResult getBetaOperateResult(String dataId, String group, String tenant) {
        ConfigInfoStateWrapper configInfo4Beta = this.findConfigInfo4BetaState(dataId, group, tenant);
        if (configInfo4Beta == null) {
            return new ConfigOperateResult(false);
        }
        return new ConfigOperateResult(configInfo4Beta.getId(), configInfo4Beta.getLastModified());
    }

    @Override
    public ConfigOperateResult updateConfigInfo4BetaCas(ConfigInfo configInfo, String betaIps, String srcIp, String srcUser) {
        String appNameTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getAppName());
        String tenantTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getTenant());
        String md5 = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
        try {
            boolean result;
            ConfigInfoBetaMapper configInfoBetaMapper = (ConfigInfoBetaMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_beta");
            Timestamp time = new Timestamp(System.currentTimeMillis());
            MapperContext context = new MapperContext();
            context.putUpdateParameter("content", (Object)configInfo.getContent());
            context.putUpdateParameter("md5", (Object)md5);
            context.putUpdateParameter("betaIps", (Object)betaIps);
            context.putUpdateParameter("srcIp", (Object)srcIp);
            context.putUpdateParameter("srcUser", (Object)srcUser);
            context.putUpdateParameter("gmtModified", (Object)time);
            context.putUpdateParameter("app_name", (Object)appNameTmp);
            context.putWhereParameter("dataId", (Object)configInfo.getDataId());
            context.putWhereParameter("groupId", (Object)configInfo.getGroup());
            context.putWhereParameter("tenantId", (Object)tenantTmp);
            context.putWhereParameter("md5", (Object)configInfo.getMd5());
            MapperResult mapperResult = configInfoBetaMapper.updateConfigInfo4BetaCas(context);
            String sql = mapperResult.getSql();
            List paramList = mapperResult.getParamList();
            Object[] args = paramList.toArray();
            boolean bl = result = this.jt.update(sql, args) > 0;
            if (result) {
                return this.getBetaOperateResult(configInfo.getDataId(), configInfo.getGroup(), tenantTmp);
            }
            return new ConfigOperateResult(false);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public ConfigInfoBetaWrapper findConfigInfo4Beta(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        try {
            ConfigInfoBetaMapper configInfoBetaMapper = (ConfigInfoBetaMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_beta");
            return (ConfigInfoBetaWrapper)this.jt.queryForObject(configInfoBetaMapper.select(Arrays.asList("id", "data_id", "group_id", "tenant_id", "app_name", "content", "beta_ips", "encrypted_data_key", "gmt_modified"), Arrays.asList("data_id", "group_id", "tenant_id")), new Object[]{dataId, group, tenantTmp}, (RowMapper)ConfigRowMapperInjector.CONFIG_INFO_BETA_WRAPPER_ROW_MAPPER);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public int configInfoBetaCount() {
        ConfigInfoBetaMapper configInfoBetaMapper = (ConfigInfoBetaMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_beta");
        String sql = configInfoBetaMapper.count(null);
        Integer result = (Integer)this.jt.queryForObject(sql, Integer.class);
        return result;
    }

    @Override
    public Page<ConfigInfoBetaWrapper> findAllConfigInfoBetaForDumpAll(int pageNo, int pageSize) {
        int startRow = (pageNo - 1) * pageSize;
        ConfigInfoBetaMapper configInfoBetaMapper = (ConfigInfoBetaMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_beta");
        String sqlCountRows = configInfoBetaMapper.count(null);
        MapperContext context = new MapperContext();
        context.setStartRow(startRow);
        context.setPageSize(pageSize);
        MapperResult mapperResult = configInfoBetaMapper.findAllConfigInfoBetaForDumpAllFetchRows(context);
        String sqlFetchRows = mapperResult.getSql();
        PaginationHelper helper = this.createPaginationHelper();
        try {
            return helper.fetchPageLimit(sqlCountRows, sqlFetchRows, new Object[0], pageNo, pageSize, (RowMapper)ConfigRowMapperInjector.CONFIG_INFO_BETA_WRAPPER_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }
}

