/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.drag.service.a;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.jeecg.modules.drag.config.page.DragPage;
import org.jeecg.modules.drag.dao.OnlDragPageCompDao;
import org.jeecg.modules.drag.dao.OnlDragPageDao;
import org.jeecg.modules.drag.entity.OnlDragPage;
import org.jeecg.modules.drag.entity.OnlDragPageComp;
import org.jeecg.modules.drag.exception.OnlDragException;
import org.jeecg.modules.drag.service.IOnlDragPageService;
import org.jeecg.modules.drag.util.a;
import org.jeecg.modules.drag.util.f;
import org.jeecg.modules.drag.util.h;
import org.jeecgframework.minidao.pojo.MiniDaoPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="onlDragPageServiceImpl")
public class j
implements IOnlDragPageService {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(j.class);
    @Autowired
    private OnlDragPageDao onlDragPageDao;
    @Autowired
    private OnlDragPageCompDao onlDragPageCompDao;
    @Autowired
    private f redisUtil;

    @Override
    public OnlDragPage addOnlPage(OnlDragPage onlDragPage) {
        String template = onlDragPage.getTemplate();
        JSONArray array = JSONArray.parseArray((String)template);
        if (array != null) {
            org.jeecg.modules.drag.util.a.a(array, null);
            onlDragPage.setTemplate(array.toJSONString());
        }
        onlDragPage.setIzTemplate("0");
        String type = onlDragPage.getType();
        if (h.c((Object)type)) {
            onlDragPage.setType("0");
        }
        onlDragPage.setVisitsNum(0);
        this.onlDragPageDao.insert(onlDragPage);
        onlDragPage.setPath(String.format("/drag/page/view/%s", onlDragPage.getId()));
        this.onlDragPageDao.update(onlDragPage);
        return onlDragPage;
    }

    @Override
    public OnlDragPage getOneOnlPage(String id) {
        OnlDragPage onlDragPage = this.getById(id);
        if (onlDragPage == null) {
            return null;
        }
        String template = onlDragPage.getTemplate();
        JSONArray array = JSONArray.parseArray((String)template);
        if (array != null) {
            List<OnlDragPageComp> onlDragPageCompList = this.onlDragPageCompDao.queryByPageId(id);
            Map<String, Object> maps = onlDragPageCompList.stream().collect(Collectors.toMap(OnlDragPageComp::getId, opc -> opc.getConfig() != null ? opc.getConfig() : "{}"));
            org.jeecg.modules.drag.util.a.a(array, maps);
            onlDragPage.setTemplate(array.toJSONString());
        }
        return onlDragPage;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteOne(String id) {
        this.onlDragPageDao.deleteById(id);
        List<OnlDragPageComp> onlDragPageCompList = this.onlDragPageCompDao.queryByPageId(id);
        List ids = onlDragPageCompList.stream().map(OnlDragPageComp::getId).collect(Collectors.toList());
        for (int i2 = 0; i2 < ids.size(); ++i2) {
            this.onlDragPageCompDao.deleteById((String)ids.get(i2));
        }
        String key = String.format("drag:cache:page::%s", id);
        if (this.redisUtil.a(key)) {
            this.redisUtil.a(new String[]{key});
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean editOnlPageById(OnlDragPage onlDragPage) {
        String template = onlDragPage.getTemplate();
        if (StringUtils.isNotBlank((String)template)) {
            List<OnlDragPageComp> onlDragPageCompList = this.onlDragPageCompDao.queryByPageId(onlDragPage.getId());
            List ids = onlDragPageCompList.stream().map(OnlDragPageComp::getId).collect(Collectors.toList());
            for (int i2 = 0; i2 < ids.size(); ++i2) {
                this.onlDragPageCompDao.deleteById((String)ids.get(i2));
            }
            JSONArray array = JSONArray.parseArray((String)template);
            if (array != null) {
                this.a(array, onlDragPage.getId());
                onlDragPage.setTemplate(array.toJSONString());
            }
        }
        onlDragPage.setPath(String.format("/drag/page/view/%s", onlDragPage.getId()));
        int update = this.onlDragPageDao.update(onlDragPage);
        String key = String.format("drag:cache:page::%s", onlDragPage.getId());
        if (this.redisUtil.a(key)) {
            this.redisUtil.a(new String[]{key});
        }
        if (update == 0) {
            throw new OnlDragException("\u4eea\u8868\u76d8\u5185\u5bb9\u4e0d\u662f\u6700\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u64cd\u4f5c~");
        }
        return update == 1;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public OnlDragPage copyPage(OnlDragPage onlDragPage) {
        OnlDragPage targetPage = new OnlDragPage();
        String random = String.format("%04d", new Random().nextInt(9999));
        Object dragName = onlDragPage.getName();
        if (onlDragPage.getName().indexOf("\u526f\u672c") == -1) {
            dragName = (String)dragName + "\u526f\u672c" + random;
        } else {
            int suffix_index = ((String)dragName).length();
            if (((String)dragName).indexOf("\u526f\u672c") > 0) {
                suffix_index = ((String)dragName).indexOf("\u526f\u672c");
            }
            dragName = ((String)dragName).substring(0, suffix_index) + "\u526f\u672c" + random;
        }
        BeanUtils.copyProperties((Object)onlDragPage, (Object)targetPage);
        targetPage.setId(null);
        targetPage.setName((String)dragName);
        targetPage.setProtectionCode(null);
        targetPage.setIzTemplate("0");
        targetPage.setCreateTime(new Date());
        targetPage.setVisitsNum(0);
        this.onlDragPageDao.insert(targetPage);
        this.a(targetPage);
        targetPage.setPath(String.format("/drag/page/view/%s", targetPage.getId()));
        this.onlDragPageDao.update(targetPage);
        return targetPage;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public OnlDragPage backupsPage(String id, String backupKey) {
        OnlDragPage sourcePage = this.onlDragPageDao.get(id);
        if (sourcePage != null) {
            String newId = org.jeecg.modules.drag.util.a.a(id, backupKey);
            String newLowAppId = org.jeecg.modules.drag.util.a.a(sourcePage.getLowAppId(), backupKey);
            OnlDragPage targetPage = new OnlDragPage();
            BeanUtils.copyProperties((Object)sourcePage, (Object)targetPage);
            targetPage.setId(newId);
            targetPage.setLowAppId(newLowAppId);
            this.onlDragPageDao.insert(targetPage);
            this.a(targetPage);
            targetPage.setPath(String.format("/drag/page/view/%s", targetPage.getId()));
            this.onlDragPageDao.update(targetPage);
            return targetPage;
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void revertPage(String id, String backupKey) {
        String originId = org.jeecg.modules.drag.util.a.b(id, backupKey);
        this.deleteOne(originId);
        OnlDragPage sourcePage = this.onlDragPageDao.get(id);
        if (sourcePage != null) {
            OnlDragPage targetPage = new OnlDragPage();
            BeanUtils.copyProperties((Object)sourcePage, (Object)targetPage);
            targetPage.setId(originId);
            targetPage.setLowAppId(org.jeecg.modules.drag.util.a.b(sourcePage.getLowAppId(), backupKey));
            this.onlDragPageDao.insert(targetPage);
            this.a(targetPage);
            targetPage.setPath(String.format("/drag/page/view/%s", targetPage.getId()));
            this.onlDragPageDao.update(targetPage);
        }
    }

    @Override
    public void replacePageValue(String id, Map<String, String> formCodeMap, Map<String, String> formIdMap, Map<String, String> dragIdMap, Map<String, String> viewIdMap, Map<String, String> bpmIdMap) {
        OnlDragPage onlDragPage = this.onlDragPageDao.get(id);
        JSONArray tempArr = JSONArray.parseArray((String)onlDragPage.getTemplate());
        if (tempArr != null && tempArr.size() > 0) {
            tempArr.forEach(obj -> {
                OnlDragPageComp onlDragPageComp;
                JSONObject jsonObject = (JSONObject)obj;
                String pageCompId = jsonObject.getString("pageCompId");
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)pageCompId) && (onlDragPageComp = this.onlDragPageCompDao.get(pageCompId)) != null) {
                    String component = onlDragPageComp.getComponent();
                    String config = onlDragPageComp.getConfig();
                    JSONObject compConfigObj = JSONObject.parseObject((String)config);
                    if ("JCustomButton".equals(component)) {
                        JSONArray btnArr = compConfigObj.getJSONArray("chartData");
                        if (btnArr != null && btnArr.size() > 0) {
                            for (int i2 = 0; i2 < btnArr.size(); ++i2) {
                                JSONObject bizFlow;
                                String key;
                                JSONObject worksheet;
                                JSONObject btn = (JSONObject)btnArr.get(i2);
                                String operationType = btn.getString("operationType");
                                if ("1".equals(operationType) || "2".equals(operationType)) {
                                    String view;
                                    worksheet = btn.getJSONObject("worksheet");
                                    if (worksheet == null) continue;
                                    key = worksheet.getString("key");
                                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)key) && formCodeMap.containsKey(key)) {
                                        worksheet.put("key", formCodeMap.get(key));
                                        worksheet.put("value", formCodeMap.get(key));
                                    }
                                    if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(view = btn.getString("view"))) || !viewIdMap.containsKey(view)) continue;
                                    worksheet.put("view", viewIdMap.get(view));
                                    continue;
                                }
                                if ("3".equals(operationType)) {
                                    worksheet = btn.getJSONObject("customPage");
                                    if (worksheet == null || !org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(key = worksheet.getString("key"))) || !dragIdMap.containsKey(key)) continue;
                                    worksheet.put("key", dragIdMap.get(key));
                                    worksheet.put("value", dragIdMap.get(key));
                                    continue;
                                }
                                if (!"6".equals(operationType) || (bizFlow = btn.getJSONObject("bizFlow")) == null || !org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(key = bizFlow.getString("key"))) || !bpmIdMap.containsKey(key)) continue;
                                bizFlow.put("key", bpmIdMap.get(key));
                                bizFlow.put("value", bpmIdMap.get(key));
                            }
                        }
                    } else if ("JCarousel".equals(component)) {
                        String key;
                        JSONObject worksheet = compConfigObj.getJSONObject("worksheet");
                        if (worksheet != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(key = worksheet.getString("key"))) && formCodeMap.containsKey(key)) {
                            worksheet.put("key", formCodeMap.get(key));
                            worksheet.put("value", formCodeMap.get(key));
                        }
                    } else {
                        String formId = compConfigObj.getString("formId");
                        String appId = compConfigObj.getString("appId");
                        String appType = compConfigObj.getString("appType");
                        String tableName = compConfigObj.getString("tableName");
                        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)formId) && formCodeMap.containsKey(formId)) {
                            compConfigObj.put("formId", formCodeMap.get(formId));
                            compConfigObj.put("tableName", formCodeMap.get(tableName));
                        }
                        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)appType) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)appId) && appType.equals("current")) {
                            compConfigObj.put("appId", (Object)onlDragPage.getLowAppId());
                        }
                    }
                    onlDragPageComp.setConfig(compConfigObj.toJSONString());
                    this.onlDragPageCompDao.update(onlDragPageComp);
                }
            });
        }
    }

    @Override
    public void updateVisitsNum(String id, Integer increaseCount) {
        OnlDragPage onlDragPageVisitsNum = this.getByIdForVisitsNum(id);
        if (null != onlDragPageVisitsNum) {
            int visits = h.a((Object)onlDragPageVisitsNum.getVisitsNum(), 0);
            int totalValue = increaseCount + visits;
            onlDragPageVisitsNum.setVisitsNum(totalValue);
            this.onlDragPageDao.updateVisitsNum(onlDragPageVisitsNum);
        }
    }

    @Override
    public void removeOne(String id) {
        OnlDragPage onlDragPage = new OnlDragPage();
        onlDragPage.setDelFlag(org.jeecg.modules.drag.a.a.g);
        onlDragPage.setId(id);
        this.onlDragPageDao.update(onlDragPage);
    }

    @Override
    public void recoveryDelete(String id) {
        OnlDragPage onlDragPage = new OnlDragPage();
        onlDragPage.setDelFlag(org.jeecg.modules.drag.a.a.h);
        onlDragPage.setId(id);
        this.onlDragPageDao.update(onlDragPage);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void clearRecovery(OnlDragPage onlDragPage) {
        List<String> ids = this.onlDragPageDao.queryIdList(onlDragPage);
        if (!CollectionUtils.isEmpty(ids)) {
            this.onlDragPageCompDao.deleteByPageIds(ids);
            this.onlDragPageDao.deleteByIds(ids);
        }
    }

    @Override
    public Map<String, Integer> getCount() {
        HashMap<String, Integer> map = new HashMap<String, Integer>(4);
        Integer pageNum = this.onlDragPageDao.countByStyle("default");
        Integer bigScreenNum = this.onlDragPageDao.countByStyle("bigScreen");
        map.put("pageNum", pageNum);
        map.put("bigScreenNum", bigScreenNum);
        return map;
    }

    private List<OnlDragPageComp> a(OnlDragPage targetPage) {
        ArrayList<OnlDragPageComp> onlDragPageCompList = new ArrayList<OnlDragPageComp>();
        String template = targetPage.getTemplate();
        JSONArray array = JSONArray.parseArray((String)template);
        if (array != null) {
            array.forEach(obj -> {
                JSONObject jsonObject = (JSONObject)obj;
                String pageCompId = jsonObject.getString("pageCompId");
                OnlDragPageComp onlDragPageComp = this.onlDragPageCompDao.get(pageCompId);
                if (onlDragPageComp != null) {
                    onlDragPageComp.setId(null);
                    onlDragPageComp.setPageId(targetPage.getId());
                    onlDragPageComp.setCreateTime(new Date());
                    this.onlDragPageCompDao.insert(onlDragPageComp);
                    jsonObject.put("pageCompId", (Object)onlDragPageComp.getId());
                }
            });
            targetPage.setTemplate(array.toJSONString());
            return onlDragPageCompList;
        }
        return null;
    }

    public void a(JSONArray array, String pageId) {
        for (int i2 = 0; i2 < array.size(); ++i2) {
            JSONObject json = array.getJSONObject(i2);
            OnlDragPageComp opc = new OnlDragPageComp();
            opc.setComponent(json.getString("component"));
            opc.setConfig(json.containsKey((Object)"config") ? json.getString("config") : "");
            opc.setPageId(pageId);
            this.onlDragPageCompDao.insert(opc);
            json.put("pageCompId", (Object)opc.getId());
            if (!json.containsKey((Object)"config")) continue;
            json.remove((Object)"config");
        }
    }

    @Override
    public DragPage<OnlDragPage> pageList(OnlDragPage onlDragPage, Integer pageNo, Integer pageSize) {
        MiniDaoPage<OnlDragPage> pageList = this.onlDragPageDao.pageList(onlDragPage, pageNo, pageSize);
        DragPage<OnlDragPage> list = new DragPage<OnlDragPage>(pageList);
        return list;
    }

    @Override
    public OnlDragPage getById(String id) {
        return this.onlDragPageDao.get(id);
    }

    @Override
    public OnlDragPage getByIdForVisitsNum(String id) {
        return this.onlDragPageDao.getByIdForVisitsNum(id);
    }

    @Override
    public Map getShareInfo(String id, String type) {
        HashMap<String, String> map = new HashMap<String, String>(2);
        OnlDragPage onlDragPage = this.onlDragPageDao.get(id);
        map.put("title", onlDragPage.getName());
        map.put("path", onlDragPage.getPath());
        map.put("shareInfo", null);
        return map;
    }

    @Override
    public OnlDragPage getPageById(String id) {
        return this.onlDragPageDao.getById(id);
    }

    @Override
    public Integer count() {
        return this.onlDragPageDao.count();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveCompToPage(OnlDragPage onlDragPage) {
        this.onlDragPageDao.update(onlDragPage);
        String key = String.format("drag:cache:page::%s", onlDragPage.getId());
        if (this.redisUtil.a(key)) {
            this.redisUtil.a(new String[]{key});
        }
    }
}

