/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.drag.config.websocket;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.PostConstruct;
import jakarta.websocket.OnClose;
import jakarta.websocket.OnError;
import jakarta.websocket.OnMessage;
import jakarta.websocket.OnOpen;
import jakarta.websocket.Session;
import jakarta.websocket.server.PathParam;
import jakarta.websocket.server.ServerEndpoint;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.jeecg.common.base.BaseMap;
import org.jeecg.modules.drag.config.a.a.a;
import org.jeecg.modules.drag.util.h;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.stereotype.Component;
import org.springframework.util.ErrorHandler;

@Component(value="dragWebSocket")
@ServerEndpoint(value="/websocket/drag/{chartId}")
public class DragWebSocket {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DragWebSocket.class);
    private static ConcurrentHashMap<String, Session> sessionPool = new ConcurrentHashMap();
    public static final String REDIS_TOPIC_NAME = "dragSocketHandler";
    private static a jmDragRedisClient;

    @Autowired
    private void setJeecgRedisClient(a jmDragRedisClient) {
        DragWebSocket.jmDragRedisClient = jmDragRedisClient;
    }

    @OnOpen
    public void onOpen(Session session, @PathParam(value="chartId") String chartId) {
        try {
            sessionPool.put(chartId, session);
            log.debug("\u3010\u4eea\u8868\u76d8 WebSocket\u3011\u6709\u65b0\u7684\u8fde\u63a5\uff0c\u603b\u6570\u4e3a:" + sessionPool.size());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @OnClose
    public void onClose(@PathParam(value="chartId") String chartId) {
        try {
            sessionPool.remove(chartId);
            log.debug("\u3010\u4eea\u8868\u76d8 WebSocket\u3011\u8fde\u63a5\u65ad\u5f00\uff0c\u603b\u6570\u4e3a:" + sessionPool.size());
        }
        catch (Exception e2) {
            log.warn(e2.getMessage(), (Throwable)e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushMessage(String chartId, String message) {
        for (Map.Entry<String, Session> item : sessionPool.entrySet()) {
            if (!item.getKey().contains(chartId)) continue;
            Session session = item.getValue();
            try {
                Session session2 = session;
                synchronized (session2) {
                    log.debug("\u3010\u4eea\u8868\u76d8 WebSocket\u3011\u63a8\u9001\u5355\u4eba\u6d88\u606f:" + message);
                    session.getBasicRemote().sendText(message);
                }
            }
            catch (Exception e2) {
                log.error(e2.getMessage(), (Throwable)e2);
            }
        }
    }

    @OnMessage
    public void onMessage(String message) {
        if (!"ping".equals(message) && !"heartcheck".equals(message)) {
            log.debug("\u3010\u4eea\u8868\u76d8 WebSocket\u3011\u6536\u5230\u5ba2\u6237\u7aef\u6d88\u606f:" + message);
        } else {
            log.debug("\u3010\u4eea\u8868\u76d8 WebSocket\u3011\u6536\u5230\u5ba2\u6237\u7aef\u6d88\u606f:" + message);
        }
    }

    @OnError
    public void onError(Session session, Throwable t) {
        log.warn("\u3010\u4eea\u8868\u76d8 WebSocket\u3011\u6d88\u606f\u51fa\u73b0\u9519\u8bef");
        t.printStackTrace();
    }

    public void sendMessage(String chartId, String message) {
        BaseMap baseMap = new BaseMap();
        baseMap.put("chartId", (Object)chartId);
        baseMap.put("message", (Object)message);
        jmDragRedisClient.a(REDIS_TOPIC_NAME, baseMap);
    }

    @Lazy(value=false)
    @Component(value="dragSocketHandler")
    class RedisSocketHandler
    implements MessageListener {
        @Autowired(required=false)
        private RedisMessageListenerContainer container;
        private final DragWebSocket dragWebSocket;

        public RedisSocketHandler(DragWebSocket dragWebSocket) {
            this.dragWebSocket = dragWebSocket;
        }

        @PostConstruct
        public void subscribeToChannel() {
            if (this.container != null) {
                this.container.addMessageListener((MessageListener)this, (Topic)new ChannelTopic("drag_redis_topic"));
                this.container.setErrorHandler(new ErrorHandler(){

                    public void handleError(Throwable t) {
                        log.warn("\u6d88\u606f\u76d1\u542c\u5668\u4e2d\u7684\u9519\u8bef: " + t.getMessage());
                    }
                });
            }
        }

        public void onMessage(Message messageObj, byte[] bytes) {
            String messageBody = new String(messageObj.getBody(), StandardCharsets.UTF_8);
            try {
                Map map;
                Object[] realMessageBody;
                ObjectMapper objectMapper = new ObjectMapper();
                if (h.d(messageObj) && h.d(realMessageBody = (Object[])objectMapper.readValue(messageBody, Object[].class)) && h.d(map = (Map)objectMapper.convertValue(realMessageBody[1], HashMap.class)) && map.containsKey("chartId")) {
                    String chartId = map.get("chartId").toString();
                    String message = map.get("message").toString();
                    this.dragWebSocket.pushMessage(chartId, message);
                }
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        }
    }
}

