/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.drag.b;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import jakarta.servlet.http.HttpServletRequest;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jeecg.modules.drag.config.common.Result;
import org.jeecg.modules.drag.config.page.DragPage;
import org.jeecg.modules.drag.entity.OnlDragDataSource;
import org.jeecg.modules.drag.service.IOnlDragDataSourceService;
import org.jeecg.modules.drag.service.IOnlDragExternalService;
import org.jeecg.modules.drag.util.a;
import org.jeecg.modules.drag.util.e;
import org.jeecg.modules.drag.util.f;
import org.jeecg.modules.drag.util.l;
import org.jeecg.modules.drag.vo.DynamicDataSourceVo;
import org.jeecg.modules.jmreport.common.annotation.RequiresPermissions;
import org.jeecg.modules.jmreport.config.JmReportBaseConfig;
import org.jeecg.modules.jmreport.config.client.JmReportTokenClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="onlDragDataSourceController")
@RequestMapping(value={"/drag/onlDragDataSource"})
public class h {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(h.class);
    @Autowired
    private IOnlDragDataSourceService onlDragDataSourceService;
    @Autowired
    private e localCache;
    @Autowired
    private f redisUtil;
    @Autowired
    private JmReportBaseConfig jmBaseConfig;
    @Lazy
    @Autowired
    private JmReportTokenClient dragTokenClient;
    @Autowired
    @Lazy
    private IOnlDragExternalService onlDragExternalService;

    @GetMapping(value={"/list"})
    public Result<?> a(OnlDragDataSource onlDragDataSource, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        String username = this.dragTokenClient.getUsername(req);
        if ("created".equals(this.jmBaseConfig.getSaasMode())) {
            onlDragDataSource.setCreateBy(username);
        } else if ("tenant".equals(this.jmBaseConfig.getSaasMode())) {
            String tenantId = org.jeecg.modules.drag.util.h.c(this.dragTokenClient.getTenantId());
            if (org.jeecg.modules.drag.util.h.c((Object)tenantId)) {
                tenantId = org.jeecg.modules.drag.util.h.c(l.b(req));
            }
            onlDragDataSource.setTenantId(tenantId);
        }
        if (org.jeecg.modules.drag.util.h.d((Object)onlDragDataSource.getName())) {
            String name = onlDragDataSource.getName();
            onlDragDataSource.setName(org.jeecg.modules.drag.util.a.b(name));
        }
        DragPage<OnlDragDataSource> pageList = this.onlDragDataSourceService.pageList(onlDragDataSource, pageNo, pageSize);
        return Result.OK(pageList);
    }

    @PostMapping(value={"/add"})
    public Result<?> a(@RequestBody OnlDragDataSource onlDragDataSource, HttpServletRequest request) {
        Result result;
        String username = this.dragTokenClient.getUsername(request);
        Integer count = this.onlDragDataSourceService.count(onlDragDataSource);
        if (count >= 100) {
            String encodedString = "5L+d5a2Y5aSx6LSl77yM5YWN6LS554mI5pyA5aSa5Yib5bu6ezB95p2h5pWw5o2u5rqQ6L+e5o6l77yM6K+35Y2H57qn5ZWG5Lia54mI77yB";
            byte[] decodedBytes = Base64.getDecoder().decode(encodedString);
            String decodedString = new String(decodedBytes);
            String tipMsg = MessageFormat.format(decodedString, 100);
            return Result.error(tipMsg);
        }
        if (StringUtils.isNotBlank((CharSequence)username)) {
            onlDragDataSource.setCreateBy(username);
        }
        if (!(result = org.jeecg.modules.drag.util.h.g(onlDragDataSource.getDbUrl())).isSuccess()) {
            return result;
        }
        this.onlDragDataSourceService.save(onlDragDataSource);
        return Result.OK("\u6dfb\u52a0\u6210\u529f\uff01", onlDragDataSource.getId());
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.PUT, RequestMethod.POST})
    public Result<?> b(@RequestBody OnlDragDataSource onlDragDataSource, HttpServletRequest request) {
        String username = this.dragTokenClient.getUsername(request);
        Result result = org.jeecg.modules.drag.util.h.g(onlDragDataSource.getDbUrl());
        if (!result.isSuccess()) {
            return result;
        }
        this.onlDragDataSourceService.updateById(onlDragDataSource);
        String dbId = onlDragDataSource.getId();
        try {
            String dbConnErrorKey = String.format("drag:error:dbconn:%s", dbId);
            this.redisUtil.a(new String[]{dbConnErrorKey});
            org.jeecg.modules.drag.config.dynamicdb.a.b(dbId);
        }
        catch (Exception e2) {
            a.warn("\u4eea\u8868\u76d8-\u6570\u636e\u6e90-\u6e05\u7406\u6570\u636e\u6e90\u7f13\u5b58\u5931\u8d25" + e2.getMessage());
        }
        String logMsg = "\u4fee\u6539\u6570\u636e\u5e93\u8fde\u63a5ID:" + dbId + " ,\u8fde\u63a5\u540d\u5b57: " + onlDragDataSource.getName() + "\uff0c\u64cd\u4f5c\u4eba\uff1a " + username;
        this.onlDragExternalService.addLog(logMsg, 2, 2);
        return Result.OK("\u7f16\u8f91\u6210\u529f!", dbId);
    }

    @DeleteMapping(value={"/delete"})
    public Result<?> a(@RequestParam(name="id", required=true) String id) {
        this.onlDragDataSourceService.removeById(id);
        try {
            String dbConnErrorKey = String.format("drag:error:dbconn:%s", id);
            this.redisUtil.a(new String[]{dbConnErrorKey});
        }
        catch (Exception e2) {
            a.warn("\u4eea\u8868\u76d8-\u6570\u636e\u6e90-\u6e05\u7406\u6570\u636e\u6e90\u7f13\u5b58\u5931\u8d25" + e2.getMessage());
        }
        org.jeecg.modules.drag.config.dynamicdb.a.b(id);
        return Result.OK("\u5220\u9664\u6210\u529f!");
    }

    @DeleteMapping(value={"/deleteBatch"})
    public Result<?> b(@RequestParam(name="ids", required=true) String ids) {
        this.onlDragDataSourceService.removeByIds(Arrays.asList(ids.split(",")));
        return Result.OK("\u6279\u91cf\u5220\u9664\u6210\u529f\uff01");
    }

    @GetMapping(value={"/queryById"})
    public Result<?> c(@RequestParam(name="id", required=true) String id) {
        OnlDragDataSource onlDragDataSource = this.onlDragDataSourceService.getById(id);
        return Result.OK(onlDragDataSource);
    }

    @GetMapping(value={"/queryByReportId"})
    public Result<?> d(@RequestParam(name="reportId", required=true) String reportId) {
        OnlDragDataSource onlDragDataSource = this.onlDragDataSourceService.getByReportId(reportId);
        return Result.OK(onlDragDataSource);
    }

    @GetMapping(value={"/getOptions"})
    public Result<?> c(OnlDragDataSource onlDragDataSource, HttpServletRequest req) {
        String username = this.dragTokenClient.getUsername(req);
        if ("created".equals(this.jmBaseConfig.getSaasMode())) {
            onlDragDataSource.setCreateBy(username);
        } else if ("tenant".equals(this.jmBaseConfig.getSaasMode())) {
            String tenantId = org.jeecg.modules.drag.util.h.c(this.dragTokenClient.getTenantId());
            if (org.jeecg.modules.drag.util.h.c((Object)tenantId)) {
                tenantId = org.jeecg.modules.drag.util.h.a(l.b(req), "-1");
            }
            onlDragDataSource.setTenantId(tenantId);
        }
        List<OnlDragDataSource> list = this.onlDragDataSourceService.getAll(onlDragDataSource);
        JSONArray array = new JSONArray(list.size());
        for (OnlDragDataSource item : list) {
            JSONObject option = new JSONObject(3);
            option.put("value", (Object)item.getId());
            option.put("label", (Object)item.getName());
            option.put("text", (Object)item.getName());
            array.add((Object)option);
        }
        return Result.ok(array);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermissions(value={"drag:datasource:testConnection"})
    @PostMapping(value={"/testConnection"})
    public Result a(@RequestBody DynamicDataSourceVo dbSource) {
        Result result = org.jeecg.modules.drag.util.h.g(dbSource.getDbUrl());
        if (!result.isSuccess()) {
            return result;
        }
        Connection conn = null;
        String key = dbSource.toString();
        Object connetTimes = this.localCache.a(key);
        if (org.jeecg.modules.drag.util.h.d(connetTimes)) {
            int connetTime = org.jeecg.modules.drag.util.h.e(connetTimes);
            if (connetTime >= 3) {
                return Result.error("\u6570\u636e\u6e90\u5df2\u8fde\u63a5\u9519\u8bef3\u6b21\u4ee5\u4e0a,\u8bf7\u68c0\u67e5\u914d\u7f6e\u4fe1\u606f\uff01");
            }
            if (connetTime == 0) {
                return Result.OK("\u6570\u636e\u5e93\u8fde\u63a5\u6210\u529f", true);
            }
        } else {
            this.localCache.a(key, 0, 3600000L);
        }
        try {
            Class.forName(dbSource.getDbDriver());
            DriverManager.setLoginTimeout(60);
            String dbUrl = org.jeecg.modules.drag.util.a.a.g(dbSource.getDbUrl());
            conn = DriverManager.getConnection(dbUrl, dbSource.getDbUsername(), dbSource.getDbPassword());
            if (conn != null) {
                Result<Boolean> result2 = Result.OK("\u6570\u636e\u5e93\u8fde\u63a5\u6210\u529f", true);
                return result2;
            }
            this.localCache.a(key, 1);
            Result<Boolean> result3 = Result.OK("\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25\uff1a\u9519\u8bef\u672a\u77e5", true);
            return result3;
        }
        catch (ClassNotFoundException e2) {
            a.error(e2.toString(), (Throwable)e2);
            this.localCache.a(key, 1);
            Result result4 = Result.error("\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25\uff1a\u9a71\u52a8\u7c7b\u4e0d\u5b58\u5728");
            return result4;
        }
        catch (Exception e3) {
            a.error(e3.toString(), (Throwable)e3);
            this.localCache.a(key, 1);
            Result result5 = Result.error("\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25\uff1a" + e3.getMessage());
            return result5;
        }
        finally {
            try {
                if (conn != null && !conn.isClosed()) {
                    conn.close();
                }
            }
            catch (SQLException e4) {
                a.error(e4.toString(), (Throwable)e4);
            }
        }
    }
}

