/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.console.reflect;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.javasimon.console.SimonTypeFactory;
import org.javasimon.console.reflect.Getter;

public class GetterFactory {
    private static final Map<Class, Map<String, Getter>> GETTER_CACHE = new HashMap<Class, Map<String, Getter>>();
    private static final Properties subTypeProperties = new Properties();

    private static boolean isGetterMethod(Method method) {
        return !Modifier.isStatic(method.getModifiers()) && (method.getName().startsWith("get") || method.getName().startsWith("is")) && method.getParameterTypes().length == 0;
    }

    private static String getPropertyName(Method method) {
        String propertyName = method.getName();
        if (propertyName.startsWith("get")) {
            propertyName = propertyName.substring(3);
        } else if (propertyName.startsWith("is")) {
            propertyName = propertyName.substring(2);
        }
        propertyName = propertyName.substring(0, 1).toLowerCase() + propertyName.substring(1);
        return propertyName;
    }

    private static String getSubType(Class type, String propertyName) {
        Class normalizedType = SimonTypeFactory.normalizeType(type);
        if (normalizedType == null) {
            return null;
        }
        return subTypeProperties.getProperty(normalizedType.getName() + "." + propertyName);
    }

    public static Collection<Getter> getGetters(Class type) {
        return GetterFactory.getGettersAsMap(type).values();
    }

    private static Map<String, Getter> getGettersAsMap(Class type) {
        Map<String, Getter> typeGetters = GETTER_CACHE.get(type);
        if (typeGetters == null) {
            typeGetters = new HashMap<String, Getter>();
            for (Method method : type.getMethods()) {
                if (!GetterFactory.isGetterMethod(method)) continue;
                String propertyName = GetterFactory.getPropertyName(method);
                Class<?> propertyType = method.getReturnType();
                typeGetters.put(propertyName, new Getter(propertyName, propertyType, GetterFactory.getSubType(type, propertyName), method));
            }
            GETTER_CACHE.put(type, typeGetters);
        }
        return typeGetters;
    }

    public static Getter getGetter(Class type, String name) {
        return GetterFactory.getGettersAsMap(type).get(name);
    }

    static {
        try {
            InputStream inputStream = GetterFactory.class.getResourceAsStream("SubTypes.properties");
            subTypeProperties.load(inputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

