/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.console;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.javasimon.console.Action;
import org.javasimon.console.ActionBinding;
import org.javasimon.console.ActionContext;

public class SimpleActionBinding<T extends Action>
implements ActionBinding<T> {
    private final String path;
    private final Class<T> actionClass;
    private final Constructor<T> actionConstructor;

    public SimpleActionBinding(String path, Class<T> actionClass) {
        Constructor<T> constructor;
        this.path = path;
        this.actionClass = actionClass;
        try {
            try {
                constructor = actionClass.getConstructor(ActionContext.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                constructor = actionClass.getConstructor(new Class[0]);
            }
        }
        catch (SecurityException securityException) {
            throw new IllegalStateException("Can get constructor for class " + actionClass.getName(), securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException("Can find constructor for class " + actionClass.getName());
        }
        this.actionConstructor = constructor;
    }

    @Override
    public boolean supports(ActionContext actionContext) {
        return actionContext.getPath().equals(this.path);
    }

    @Override
    public T create(ActionContext actionContext) {
        try {
            Action action;
            Class<?>[] actionConstructorParams = this.actionConstructor.getParameterTypes();
            switch (actionConstructorParams.length) {
                case 0: {
                    action = (Action)this.actionConstructor.newInstance(new Object[0]);
                    break;
                }
                case 1: {
                    if (actionConstructorParams[0].equals(ActionContext.class)) {
                        action = (Action)this.actionConstructor.newInstance(actionContext);
                        break;
                    }
                    throw new IllegalStateException("Unknown argument type in action constructor " + actionConstructorParams[0].getName());
                }
                default: {
                    throw new IllegalStateException("Invalid argument number in action constructor: " + actionConstructorParams.length);
                }
            }
            return (T)action;
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalStateException("Failed to create action", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException("Failed to create action", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IllegalStateException("Failed to create action", invocationTargetException);
        }
    }

    public Constructor<T> getActionConstructor() {
        return this.actionConstructor;
    }

    public Class<T> getActionClass() {
        return this.actionClass;
    }

    public String getPath() {
        return this.path;
    }
}

