/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.console;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.javasimon.console.ActionBinding;
import org.javasimon.console.SimonConsolePlugin;

public class SimonConsolePluginManager {
    private final List<SimonConsolePlugin> plugins = new ArrayList<SimonConsolePlugin>();

    public List<SimonConsolePlugin> getPlugins() {
        return Collections.unmodifiableList(this.plugins);
    }

    public <T extends SimonConsolePlugin> List<T> getPluginsByType(Class<T> pluginType) {
        ArrayList<T> specPlugins = new ArrayList<T>();
        for (SimonConsolePlugin plugin : this.plugins) {
            if (!pluginType.isInstance(plugin)) continue;
            specPlugins.add(pluginType.cast(plugin));
        }
        return Collections.unmodifiableList(specPlugins);
    }

    public SimonConsolePlugin getPluginById(String id) {
        for (SimonConsolePlugin plugin : this.plugins) {
            if (!plugin.getId().equals(id)) continue;
            return plugin;
        }
        return null;
    }

    public void addPlugin(SimonConsolePlugin plugin) {
        SimonConsolePlugin existingPlugin = this.getPluginById(plugin.getId());
        if (existingPlugin != null) {
            throw new IllegalArgumentException("Plugin " + plugin.getId() + " already registered");
        }
        this.plugins.add(plugin);
    }

    public <T extends SimonConsolePlugin> void addPlugin(Class<T> pluginType) {
        try {
            SimonConsolePlugin plugin = (SimonConsolePlugin)pluginType.newInstance();
            this.addPlugin(plugin);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("Invalid plugin type " + pluginType.getName(), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Invalid plugin type " + pluginType.getName(), illegalAccessException);
        }
    }

    public void addPlugin(String pluginTypeName) {
        try {
            Class<?> pluginType = Class.forName(pluginTypeName);
            if (!SimonConsolePlugin.class.isAssignableFrom(pluginType)) {
                throw new IllegalArgumentException("Invalid plugin type " + pluginTypeName);
            }
            this.addPlugin(pluginType);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Invalid plugin type " + pluginTypeName, classNotFoundException);
        }
    }

    public void addPlugins(String pluginTypeNames) {
        String[] pluginTypeNameList;
        for (String pluginTypeName : pluginTypeNameList = pluginTypeNames.split(",")) {
            if ((pluginTypeName = pluginTypeName.trim()).equals("")) continue;
            this.addPlugin(pluginTypeName);
        }
    }

    public boolean removePluginById(String id) {
        SimonConsolePlugin plugin = this.getPluginById(id);
        if (plugin == null) {
            return false;
        }
        return this.plugins.remove(plugin);
    }

    public List<ActionBinding> getActionBindings() {
        ArrayList<ActionBinding> actionBindings = new ArrayList<ActionBinding>();
        for (SimonConsolePlugin plugin : this.plugins) {
            actionBindings.addAll(plugin.getActionBindings());
        }
        return Collections.unmodifiableList(actionBindings);
    }
}

