/*
 * Decompiled with CFR 0.152.
 */
package org.isomorphism.util;

import com.google.common.base.Ticker;
import java.util.concurrent.TimeUnit;
import org.isomorphism.util.TokenBucket;

public class FixedIntervalRefillStrategy
implements TokenBucket.RefillStrategy {
    private final Ticker ticker;
    private final long numTokensPerPeriod;
    private final long periodDurationInNanos;
    private long lastRefillTime;
    private long nextRefillTime;

    public FixedIntervalRefillStrategy(Ticker ticker, long numTokensPerPeriod, long period, TimeUnit unit) {
        this.ticker = ticker;
        this.numTokensPerPeriod = numTokensPerPeriod;
        this.periodDurationInNanos = unit.toNanos(period);
        this.lastRefillTime = -this.periodDurationInNanos;
        this.nextRefillTime = -this.periodDurationInNanos;
    }

    public synchronized long refill() {
        long now = this.ticker.read();
        if (now < this.nextRefillTime) {
            return 0L;
        }
        long numPeriods = Math.max(0L, (now - this.lastRefillTime) / this.periodDurationInNanos);
        this.lastRefillTime += numPeriods * this.periodDurationInNanos;
        this.nextRefillTime = this.lastRefillTime + this.periodDurationInNanos;
        return numPeriods * this.numTokensPerPeriod;
    }

    public long getDurationUntilNextRefill(TimeUnit unit) {
        long now = this.ticker.read();
        return unit.convert(Math.max(0L, this.nextRefillTime - now), TimeUnit.NANOSECONDS);
    }
}

