/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.AbstractVisitor;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.functional.ReadWriteManyCommand;
import org.infinispan.commands.functional.ReadWriteManyEntriesCommand;
import org.infinispan.commands.functional.WriteOnlyKeyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyValueCommand;
import org.infinispan.commands.functional.WriteOnlyManyCommand;
import org.infinispan.commands.functional.WriteOnlyManyEntriesCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.ComputeCommand;
import org.infinispan.commands.write.ComputeIfAbsentCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.BaseCustomAsyncInterceptor;
import org.infinispan.interceptors.InvocationStage;
import org.infinispan.interceptors.SyncInvocationStage;
import org.infinispan.marshall.protostream.impl.SerializationContextRegistry;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.descriptors.FileDescriptor;
import org.infinispan.query.remote.ProtobufMetadataManager;
import org.infinispan.query.remote.impl.ProtobufMetadataManagerImpl;
import org.infinispan.query.remote.impl.logging.Log;
import org.infinispan.util.concurrent.AggregateCompletionStage;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.CompletionStages;

final class ProtobufMetadataManagerInterceptor
extends BaseCustomAsyncInterceptor {
    private static final Log log = (Log)LogFactory.getLog(ProtobufMetadataManagerInterceptor.class, Log.class);
    private static final Metadata DEFAULT_METADATA = new EmbeddedMetadata.Builder().build();
    private CommandsFactory commandsFactory;
    private ComponentRef<AsyncInterceptorChain> invoker;
    private SerializationContext serializationContext;
    private KeyPartitioner keyPartitioner;
    private SerializationContextRegistry serializationContextRegistry;
    private static final FileDescriptorSource.ProgressCallback EMPTY_CALLBACK = new FileDescriptorSource.ProgressCallback(){};
    private final AbstractVisitor serializationContextUpdaterVisitor = new AbstractVisitor(){

        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) {
            String key = (String)command.getKey();
            if (ProtobufMetadataManagerInterceptor.this.shouldIntercept(key)) {
                ProtobufMetadataManagerInterceptor.this.registerProtoFile(key, (String)command.getValue());
            }
            return null;
        }

        public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) {
            Map map = command.getMap();
            FileDescriptorSource source = new FileDescriptorSource().withProgressCallback(EMPTY_CALLBACK);
            FileDescriptorSource ctxRegistrySource = new FileDescriptorSource();
            for (Object key : map.keySet()) {
                if (!ProtobufMetadataManagerInterceptor.this.shouldIntercept(key)) continue;
                source.addProtoFile((String)key, (String)map.get(key));
                ctxRegistrySource.addProtoFile((String)key, (String)map.get(key));
            }
            try {
                ProtobufMetadataManagerInterceptor.this.serializationContext.registerProtoFiles(source);
                ProtobufMetadataManagerInterceptor.this.registerWithContextRegistry(ctxRegistrySource);
            }
            catch (DescriptorParserException e) {
                throw log.failedToParseProtoFile(e);
            }
            return null;
        }

        public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) {
            String key = (String)command.getKey();
            if (ProtobufMetadataManagerInterceptor.this.shouldIntercept(key)) {
                ProtobufMetadataManagerInterceptor.this.registerProtoFile(key, (String)command.getNewValue());
            }
            return null;
        }

        public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) {
            String key = (String)command.getKey();
            if (ProtobufMetadataManagerInterceptor.this.shouldIntercept(key) && ProtobufMetadataManagerInterceptor.this.serializationContext.getFileDescriptors().containsKey(key)) {
                ProtobufMetadataManagerInterceptor.this.serializationContext.unregisterProtoFile(key);
            }
            return null;
        }

        public Object visitClearCommand(InvocationContext ctx, ClearCommand command) {
            for (String fileName : ProtobufMetadataManagerInterceptor.this.serializationContext.getFileDescriptors().keySet()) {
                ProtobufMetadataManagerInterceptor.this.serializationContext.unregisterProtoFile(fileName);
            }
            return null;
        }
    };

    ProtobufMetadataManagerInterceptor() {
    }

    private void registerProtoFile(String name, String content) {
        this.registerProtoFile(name, content, EMPTY_CALLBACK);
    }

    private void registerProtoFile(String name, String content, FileDescriptorSource.ProgressCallback callback) {
        try {
            this.serializationContext.registerProtoFiles(new FileDescriptorSource().withProgressCallback(callback).addProtoFile(name, content));
            this.registerWithContextRegistry(new FileDescriptorSource().addProtoFile(name, content));
        }
        catch (DescriptorParserException e) {
            if (name == null) {
                throw log.failedToParseProtoFile(e);
            }
            throw log.failedToParseProtoFile(name, e);
        }
    }

    private void registerWithContextRegistry(FileDescriptorSource source) {
        try {
            this.serializationContextRegistry.addProtoFile(SerializationContextRegistry.MarshallerType.GLOBAL, source);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Inject
    public void init(CommandsFactory commandsFactory, ComponentRef<AsyncInterceptorChain> invoker, KeyPartitioner keyPartitioner, ProtobufMetadataManager protobufMetadataManager, SerializationContextRegistry serializationContextRegistry) {
        this.commandsFactory = commandsFactory;
        this.invoker = invoker;
        this.keyPartitioner = keyPartitioner;
        this.serializationContext = ((ProtobufMetadataManagerImpl)protobufMetadataManager).getSerializationContext();
        this.serializationContextRegistry = serializationContextRegistry;
    }

    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) {
        return this.invokeNextThenAccept((InvocationContext)ctx, (VisitableCommand)command, (rCtx, rCommand, rv) -> {
            if (!rCtx.isOriginLocal()) {
                for (WriteCommand wc : rCommand.getModifications()) {
                    wc.acceptVisitor(rCtx, (Visitor)this.serializationContextUpdaterVisitor);
                }
            }
        });
    }

    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) {
        CompletableFuture stage;
        Object key = command.getKey();
        if (!(key instanceof String)) {
            throw log.keyMustBeString(key.getClass());
        }
        if (!this.shouldIntercept(key)) {
            return this.invokeNext(ctx, (VisitableCommand)command);
        }
        if (ctx.isOriginLocal() && !command.hasAnyFlag(FlagBitSets.PUT_FOR_STATE_TRANSFER | FlagBitSets.SKIP_LOCKING)) {
            if (!((String)key).endsWith(".proto")) {
                throw log.keyMustBeStringEndingWithProto(key);
            }
            LockControlCommand cmd = this.commandsFactory.buildLockControlCommand((Object)".errors", command.getFlagsBitSet(), null);
            stage = ((AsyncInterceptorChain)this.invoker.running()).invokeAsync(ctx, (VisitableCommand)cmd);
        } else {
            stage = CompletableFutures.completedNull();
        }
        return ProtobufMetadataManagerInterceptor.makeStage((Object)this.asyncInvokeNext(ctx, (VisitableCommand)command, stage)).thenApply(ctx, (VisitableCommand)command, this::handlePutKeyValueResult);
    }

    private InvocationStage handlePutKeyValueResult(InvocationContext rCtx, PutKeyValueCommand putKeyValueCommand, Object rv) {
        if (putKeyValueCommand.isSuccessful()) {
            Object key = putKeyValueCommand.getKey();
            Object value = rCtx.lookupEntry(key).getValue();
            if (!(value instanceof String)) {
                throw log.valueMustBeString(value.getClass());
            }
            long flagsBitSet = this.copyFlags((FlagAffectedCommand)putKeyValueCommand);
            if (rCtx.isOriginLocal() && !putKeyValueCommand.hasAnyFlag(FlagBitSets.PUT_FOR_STATE_TRANSFER)) {
                ProgressCallback progressCallback = new ProgressCallback(rCtx, flagsBitSet);
                this.registerProtoFile((String)key, (String)value, progressCallback);
                CompletionStage<Void> schemaUpdate = this.updateSchemaErrors(rCtx, progressCallback);
                CompletionStage<Object> errorUpdate = this.updateGlobalErrors(rCtx, progressCallback.getErrorFiles().keySet(), flagsBitSet);
                return ProtobufMetadataManagerInterceptor.asyncValue((CompletionStage)CompletionStages.allOf((CompletionStage[])new CompletionStage[]{schemaUpdate, errorUpdate})).thenApplyMakeStage(rCtx, (VisitableCommand)putKeyValueCommand, (rCtx2, rCommand2, rv2) -> rv);
            }
            this.registerProtoFile((String)key, (String)value);
        }
        return SyncInvocationStage.makeStage((Object)rv);
    }

    CompletionStage<Void> updateSchemaErrors(InvocationContext ctx, ProgressCallback progressCallback) {
        PutKeyValueCommand cmd;
        AggregateCompletionStage aggregateCompletionStage = CompletionStages.aggregateCompletionStage();
        for (Map.Entry<String, DescriptorParserException> errorEntry : progressCallback.getErrorFiles().entrySet()) {
            String errorKeyName = errorEntry.getKey() + ".errors";
            cmd = this.commandsFactory.buildPutKeyValueCommand((Object)errorKeyName, (Object)errorEntry.getValue().getMessage(), this.keyPartitioner.getSegment((Object)errorKeyName), DEFAULT_METADATA, progressCallback.flagsBitSet);
            aggregateCompletionStage.dependsOn((CompletionStage)((AsyncInterceptorChain)this.invoker.running()).invokeAsync(ctx, (VisitableCommand)cmd));
        }
        for (String successKeyName : progressCallback.getSuccessFiles()) {
            String key = successKeyName + ".errors";
            cmd = this.commandsFactory.buildRemoveCommand((Object)key, null, this.keyPartitioner.getSegment((Object)key), progressCallback.flagsBitSet);
            aggregateCompletionStage.dependsOn((CompletionStage)((AsyncInterceptorChain)this.invoker.running()).invokeAsync(ctx, (VisitableCommand)cmd));
        }
        return aggregateCompletionStage.freeze();
    }

    private long copyFlags(FlagAffectedCommand command) {
        return EnumUtil.diffBitSets((long)command.getFlagsBitSet(), (long)FlagBitSets.SKIP_CACHE_STORE);
    }

    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) {
        if (!ctx.isOriginLocal()) {
            return this.invokeNext(ctx, (VisitableCommand)command);
        }
        Map map = command.getMap();
        FileDescriptorSource ctxRegistrySource = new FileDescriptorSource();
        FileDescriptorSource source = new FileDescriptorSource();
        for (Object key : map.keySet()) {
            Object value = map.get(key);
            if (!(key instanceof String)) {
                throw log.keyMustBeString(key.getClass());
            }
            if (!(value instanceof String)) {
                throw log.valueMustBeString(value.getClass());
            }
            if (!this.shouldIntercept(key)) continue;
            if (!((String)key).endsWith(".proto")) {
                throw log.keyMustBeStringEndingWithProto(key);
            }
            source.addProtoFile((String)key, (String)value);
            ctxRegistrySource.addProtoFile((String)key, (String)value);
        }
        LockControlCommand cmd = this.commandsFactory.buildLockControlCommand((Object)".errors", command.getFlagsBitSet(), null);
        CompletableFuture stage = ((AsyncInterceptorChain)this.invoker.running()).invokeAsync(ctx, (VisitableCommand)cmd);
        return ProtobufMetadataManagerInterceptor.makeStage((Object)this.asyncInvokeNext(ctx, (VisitableCommand)command, stage)).thenApply(ctx, (VisitableCommand)command, (rCtx, rCommand, rv) -> {
            long flagsBitSet = this.copyFlags((FlagAffectedCommand)rCommand);
            ProgressCallback progressCallback = null;
            if (rCtx.isOriginLocal()) {
                progressCallback = new ProgressCallback(rCtx, flagsBitSet);
                source.withProgressCallback((FileDescriptorSource.ProgressCallback)progressCallback);
            } else {
                source.withProgressCallback(EMPTY_CALLBACK);
            }
            try {
                this.serializationContext.registerProtoFiles(source);
                this.registerWithContextRegistry(ctxRegistrySource);
            }
            catch (DescriptorParserException e) {
                throw log.failedToParseProtoFile(e);
            }
            if (progressCallback != null) {
                CompletionStage<Void> schemaUpdate = this.updateSchemaErrors(rCtx, progressCallback);
                CompletionStage<Object> errorUpdate = this.updateGlobalErrors(rCtx, progressCallback.getErrorFiles().keySet(), flagsBitSet);
                return ProtobufMetadataManagerInterceptor.asyncValue((CompletionStage)CompletionStages.allOf((CompletionStage[])new CompletionStage[]{schemaUpdate, errorUpdate}));
            }
            return InvocationStage.completedNullStage();
        });
    }

    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) {
        if (!ctx.isOriginLocal()) {
            return this.invokeNext(ctx, (VisitableCommand)command);
        }
        if (!(command.getKey() instanceof String)) {
            throw log.keyMustBeString(command.getKey().getClass());
        }
        String key = (String)command.getKey();
        if (!this.shouldIntercept(key)) {
            return this.invokeNext(ctx, (VisitableCommand)command);
        }
        long flagsBitSet = this.copyFlags((FlagAffectedCommand)command);
        LockControlCommand lockCommand = this.commandsFactory.buildLockControlCommand((Object)".errors", flagsBitSet, null);
        CompletionStage<Object> stage = ((AsyncInterceptorChain)this.invoker.running()).invokeAsync(ctx, (VisitableCommand)lockCommand);
        stage = stage.thenCompose(ignore -> {
            String keyWithSuffix = key + ".errors";
            RemoveCommand writeCommand = this.commandsFactory.buildRemoveCommand((Object)keyWithSuffix, null, this.keyPartitioner.getSegment((Object)keyWithSuffix), flagsBitSet);
            return ((AsyncInterceptorChain)this.invoker.running()).invokeAsync(ctx, (VisitableCommand)writeCommand);
        });
        stage = stage.thenCompose(ignore -> {
            if (this.serializationContext.getFileDescriptors().containsKey(key)) {
                this.serializationContext.unregisterProtoFile(key);
            }
            StringBuilder sb = new StringBuilder();
            AggregateCompletionStage aggregateCompletionStage = CompletionStages.aggregateCompletionStage((Object)sb);
            for (FileDescriptor fd : this.serializationContext.getFileDescriptors().values()) {
                String errorFileName = fd.getName() + ".errors";
                if (fd.isResolved()) {
                    RemoveCommand writeCommand = this.commandsFactory.buildRemoveCommand((Object)errorFileName, null, this.keyPartitioner.getSegment((Object)errorFileName), flagsBitSet);
                    aggregateCompletionStage.dependsOn((CompletionStage)((AsyncInterceptorChain)this.invoker.running()).invokeAsync(ctx, (VisitableCommand)writeCommand));
                    continue;
                }
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append(fd.getName());
                PutKeyValueCommand put = this.commandsFactory.buildPutKeyValueCommand((Object)errorFileName, (Object)"One of the imported files is missing or has errors", this.keyPartitioner.getSegment((Object)errorFileName), DEFAULT_METADATA, flagsBitSet);
                put.setPutIfAbsent(true);
                aggregateCompletionStage.dependsOn((CompletionStage)((AsyncInterceptorChain)this.invoker.running()).invokeAsync(ctx, (VisitableCommand)put));
            }
            CompletionStage updatedStage = aggregateCompletionStage.freeze();
            return updatedStage.thenCompose(innerStringBuilder -> {
                Object writeCommand = innerStringBuilder.length() > 0 ? this.commandsFactory.buildPutKeyValueCommand((Object)".errors", (Object)innerStringBuilder.toString(), this.keyPartitioner.getSegment((Object)".errors"), DEFAULT_METADATA, flagsBitSet) : this.commandsFactory.buildRemoveCommand((Object)".errors", null, this.keyPartitioner.getSegment((Object)".errors"), flagsBitSet);
                return ((AsyncInterceptorChain)this.invoker.running()).invokeAsync(ctx, (VisitableCommand)writeCommand);
            });
        });
        return this.asyncInvokeNext(ctx, (VisitableCommand)command, stage);
    }

    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) {
        Object key = command.getKey();
        Object value = command.getNewValue();
        if (!ctx.isOriginLocal()) {
            return this.invokeNext(ctx, (VisitableCommand)command);
        }
        if (!(key instanceof String)) {
            throw log.keyMustBeString(key.getClass());
        }
        if (!(value instanceof String)) {
            throw log.valueMustBeString(value.getClass());
        }
        if (!this.shouldIntercept(key)) {
            return this.invokeNext(ctx, (VisitableCommand)command);
        }
        if (!((String)key).endsWith(".proto")) {
            throw log.keyMustBeStringEndingWithProto(key);
        }
        LockControlCommand cmd = this.commandsFactory.buildLockControlCommand((Object)".errors", command.getFlagsBitSet(), null);
        CompletableFuture stage = ((AsyncInterceptorChain)this.invoker.running()).invokeAsync(ctx, (VisitableCommand)cmd);
        return ProtobufMetadataManagerInterceptor.makeStage((Object)this.asyncInvokeNext(ctx, (VisitableCommand)command, stage)).thenApply(ctx, (VisitableCommand)command, (rCtx, rCommand, rv) -> {
            if (rCommand.isSuccessful()) {
                long flagsBitSet = this.copyFlags((FlagAffectedCommand)rCommand);
                if (rCtx.isOriginLocal()) {
                    ProgressCallback progressCallback = new ProgressCallback(rCtx, flagsBitSet);
                    this.registerProtoFile((String)key, (String)value, progressCallback);
                    CompletionStage<Void> schemaUpdate = this.updateSchemaErrors(rCtx, progressCallback);
                    CompletionStage<Object> errorUpdate = this.updateGlobalErrors(rCtx, progressCallback.getErrorFiles().keySet(), flagsBitSet);
                    return ProtobufMetadataManagerInterceptor.asyncValue((CompletionStage)CompletionStages.allOf((CompletionStage[])new CompletionStage[]{schemaUpdate, errorUpdate}));
                }
                this.registerProtoFile((String)key, (String)value);
            }
            return InvocationStage.completedNullStage();
        });
    }

    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) {
        for (String fileName : this.serializationContext.getFileDescriptors().keySet()) {
            this.serializationContext.unregisterProtoFile(fileName);
        }
        return this.invokeNext(ctx, (VisitableCommand)command);
    }

    private boolean shouldIntercept(Object key) {
        return !((String)key).endsWith(".errors");
    }

    private CompletionStage<Object> updateGlobalErrors(InvocationContext ctx, Set<String> errorFiles, long flagsBitSet) {
        RemoveCommand cmd;
        if (errorFiles.isEmpty()) {
            cmd = this.commandsFactory.buildRemoveCommand((Object)".errors", null, this.keyPartitioner.getSegment((Object)".errors"), flagsBitSet);
        } else {
            StringBuilder sb = new StringBuilder();
            for (String fileName : errorFiles) {
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append(fileName);
            }
            cmd = this.commandsFactory.buildPutKeyValueCommand((Object)".errors", (Object)sb.toString(), this.keyPartitioner.getSegment((Object)".errors"), DEFAULT_METADATA, flagsBitSet);
        }
        return ((AsyncInterceptorChain)this.invoker.running()).invokeAsync(ctx, (VisitableCommand)cmd);
    }

    public Object visitComputeCommand(InvocationContext ctx, ComputeCommand command) {
        return this.handleUnsupportedCommand((ReplicableCommand)command);
    }

    public Object visitComputeIfAbsentCommand(InvocationContext ctx, ComputeIfAbsentCommand command) {
        return this.handleUnsupportedCommand((ReplicableCommand)command);
    }

    public Object visitWriteOnlyKeyCommand(InvocationContext ctx, WriteOnlyKeyCommand command) {
        return this.handleUnsupportedCommand((ReplicableCommand)command);
    }

    public Object visitWriteOnlyKeyValueCommand(InvocationContext ctx, WriteOnlyKeyValueCommand command) {
        return this.handleUnsupportedCommand((ReplicableCommand)command);
    }

    public Object visitWriteOnlyManyCommand(InvocationContext ctx, WriteOnlyManyCommand command) {
        return this.handleUnsupportedCommand((ReplicableCommand)command);
    }

    public Object visitWriteOnlyManyEntriesCommand(InvocationContext ctx, WriteOnlyManyEntriesCommand command) {
        return this.handleUnsupportedCommand((ReplicableCommand)command);
    }

    public Object visitReadWriteKeyCommand(InvocationContext ctx, ReadWriteKeyCommand command) {
        return this.handleUnsupportedCommand((ReplicableCommand)command);
    }

    public Object visitReadWriteKeyValueCommand(InvocationContext ctx, ReadWriteKeyValueCommand command) {
        return this.handleUnsupportedCommand((ReplicableCommand)command);
    }

    public Object visitReadWriteManyCommand(InvocationContext ctx, ReadWriteManyCommand command) {
        return this.handleUnsupportedCommand((ReplicableCommand)command);
    }

    public Object visitReadWriteManyEntriesCommand(InvocationContext ctx, ReadWriteManyEntriesCommand command) {
        return this.handleUnsupportedCommand((ReplicableCommand)command);
    }

    private Object handleUnsupportedCommand(ReplicableCommand command) {
        throw log.cacheDoesNotSupportCommand("___protobuf_metadata", command.getClass().getName());
    }

    private final class ProgressCallback
    implements FileDescriptorSource.ProgressCallback {
        private final InvocationContext ctx;
        private final long flagsBitSet;
        private final Map<String, DescriptorParserException> errorFiles = new TreeMap<String, DescriptorParserException>();
        private final Set<String> successFiles = new TreeSet<String>();

        private ProgressCallback(InvocationContext ctx, long flagsBitSet) {
            this.ctx = ctx;
            this.flagsBitSet = flagsBitSet;
        }

        Map<String, DescriptorParserException> getErrorFiles() {
            return this.errorFiles;
        }

        public Set<String> getSuccessFiles() {
            return this.successFiles;
        }

        public void handleError(String fileName, DescriptorParserException exception) {
            this.errorFiles.putIfAbsent(fileName, exception);
        }

        public void handleSuccess(String fileName) {
            this.successFiles.add(fileName);
        }
    }
}

