/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.aggregation.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.Facets;
import org.apache.lucene.facet.FacetsCollector;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.FacetsCollectorFactory;
import org.hibernate.search.backend.lucene.lowlevel.join.impl.NestedDocsProvider;
import org.hibernate.search.backend.lucene.search.aggregation.impl.AggregationExtractContext;
import org.hibernate.search.backend.lucene.search.aggregation.impl.AggregationRequestContext;
import org.hibernate.search.backend.lucene.search.impl.AbstractLuceneCodecAwareSearchValueFieldQueryElementFactory;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchValueFieldContext;
import org.hibernate.search.backend.lucene.types.aggregation.impl.AbstractLuceneBucketAggregation;
import org.hibernate.search.backend.lucene.types.codec.impl.AbstractLuceneNumericFieldCodec;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.LuceneNumericDomain;
import org.hibernate.search.engine.backend.types.converter.spi.DslConverter;
import org.hibernate.search.engine.search.aggregation.spi.RangeAggregationBuilder;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.util.common.data.Range;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class LuceneNumericRangeAggregation<F, E extends Number, K>
extends AbstractLuceneBucketAggregation<Range<K>, Long> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final AbstractLuceneNumericFieldCodec<F, E> codec;
    private final List<Range<K>> rangesInOrder;
    private final List<Range<E>> encodedRangesInOrder;

    private LuceneNumericRangeAggregation(Builder<F, E, K> builder) {
        super(builder);
        this.codec = ((Builder)builder).codec;
        this.rangesInOrder = ((Builder)builder).rangesInOrder;
        this.encodedRangesInOrder = ((Builder)builder).encodedRangesInOrder;
    }

    @Override
    public void request(AggregationRequestContext context) {
        context.requireCollector(FacetsCollectorFactory.INSTANCE);
    }

    @Override
    public Map<Range<K>, Long> extract(AggregationExtractContext context) throws IOException {
        LuceneNumericDomain<E> numericDomain = this.codec.getDomain();
        FacetsCollector facetsCollector = context.getCollector(FacetsCollectorFactory.KEY);
        NestedDocsProvider nestedDocsProvider = this.createNestedDocsProvider(context);
        Facets facetsCount = numericDomain.createRangeFacetCounts(this.absoluteFieldPath, facetsCollector, this.encodedRangesInOrder, nestedDocsProvider);
        FacetResult facetResult = facetsCount.getTopChildren(this.rangesInOrder.size(), this.absoluteFieldPath, new String[0]);
        LinkedHashMap<Range<Range<K>>, Long> result = new LinkedHashMap<Range<Range<K>>, Long>();
        for (int i = 0; i < this.rangesInOrder.size(); ++i) {
            result.put(this.rangesInOrder.get(i), (long)((Integer)facetResult.labelValues[i].value));
        }
        return result;
    }

    public static class Builder<F, E extends Number, K>
    extends AbstractLuceneBucketAggregation.AbstractBuilder<Range<K>, Long>
    implements RangeAggregationBuilder<K> {
        private final DslConverter<? super K, F> toFieldValueConverter;
        private final AbstractLuceneNumericFieldCodec<F, E> codec;
        private final List<Range<K>> rangesInOrder = new ArrayList<Range<K>>();
        private final List<Range<E>> encodedRangesInOrder = new ArrayList<Range<E>>();

        public Builder(AbstractLuceneNumericFieldCodec<F, E> codec, LuceneSearchContext searchContext, LuceneSearchValueFieldContext<?> field, DslConverter<? super K, F> toFieldValueConverter) {
            super(searchContext, field);
            this.codec = codec;
            this.toFieldValueConverter = toFieldValueConverter;
        }

        public void range(Range<? extends K> range) {
            this.rangesInOrder.add(range.map(Function.identity()));
            this.encodedRangesInOrder.add(range.map(this::convertAndEncode));
        }

        @Override
        public LuceneNumericRangeAggregation<F, E, K> build() {
            return new LuceneNumericRangeAggregation(this);
        }

        private E convertAndEncode(K value) {
            try {
                Object converted = this.toFieldValueConverter.convert(value, this.searchContext.toDocumentFieldValueConvertContext());
                return (E)((Number)this.codec.encode(converted));
            }
            catch (RuntimeException e) {
                throw log.cannotConvertDslParameter(e.getMessage(), e, this.field.eventContext());
            }
        }
    }

    public static class TypeSelector<F> {
        private final AbstractLuceneNumericFieldCodec<F, ?> codec;
        private final LuceneSearchContext searchContext;
        private final LuceneSearchValueFieldContext<F> field;

        private TypeSelector(AbstractLuceneNumericFieldCodec<F, ?> codec, LuceneSearchContext searchContext, LuceneSearchValueFieldContext<F> field) {
            this.codec = codec;
            this.searchContext = searchContext;
            this.field = field;
        }

        public <K> Builder<F, ?, K> type(Class<K> expectedType, ValueConvert convert) {
            return new Builder(this.codec, this.searchContext, this.field, this.field.type().dslConverter(convert).withInputType(expectedType, this.field));
        }
    }

    public static class Factory<F>
    extends AbstractLuceneCodecAwareSearchValueFieldQueryElementFactory<TypeSelector<?>, F, AbstractLuceneNumericFieldCodec<F, ?>> {
        public Factory(AbstractLuceneNumericFieldCodec<F, ?> codec) {
            super(codec);
        }

        @Override
        public TypeSelector<?> create(LuceneSearchContext searchContext, LuceneSearchValueFieldContext<F> field) {
            return new TypeSelector((AbstractLuceneNumericFieldCodec)this.codec, searchContext, field);
        }
    }
}

