/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.transaction;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.EntityTransaction;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.Session;
import org.hibernate.SessionBuilder;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.dialect.AbstractHANADialect;
import org.hibernate.dialect.CockroachDialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DialectDelegateWrapper;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.dialect.SybaseASEDialect;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.testing.util.ServiceRegistryUtil;
import org.jboss.logging.Logger;
import org.junit.Assert;

public class TransactionUtil {
    private static final Logger log = Logger.getLogger(TransactionUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doInHibernate(Supplier<SessionFactory> factorySupplier, Consumer<Session> function) {
        SessionFactory sessionFactory = factorySupplier.get();
        Assert.assertNotNull((String)"SessionFactory is null in test!", (Object)sessionFactory);
        try (Session session = sessionFactory.openSession();){
            Transaction txn = session.getTransaction();
            txn.begin();
            try {
                function.accept(session);
            }
            catch (Throwable e) {
                try {
                    txn.rollback();
                }
                finally {
                    throw e;
                }
            }
            txn.commit();
        }
    }

    public static <T> T doInJPA(Supplier<EntityManagerFactory> factorySupplier, JPATransactionFunction<T> function, Map properties) {
        T result = null;
        EntityManager entityManager = null;
        EntityTransaction txn = null;
        try {
            entityManager = properties == null ? factorySupplier.get().createEntityManager() : factorySupplier.get().createEntityManager(properties);
            function.beforeTransactionCompletion();
            txn = entityManager.getTransaction();
            txn.begin();
            result = (T)function.apply(entityManager);
            txn.commit();
        }
        catch (Throwable e) {
            if (txn != null && txn.isActive()) {
                txn.rollback();
            }
            throw e;
        }
        finally {
            function.afterTransactionCompletion();
            if (entityManager != null) {
                entityManager.close();
            }
        }
        return result;
    }

    public static <T> T doInJPA(Supplier<EntityManagerFactory> factorySupplier, JPATransactionFunction<T> function) {
        return TransactionUtil.doInJPA(factorySupplier, function, null);
    }

    public static void doInJPA(Supplier<EntityManagerFactory> factorySupplier, JPATransactionVoidFunction function, Map properties) {
        EntityManager entityManager = null;
        EntityTransaction txn = null;
        try {
            entityManager = properties == null ? factorySupplier.get().createEntityManager() : factorySupplier.get().createEntityManager(properties);
            function.beforeTransactionCompletion();
            txn = entityManager.getTransaction();
            txn.begin();
            function.accept(entityManager);
            if (!txn.getRollbackOnly()) {
                txn.commit();
            } else {
                try {
                    txn.rollback();
                }
                catch (Exception e) {
                    log.error((Object)"Rollback failure", (Throwable)e);
                }
            }
        }
        catch (Throwable t) {
            if (txn != null && txn.isActive()) {
                try {
                    txn.rollback();
                }
                catch (Exception e) {
                    log.error((Object)"Rollback failure", (Throwable)e);
                }
            }
            throw t;
        }
        finally {
            function.afterTransactionCompletion();
            if (entityManager != null) {
                entityManager.close();
            }
        }
    }

    public static void doInJPA(Supplier<EntityManagerFactory> factorySupplier, JPATransactionVoidFunction function) {
        TransactionUtil.doInJPA(factorySupplier, function, null);
    }

    public static <T> T doInHibernate(Supplier<SessionFactory> factorySupplier, HibernateTransactionFunction<T> function) {
        T result = null;
        Session session = null;
        Transaction txn = null;
        try {
            session = factorySupplier.get().openSession();
            function.beforeTransactionCompletion();
            txn = session.beginTransaction();
            result = (T)function.apply(session);
            if (!txn.getRollbackOnly()) {
                txn.commit();
            } else {
                try {
                    txn.rollback();
                }
                catch (Exception e) {
                    log.error((Object)"Rollback failure", (Throwable)e);
                }
            }
        }
        catch (Throwable t) {
            if (txn != null && txn.isActive()) {
                try {
                    txn.rollback();
                }
                catch (Exception e) {
                    log.error((Object)"Rollback failure", (Throwable)e);
                }
            }
            throw t;
        }
        finally {
            function.afterTransactionCompletion();
            if (session != null) {
                session.close();
            }
        }
        return result;
    }

    public static void doInHibernate(Supplier<SessionFactory> factorySupplier, HibernateTransactionConsumer function) {
        Session session = null;
        Transaction txn = null;
        try {
            session = factorySupplier.get().openSession();
            function.beforeTransactionCompletion();
            txn = session.beginTransaction();
            function.accept(session);
            if (!txn.getRollbackOnly()) {
                txn.commit();
            } else {
                try {
                    txn.rollback();
                }
                catch (Exception e) {
                    log.error((Object)"Rollback failure", (Throwable)e);
                }
            }
        }
        catch (Throwable t) {
            if (txn != null && txn.isActive()) {
                try {
                    txn.rollback();
                }
                catch (Exception e) {
                    log.error((Object)"Rollback failure", (Throwable)e);
                }
            }
            throw t;
        }
        finally {
            function.afterTransactionCompletion();
            if (session != null) {
                session.close();
            }
        }
    }

    public static void doInHibernate(Supplier<SessionFactory> factorySupplier, String tenant, Consumer<Session> function) {
        Transaction txn = null;
        try (Session session = null;){
            session = factorySupplier.get().withOptions().tenantIdentifier(tenant).openSession();
            txn = session.getTransaction();
            txn.begin();
            function.accept(session);
            txn.commit();
        }
    }

    public static <R> R doInHibernate(Supplier<SessionFactory> factorySupplier, String tenant, Function<Session, R> function) {
        Transaction txn = null;
        try (Session session = null;){
            session = factorySupplier.get().withOptions().tenantIdentifier(tenant).openSession();
            txn = session.getTransaction();
            txn.begin();
            R returnValue = function.apply(session);
            txn.commit();
            R r = returnValue;
            return r;
        }
    }

    public static <T> T doInHibernateSessionBuilder(Supplier<SessionBuilder> sessionBuilderSupplier, HibernateTransactionFunction<T> function) {
        T result = null;
        Session session = null;
        Transaction txn = null;
        try {
            session = sessionBuilderSupplier.get().openSession();
            function.beforeTransactionCompletion();
            txn = session.beginTransaction();
            result = (T)function.apply(session);
            if (!txn.getRollbackOnly()) {
                txn.commit();
            } else {
                try {
                    txn.rollback();
                }
                catch (Exception e) {
                    log.error((Object)"Rollback failure", (Throwable)e);
                }
            }
        }
        catch (Throwable t) {
            if (txn != null && txn.isActive()) {
                try {
                    txn.rollback();
                }
                catch (Exception e) {
                    log.error((Object)"Rollback failure", (Throwable)e);
                }
            }
            throw t;
        }
        finally {
            function.afterTransactionCompletion();
            if (session != null) {
                session.close();
            }
        }
        return result;
    }

    public static void doInHibernateSessionBuilder(Supplier<SessionBuilder> sessionBuilderSupplier, HibernateTransactionConsumer function) {
        Session session = null;
        Transaction txn = null;
        try {
            session = sessionBuilderSupplier.get().openSession();
            function.beforeTransactionCompletion();
            txn = session.beginTransaction();
            function.accept(session);
            if (!txn.getRollbackOnly()) {
                txn.commit();
            } else {
                try {
                    txn.rollback();
                }
                catch (Exception e) {
                    log.error((Object)"Rollback failure", (Throwable)e);
                }
            }
        }
        catch (Throwable t) {
            if (txn != null && txn.isActive()) {
                try {
                    txn.rollback();
                }
                catch (Exception e) {
                    log.error((Object)"Rollback failure", (Throwable)e);
                }
            }
            throw t;
        }
        finally {
            function.afterTransactionCompletion();
            if (session != null) {
                session.close();
            }
        }
    }

    @Deprecated
    public static void setJdbcTimeout(Session session) {
        TransactionUtil.setJdbcTimeout(session, TimeUnit.SECONDS.toMillis(1L));
    }

    @Deprecated
    public static void setJdbcTimeout(Session session, long millis) {
        Dialect dialect = ((SessionFactoryImplementor)session.getSessionFactory().unwrap(SessionFactoryImplementor.class)).getJdbcServices().getDialect();
        session.doWork(connection -> TransactionUtil.setJdbcTimeout(dialect, connection, millis));
    }

    private static void setJdbcTimeout(Dialect dialect, Connection connection, long millis) throws SQLException {
        block49: {
            Dialect extractedDialect = DialectDelegateWrapper.extractRealDialect((Dialect)dialect);
            if (extractedDialect instanceof PostgreSQLDialect || extractedDialect instanceof CockroachDialect) {
                try (Statement st = connection.createStatement();){
                    st.execute(String.format("SET statement_timeout TO %d", millis));
                    break block49;
                }
                catch (SQLException ex) {
                    if (millis != 0L) {
                        throw ex;
                    }
                    break block49;
                }
            }
            if (extractedDialect instanceof MySQLDialect) {
                try (PreparedStatement st = connection.prepareStatement("SET SESSION innodb_lock_wait_timeout = ?");){
                    st.setLong(1, millis == 0L ? 50L : (long)Math.max(1, Math.round((float)millis / 1000.0f)));
                    st.execute();
                }
            }
            if (extractedDialect instanceof H2Dialect) {
                try (PreparedStatement st = connection.prepareStatement("SET LOCK_TIMEOUT ?");){
                    st.setLong(1, millis == 0L ? 10000L : millis);
                    st.execute();
                }
            }
            if (extractedDialect instanceof SQLServerDialect) {
                try (Statement st = connection.createStatement();){
                    st.execute(String.format("SET LOCK_TIMEOUT %d", millis == 0L ? -1L : millis));
                }
            }
            if (extractedDialect instanceof AbstractHANADialect) {
                try (Statement st = connection.createStatement();){
                    st.execute(String.format("SET TRANSACTION LOCK WAIT TIMEOUT %d", millis));
                }
            }
            if (extractedDialect instanceof SybaseASEDialect) {
                try (Statement st = connection.createStatement();){
                    if (millis == 0L) {
                        st.execute("SET LOCK WAIT");
                    }
                    st.execute(String.format("SET LOCK WAIT %d", Math.max(1, Math.round((float)millis / 1000.0f))));
                }
            } else {
                try {
                    connection.setNetworkTimeout(Executors.newSingleThreadExecutor(), (int)millis);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public static void withJdbcTimeout(Session session, Runnable r) {
        TransactionUtil.withJdbcTimeout(session, TimeUnit.SECONDS.toMillis(1L), r);
    }

    public static void withJdbcTimeout(Session session, long millis, Runnable r) {
        Dialect dialect = ((SessionFactoryImplementor)session.getSessionFactory().unwrap(SessionFactoryImplementor.class)).getJdbcServices().getDialect();
        session.doWork(connection -> {
            try {
                TransactionUtil.setJdbcTimeout(dialect, connection, millis);
                r.run();
            }
            finally {
                TransactionUtil.setJdbcTimeout(dialect, connection, 0L);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doInAutoCommit(Consumer<Statement> consumer, Map<String, Object> settings) {
        StandardServiceRegistryBuilder ssrb = ServiceRegistryUtil.serviceRegistryBuilder();
        if (settings != null) {
            ssrb.applySetting("hibernate.connection.provider_class", (Object)"");
            ssrb.applySettings(settings);
        }
        StandardServiceRegistry ssr = ssrb.build();
        try {
            Connection connection;
            JdbcConnectionAccess connectionAccess = ((JdbcServices)ssr.getService(JdbcServices.class)).getBootstrapJdbcConnectionAccess();
            try {
                connection = connectionAccess.obtainConnection();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            try (Statement statement = connection.createStatement();){
                connection.setAutoCommit(true);
                consumer.accept(statement);
            }
            catch (SQLException e) {
                log.debug((Object)e.getMessage());
            }
            finally {
                try {
                    connectionAccess.releaseConnection(connection);
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            StandardServiceRegistryBuilder.destroy((ServiceRegistry)ssr);
        }
    }

    public static void doInAutoCommit(Consumer<Statement> consumer) {
        TransactionUtil.doInAutoCommit(consumer, null);
    }

    public static void doInAutoCommit(Map<String, Object> settings, String ... statements) {
        TransactionUtil.doInAutoCommit((Statement s) -> {
            for (String statement : statements) {
                try {
                    s.executeUpdate(statement);
                }
                catch (SQLException e) {
                    log.debugf((Throwable)e, "Statement [%s] execution failed!", (Object)statement);
                }
            }
        }, settings);
    }

    public static void doInAutoCommit(String ... statements) {
        TransactionUtil.doInAutoCommit(null, statements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doWithJDBC(ServiceRegistry serviceRegistry, JDBCTransactionVoidFunction function) throws SQLException {
        Connection connection;
        JdbcConnectionAccess connectionAccess = ((JdbcServices)serviceRegistry.getService(JdbcServices.class)).getBootstrapJdbcConnectionAccess();
        try {
            connection = connectionAccess.obtainConnection();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        try {
            function.accept(connection);
        }
        finally {
            if (connection != null) {
                try {
                    connectionAccess.releaseConnection(connection);
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T doWithJDBC(ServiceRegistry serviceRegistry, JDBCTransactionFunction<T> function) throws SQLException {
        Connection connection;
        JdbcConnectionAccess connectionAccess = ((JdbcServices)serviceRegistry.getService(JdbcServices.class)).getBootstrapJdbcConnectionAccess();
        try {
            connection = connectionAccess.obtainConnection();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        T t = function.accept(connection);
        return t;
        finally {
            if (connection != null) {
                try {
                    connectionAccess.releaseConnection(connection);
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @FunctionalInterface
    public static interface JPATransactionFunction<T>
    extends Function<EntityManager, T> {
        default public void beforeTransactionCompletion() {
        }

        default public void afterTransactionCompletion() {
        }
    }

    @FunctionalInterface
    public static interface JPATransactionVoidFunction
    extends Consumer<EntityManager> {
        default public void beforeTransactionCompletion() {
        }

        default public void afterTransactionCompletion() {
        }
    }

    @FunctionalInterface
    public static interface HibernateTransactionFunction<T>
    extends Function<Session, T> {
        default public void beforeTransactionCompletion() {
        }

        default public void afterTransactionCompletion() {
        }
    }

    @FunctionalInterface
    public static interface HibernateTransactionConsumer
    extends Consumer<Session> {
        default public void beforeTransactionCompletion() {
        }

        default public void afterTransactionCompletion() {
        }
    }

    @FunctionalInterface
    public static interface JDBCTransactionVoidFunction {
        public void accept(Connection var1) throws SQLException;
    }

    @FunctionalInterface
    public static interface JDBCTransactionFunction<T> {
        public T accept(Connection var1) throws SQLException;
    }
}

