/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.junit;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;

public class TestingUtil {
    private TestingUtil() {
    }

    public static <A extends Annotation> Optional<A> findEffectiveAnnotation(ExtensionContext context, Class<A> annotationType) {
        if (!context.getElement().isPresent()) {
            return Optional.empty();
        }
        AnnotatedElement annotatedElement = (AnnotatedElement)context.getElement().get();
        Optional direct = AnnotationSupport.findAnnotation((AnnotatedElement)annotatedElement, annotationType);
        if (direct.isPresent()) {
            return direct;
        }
        if (context.getTestInstance().isPresent()) {
            return AnnotationSupport.findAnnotation(context.getRequiredTestInstance().getClass(), annotationType);
        }
        return Optional.empty();
    }

    public static <A extends Annotation> Collection<A> collectAnnotations(ExtensionContext context, Class<A> annotationType, Class<? extends Annotation> groupAnnotationType) {
        return TestingUtil.collectAnnotations(context, annotationType, groupAnnotationType, (methodAnnotation, methodAnnotations, classAnnotation, classAnnotations) -> {
            ArrayList<Annotation> list = new ArrayList<Annotation>();
            if (methodAnnotation != null) {
                list.add((Annotation)methodAnnotation);
            } else if (classAnnotation != null) {
                list.add((Annotation)classAnnotation);
            }
            if (methodAnnotations != null) {
                list.addAll(Arrays.asList(methodAnnotations));
            } else if (classAnnotations != null) {
                list.addAll(Arrays.asList(classAnnotations));
            }
            return list;
        });
    }

    public static <A extends Annotation> Collection<A> collectAnnotations(ExtensionContext context, Class<A> annotationType, Class<? extends Annotation> groupAnnotationType, TestAnnotationCollector<A> collector) {
        Annotation[] classAnnotations;
        Annotation[] methodAnnotations;
        if (!context.getElement().isPresent()) {
            return Collections.emptyList();
        }
        AnnotatedElement annotatedElement = (AnnotatedElement)context.getElement().get();
        A methodAnnotation = annotatedElement.getAnnotation(annotationType);
        Annotation classAnnotation = context.getTestInstance().map(i -> i.getClass().getAnnotation(annotationType)).orElse(null);
        Annotation methodPluralAnn = annotatedElement.getAnnotation(groupAnnotationType);
        Annotation classPluralAnn = context.getTestInstance().map(i -> i.getClass().getAnnotation(groupAnnotationType)).orElse(null);
        if (methodPluralAnn != null) {
            try {
                methodAnnotations = (Annotation[])groupAnnotationType.getDeclaredMethod("value", null).invoke((Object)methodPluralAnn, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            methodAnnotations = null;
        }
        if (classPluralAnn != null) {
            try {
                classAnnotations = (Annotation[])groupAnnotationType.getDeclaredMethod("value", null).invoke((Object)classPluralAnn, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            classAnnotations = null;
        }
        return collector.collect(methodAnnotation, methodAnnotations, classAnnotation, classAnnotations);
    }

    public static <A extends Annotation> boolean hasEffectiveAnnotation(ExtensionContext context, Class<A> annotationType) {
        return TestingUtil.findEffectiveAnnotation(context, annotationType).isPresent();
    }

    public static <T> T cast(Object thing, Class<T> type) {
        MatcherAssert.assertThat((Object)thing, (Matcher)CoreMatchers.instanceOf(type));
        return type.cast(thing);
    }

    public static interface TestAnnotationCollector<S> {
        public Collection<S> collect(S var1, S[] var2, S var3, S[] var4);
    }
}

