/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.call;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.function.PFunction;
import com.oracle.graal.python.nodes.call.GenericInvokeNodeGen;
import com.oracle.graal.python.nodes.call.InvokeNode;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;

@GenerateUncached
public abstract class GenericInvokeNode
extends InvokeNode {
    @NeverDefault
    public static GenericInvokeNode create() {
        return GenericInvokeNodeGen.create();
    }

    public static GenericInvokeNode getUncached() {
        return GenericInvokeNodeGen.getUncached();
    }

    protected GenericInvokeNode() {
    }

    public final Object execute(VirtualFrame frame, Object callee, Object[] arguments) {
        return this.executeInternal((Frame)frame, callee, arguments);
    }

    protected abstract Object executeInternal(Frame var1, Object var2, Object[] var3);

    public final Object execute(Object callee, Object[] arguments) {
        return this.executeInternal(null, callee, arguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object doCall(Frame frame, Node inliningTarget, PFunction callee, RootCallTarget callTarget, Object[] arguments, PythonLanguage language, PythonContext context, IndirectCallNode callNode, ExecutionContext.CallContext callContext, InlinedConditionProfile isNullFrameProfile, InlinedConditionProfile isGeneratorFunctionProfile) {
        GenericInvokeNode.optionallySetGeneratorFunction(inliningTarget, arguments, (CallTarget)callTarget, isGeneratorFunctionProfile, callee);
        if (isNullFrameProfile.profile(inliningTarget, frame == null)) {
            PythonContext.PythonThreadState threadState = context.getThreadState(language);
            Object state = ExecutionContext.IndirectCalleeContext.enterIndirect(threadState, arguments);
            try {
                Object object = callNode.call((CallTarget)callTarget, arguments);
                return object;
            }
            finally {
                ExecutionContext.IndirectCalleeContext.exit(threadState, state);
            }
        }
        assert (frame instanceof VirtualFrame) : "GenericInvokeNode should not be executed with non-virtual frames";
        callContext.prepareIndirectCall((VirtualFrame)frame, arguments, this);
        return callNode.call((CallTarget)callTarget, arguments);
    }

    private Object doCallWithFrame(Frame frame, Node inlinlingTarget, PFunction callee, RootCallTarget callTarget, Object[] arguments, IndirectCallNode callNode, ExecutionContext.CallContext callContext, InlinedConditionProfile isGeneratorFunctionProfile) {
        GenericInvokeNode.optionallySetGeneratorFunction(inlinlingTarget, arguments, (CallTarget)callTarget, isGeneratorFunctionProfile, callee);
        assert (frame instanceof VirtualFrame) : "GenericInvokeNode should not be executed with non-virtual frames";
        callContext.prepareIndirectCall((VirtualFrame)frame, arguments, this);
        return callNode.call((CallTarget)callTarget, arguments);
    }

    @Specialization(guards={"frame != null"})
    Object invokeFunctionWithFrame(Frame frame, PFunction callee, Object[] arguments, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="callNode") @Cached IndirectCallNode callNode, @Cached.Shared(value="callContext") @Cached ExecutionContext.CallContext callContext, @Cached.Shared(value="isGeneratorFunctionProfile") @Cached InlinedConditionProfile isGeneratorFunctionProfile) {
        PArguments.setGlobals(arguments, callee.getGlobals());
        PArguments.setClosure(arguments, callee.getClosure());
        RootCallTarget callTarget = GenericInvokeNode.getCallTarget(callee);
        return this.doCallWithFrame(frame, inliningTarget, callee, callTarget, arguments, callNode, callContext, isGeneratorFunctionProfile);
    }

    @Specialization(guards={"frame != null"})
    Object invokeBuiltinWithFrame(Frame frame, PBuiltinFunction callee, Object[] arguments, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="callNode") @Cached IndirectCallNode callNode, @Cached.Shared(value="callContext") @Cached ExecutionContext.CallContext callContext, @Cached.Shared(value="isGeneratorFunctionProfile") @Cached InlinedConditionProfile isGeneratorFunctionProfile) {
        RootCallTarget callTarget = GenericInvokeNode.getCallTarget(callee);
        return this.doCallWithFrame(frame, inliningTarget, null, callTarget, arguments, callNode, callContext, isGeneratorFunctionProfile);
    }

    @Specialization(guards={"frame != null"})
    Object invokeCallTargetWithFrame(Frame frame, RootCallTarget callTarget, Object[] arguments, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="callNode") @Cached IndirectCallNode callNode, @Cached.Shared(value="callContext") @Cached ExecutionContext.CallContext callContext, @Cached.Shared(value="isGeneratorFunctionProfile") @Cached InlinedConditionProfile isGeneratorFunctionProfile) {
        return this.doCallWithFrame(frame, inliningTarget, null, callTarget, arguments, callNode, callContext, isGeneratorFunctionProfile);
    }

    @Specialization(replaces={"invokeFunctionWithFrame"})
    Object invokeFunction(Frame frame, PFunction callee, Object[] arguments, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="callNode") @Cached IndirectCallNode callNode, @Cached.Shared(value="callContext") @Cached ExecutionContext.CallContext callContext, @Cached.Shared(value="isNullFrameProfile") @Cached InlinedConditionProfile isNullFrameProfile, @Cached.Shared(value="isGeneratorFunctionProfile") @Cached InlinedConditionProfile isGeneratorFunctionProfile) {
        PArguments.setGlobals(arguments, callee.getGlobals());
        PArguments.setClosure(arguments, callee.getClosure());
        RootCallTarget callTarget = GenericInvokeNode.getCallTarget(callee);
        return this.doCall(frame, inliningTarget, callee, callTarget, arguments, PythonLanguage.get(this), PythonContext.get(this), callNode, callContext, isNullFrameProfile, isGeneratorFunctionProfile);
    }

    @Specialization(replaces={"invokeBuiltinWithFrame"})
    Object invokeBuiltin(Frame frame, PBuiltinFunction callee, Object[] arguments, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="callNode") @Cached IndirectCallNode callNode, @Cached.Shared(value="callContext") @Cached ExecutionContext.CallContext callContext, @Cached.Shared(value="isNullFrameProfile") @Cached InlinedConditionProfile isNullFrameProfile, @Cached.Shared(value="isGeneratorFunctionProfile") @Cached InlinedConditionProfile isGeneratorFunctionProfile) {
        RootCallTarget callTarget = GenericInvokeNode.getCallTarget(callee);
        return this.doCall(frame, inliningTarget, null, callTarget, arguments, PythonLanguage.get(this), PythonContext.get(this), callNode, callContext, isNullFrameProfile, isGeneratorFunctionProfile);
    }

    @Specialization(replaces={"invokeCallTargetWithFrame"})
    Object invokeCallTarget(Frame frame, RootCallTarget callTarget, Object[] arguments, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="callNode") @Cached IndirectCallNode callNode, @Cached.Shared(value="callContext") @Cached ExecutionContext.CallContext callContext, @Cached.Shared(value="isNullFrameProfile") @Cached InlinedConditionProfile isNullFrameProfile, @Cached.Shared(value="isGeneratorFunctionProfile") @Cached InlinedConditionProfile isGeneratorFunctionProfile) {
        return this.doCall(frame, inliningTarget, null, callTarget, arguments, PythonLanguage.get(this), PythonContext.get(this), callNode, callContext, isNullFrameProfile, isGeneratorFunctionProfile);
    }
}

