/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlot;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryFunc;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryOp;
import com.oracle.graal.python.lib.CallBinaryOp1Node;
import com.oracle.graal.python.lib.PyNumberAddNodeGen;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.expression.BinaryOpNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateInline(inlineByDefault=true)
public abstract class PyNumberAddNode
extends BinaryOpNode {
    public abstract Object execute(VirtualFrame var1, Node var2, Object var3, Object var4);

    @Override
    public final Object executeObject(VirtualFrame frame, Object left, Object right) {
        return this.executeCached(frame, left, right);
    }

    public final Object executeCached(VirtualFrame frame, Object v, Object w) {
        return this.execute(frame, this, v, w);
    }

    public abstract int executeInt(VirtualFrame var1, Node var2, int var3, int var4) throws UnexpectedResultException;

    public abstract double executeDouble(VirtualFrame var1, Node var2, double var3, double var5) throws UnexpectedResultException;

    @Specialization(rewriteOn={ArithmeticException.class})
    public static int add(int left, int right) {
        return Math.addExact(left, right);
    }

    @Specialization
    public static long doIIOvf(int x, int y) {
        return (long)x + (long)y;
    }

    @Specialization(rewriteOn={ArithmeticException.class})
    public static long addLong(long left, long right) {
        return Math.addExact(left, right);
    }

    @Specialization
    public static double doDD(double left, double right) {
        return left + right;
    }

    @Specialization
    public static double doDL(double left, long right) {
        return left + (double)right;
    }

    @Specialization
    public static double doLD(long left, double right) {
        return (double)left + right;
    }

    @Specialization
    public static double doDI(double left, int right) {
        return left + (double)right;
    }

    @Specialization
    public static double doID(int left, double right) {
        return (double)left + right;
    }

    @NeverDefault
    protected static SequenceStorageNodes.ConcatNode createConcat() {
        return SequenceStorageNodes.ConcatNode.create(SequenceStorageNodes.ListGeneralizationNode::create);
    }

    @Specialization
    static PList doPList(Node inliningTarget, PList left, PList right, @Cached.Exclusive @Cached GetClassNode getClassNode, @Cached.Shared @Cached(value="createConcat()", inline=false) SequenceStorageNodes.ConcatNode concatNode, @Cached.Shared @Cached(inline=false) PythonObjectFactory factory) {
        SequenceStorage newStore = concatNode.execute(left.getSequenceStorage(), right.getSequenceStorage());
        return factory.createList(getClassNode.execute(inliningTarget, left), newStore);
    }

    @Specialization(guards={"isBuiltinTuple(left)", "isBuiltinTuple(right)"})
    static PTuple doTuple(Node inliningTarget, PTuple left, PTuple right, @Cached.Shared @Cached(value="createConcat()", inline=false) SequenceStorageNodes.ConcatNode concatNode, @Cached.Shared @Cached(inline=false) PythonObjectFactory factory) {
        SequenceStorage concatenated = concatNode.execute(left.getSequenceStorage(), right.getSequenceStorage());
        return factory.createTuple(concatenated);
    }

    @Specialization
    static TruffleString doIt(TruffleString left, TruffleString right, @Cached(inline=false) TruffleString.ConcatNode concatNode) {
        return concatNode.execute((AbstractTruffleString)left, (AbstractTruffleString)right, PythonUtils.TS_ENCODING, false);
    }

    @Fallback
    static Object doIt(VirtualFrame frame, Node inliningTarget, Object v, Object w, @Cached.Exclusive @Cached GetClassNode getVClass, @Cached TpSlots.GetCachedTpSlotsNode getVSlots, @Cached TpSlots.GetCachedTpSlotsNode getWSlots, @Cached.Exclusive @Cached GetClassNode getWClass, @Cached CallBinaryOp1Node callBinaryOp1Node, @Cached InlinedBranchProfile hasNbAddResult, @Cached TpSlotBinaryFunc.CallSlotBinaryFuncNode callBinarySlotNode, @Cached PRaiseNode.Lazy raiseNode) {
        Object result;
        Object classV = getVClass.execute(inliningTarget, v);
        Object classW = getWClass.execute(inliningTarget, w);
        TpSlots slotsV = getVSlots.execute(inliningTarget, classV);
        TpSlots slotsW = getWSlots.execute(inliningTarget, classW);
        TpSlot slotV = slotsV.nb_add();
        TpSlot slotW = slotsW.nb_add();
        if ((slotV != null || slotW != null) && (result = callBinaryOp1Node.execute(frame, inliningTarget, v, classV, slotV, w, classW, slotW, TpSlotBinaryOp.BinaryOpSlot.NB_ADD)) != PNotImplemented.NOT_IMPLEMENTED) {
            hasNbAddResult.enter(inliningTarget);
            return result;
        }
        if (slotsV.sq_concat() != null) {
            return callBinarySlotNode.execute(frame, inliningTarget, slotsV.sq_concat(), v, w);
        }
        return PyNumberAddNode.raiseNotSupported(inliningTarget, v, w, raiseNode);
    }

    @HostCompilerDirectives.InliningCutoff
    private static PException raiseNotSupported(Node inliningTarget, Object v, Object w, PRaiseNode.Lazy raiseNode) {
        return raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.UNSUPPORTED_OPERAND_TYPES_FOR_S_P_AND_P, "+", v, w);
    }

    @NeverDefault
    public static PyNumberAddNode create() {
        return PyNumberAddNodeGen.create();
    }
}

