/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateInline
@GenerateCached(value=false)
public abstract class PyArgCheckPositionalNode
extends Node {
    public final boolean execute(Node inliningTarget, TruffleString name, Object[] args, int min, int max) {
        return this.execute(inliningTarget, name, args.length, min, max);
    }

    public abstract boolean execute(Node var1, TruffleString var2, int var3, int var4, int var5);

    @Specialization
    static boolean doGeneric(Node inliningTarget, TruffleString name, int nargs, int min, int max, @Cached PRaiseNode.Lazy raiseNode) {
        assert (min >= 0);
        assert (min <= max);
        if (nargs < min) {
            if (name != null) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.S_EXPECTED_SD_ARGS_GOT_D, name, min == max ? "" : "at least ", min, min == 1 ? "" : "s", nargs);
            }
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.UNPACKED_TUPLE_SHOULD_HAVE_D_ELEMS, min == max ? "" : "at least ", min, min == 1 ? "" : "s", nargs);
        }
        if (nargs == 0) {
            return true;
        }
        if (nargs > max) {
            if (name != null) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.S_EXPECTED_SD_ARGS_GOT_D, name, min == max ? "" : "at most ", max, max == 1 ? "" : "s", nargs);
            }
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.UNPACKED_TUPLE_SHOULD_HAVE_D_ELEMS, min == max ? "" : "at most ", max, max == 1 ? "" : "s", nargs);
        }
        return true;
    }
}

