/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.exception;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.exception.BaseExceptionBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.exception.ExceptionNodes;
import com.oracle.graal.python.builtins.objects.exception.PBaseException;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.traceback.PTraceback;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyExceptionInstanceCheckNode;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectReprAsTruffleStringNode;
import com.oracle.graal.python.lib.PyObjectSetAttr;
import com.oracle.graal.python.lib.PyObjectSetAttrO;
import com.oracle.graal.python.lib.PyObjectStrAsObjectNode;
import com.oracle.graal.python.lib.PyUnicodeCheckNode;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.builtins.ListNodes;
import com.oracle.graal.python.nodes.expression.CastToListExpressionNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.object.GetOrCreateDictNode;
import com.oracle.graal.python.nodes.object.SetDictNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaBooleanNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.nodes.util.SplitArgsNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PBaseException})
public final class BaseExceptionBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return BaseExceptionBuiltinsFactory.getFactories();
    }

    @Builtin(name="add_note", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class AddNoteNode
    extends PythonBinaryBuiltinNode {
        AddNoteNode() {
        }

        @Specialization
        Object addNote(VirtualFrame frame, Object self, Object note, @Bind(value="this") Node inliningTarget, @Cached PyUnicodeCheckNode unicodeCheckNode, @Cached PyObjectLookupAttr lookupAttr, @Cached PyObjectSetAttr setAttr, @Cached ListNodes.AppendNode appendNode, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            if (!unicodeCheckNode.execute(inliningTarget, note)) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.NOTE_MUST_BE_A_STR_NOT_P, note);
            }
            Object notes = lookupAttr.execute((Frame)frame, inliningTarget, self, BuiltinNames.T___NOTES__);
            if (notes == PNone.NO_VALUE) {
                notes = factory.createList();
                setAttr.execute((Frame)frame, inliningTarget, self, BuiltinNames.T___NOTES__, notes);
            }
            if (!(notes instanceof PList)) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.CANNOT_ADD_NOTE_NOTES_IS_NOT_A_LIST);
            }
            PList notesList = (PList)notes;
            appendNode.execute(notesList, note);
            return PNone.NONE;
        }
    }

    @Builtin(name="__setstate__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class BaseExceptionSetStateNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object setDict(VirtualFrame frame, Object self, PDict state, @Bind(value="this") Node inliningTarget, @Cached ForEachKW forEachKW, @Cached HashingStorageNodes.HashingStorageForEach forEachNode) {
            HashingStorage dictStorage = state.getDictStorage();
            forEachNode.execute((Frame)frame, inliningTarget, dictStorage, forEachKW, new ExcState(dictStorage, self));
            return PNone.NONE;
        }

        @Specialization(guards={"!isDict(state)"})
        static Object generic(Object self, Object state, @Bind(value="this") Node inliningTarget, @Cached PRaiseNode.Lazy raiseNode) {
            if (state != PNone.NONE) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.STATE_IS_NOT_A_DICT);
            }
            return PNone.NONE;
        }

        @CompilerDirectives.ValueType
        static final class ExcState {
            private final HashingStorage dictStorage;
            private final Object exception;

            ExcState(HashingStorage dictStorage, Object exception) {
                this.dictStorage = dictStorage;
                this.exception = exception;
            }
        }

        @ImportStatic(value={PGuards.class})
        @GenerateInline
        @GenerateCached(value=false)
        static abstract class ForEachKW
        extends HashingStorageNodes.HashingStorageForEachCallback<ExcState> {
            ForEachKW() {
            }

            @Override
            public abstract ExcState execute(Frame var1, Node var2, HashingStorage var3, HashingStorageNodes.HashingStorageIterator var4, ExcState var5);

            @Specialization
            public static ExcState doIt(Frame frame, Node node, HashingStorage storage, HashingStorageNodes.HashingStorageIterator it, ExcState state, @Bind(value="this") Node inliningTarget, @Cached PyObjectSetAttrO setAttr, @Cached HashingStorageNodes.HashingStorageIteratorKey itKey, @Cached HashingStorageNodes.HashingStorageIteratorKeyHash itKeyHash, @Cached HashingStorageNodes.HashingStorageGetItemWithHash getItem) {
                Object key = itKey.execute(inliningTarget, storage, it);
                Object value = getItem.execute(frame, inliningTarget, state.dictStorage, key, itKeyHash.execute(frame, inliningTarget, storage, it));
                setAttr.execute(frame, inliningTarget, state.exception, key, value);
                return state;
            }
        }
    }

    @Builtin(name="__str__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class StrNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object str(VirtualFrame frame, Object self, @Bind(value="this") Node inliningTarget, @Cached InlinedBranchProfile noArgsProfile, @Cached InlinedBranchProfile oneArgProfile, @Cached InlinedBranchProfile moreArgsProfile, @Cached ExceptionNodes.GetArgsNode getArgsNode, @Cached SequenceStorageNodes.GetItemScalarNode getItemScalarNode, @Cached PyObjectStrAsObjectNode strNode) {
            PTuple args = getArgsNode.execute(inliningTarget, self);
            SequenceStorage argsStorage = args.getSequenceStorage();
            if (argsStorage.length() == 1) {
                oneArgProfile.enter(inliningTarget);
                return strNode.execute((Frame)frame, inliningTarget, getItemScalarNode.execute(inliningTarget, argsStorage, 0));
            }
            if (argsStorage.length() > 1) {
                moreArgsProfile.enter(inliningTarget);
                return strNode.execute((Frame)frame, inliningTarget, args);
            }
            noArgsProfile.enter(inliningTarget);
            return StringLiterals.T_EMPTY_STRING;
        }
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object repr(VirtualFrame frame, Object self, @Bind(value="this") Node inliningTarget, @Cached InlinedBranchProfile noArgsProfile, @Cached InlinedBranchProfile oneArgProfile, @Cached InlinedBranchProfile moreArgsProfile, @Cached ExceptionNodes.GetArgsNode getArgsNode, @Cached GetClassNode getClassNode, @Cached PyObjectGetAttr getAttrNode, @Cached CastToTruffleStringNode castStringNode, @Cached PyObjectReprAsTruffleStringNode reprNode, @Cached SequenceStorageNodes.GetItemScalarNode getItemScalarNode, @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached TruffleStringBuilder.ToStringNode toStringNode) {
            Object type = getClassNode.execute(inliningTarget, self);
            TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
            appendStringNode.execute(sb, (AbstractTruffleString)castStringNode.execute(inliningTarget, getAttrNode.execute((Frame)frame, inliningTarget, type, SpecialAttributeNames.T___NAME__)));
            PTuple args = getArgsNode.execute(inliningTarget, self);
            SequenceStorage argsStorage = args.getSequenceStorage();
            if (argsStorage.length() == 1) {
                oneArgProfile.enter(inliningTarget);
                appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_LPAREN);
                appendStringNode.execute(sb, (AbstractTruffleString)reprNode.execute((Frame)frame, inliningTarget, getItemScalarNode.execute(inliningTarget, argsStorage, 0)));
                appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_RPAREN);
            } else if (argsStorage.length() > 1) {
                moreArgsProfile.enter(inliningTarget);
                appendStringNode.execute(sb, (AbstractTruffleString)reprNode.execute((Frame)frame, inliningTarget, args));
            } else {
                noArgsProfile.enter(inliningTarget);
                appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_EMPTY_PARENS);
            }
            return toStringNode.execute(sb);
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object reduce(VirtualFrame frame, Object self, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached ExceptionNodes.GetArgsNode argsNode, @Cached DictNode dictNode, @Cached PythonObjectFactory factory) {
            Object clazz = getClassNode.execute(inliningTarget, self);
            PTuple args = argsNode.execute(inliningTarget, self);
            Object dict = dictNode.execute(frame, self, PNone.NO_VALUE);
            return factory.createTuple(new Object[]{clazz, args, dict});
        }
    }

    @Builtin(name="__dict__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    static abstract class DictNode
    extends PythonBinaryBuiltinNode {
        DictNode() {
        }

        @Specialization
        static PNone dict(Object self, PDict mapping, @Bind(value="this") Node inliningTarget, @Cached SetDictNode setDict) {
            setDict.execute(inliningTarget, self, mapping);
            return PNone.NONE;
        }

        @Specialization(guards={"isNoValue(mapping)"})
        static Object dict(Object self, PNone mapping, @Bind(value="this") Node inliningTarget, @Cached GetOrCreateDictNode getDict) {
            return getDict.execute(inliningTarget, self);
        }

        @Specialization(guards={"!isNoValue(mapping)", "!isDict(mapping)"})
        static PNone dict(Object self, Object mapping, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.DICT_MUST_BE_SET_TO_DICT, mapping);
        }
    }

    @Builtin(name="with_traceback", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class WithTracebackNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object doClearTraceback(Object self, PNone tb, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached ExceptionNodes.SetTracebackNode setTracebackNode) {
            setTracebackNode.execute(inliningTarget, self, PNone.NONE);
            return self;
        }

        @Specialization
        static Object doSetTraceback(Object self, PTraceback tb, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached ExceptionNodes.SetTracebackNode setTracebackNode) {
            setTracebackNode.execute(inliningTarget, self, tb);
            return self;
        }
    }

    @Builtin(name="__traceback__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    public static abstract class TracebackNode
    extends PythonBuiltinNode {
        @Specialization(guards={"isNoValue(tb)"})
        static Object getTraceback(Object self, Object tb, @Bind(value="this") Node inliningTarget, @Cached ExceptionNodes.GetTracebackNode getTracebackNode) {
            return getTracebackNode.execute(inliningTarget, self);
        }

        @Specialization(guards={"!isNoValue(tb)"})
        static Object setTraceback(Object self, PNone tb, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached ExceptionNodes.SetTracebackNode setTracebackNode) {
            setTracebackNode.execute(inliningTarget, self, PNone.NONE);
            return PNone.NONE;
        }

        @Specialization
        static Object setTraceback(Object self, PTraceback tb, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached ExceptionNodes.SetTracebackNode setTracebackNode) {
            setTracebackNode.execute(inliningTarget, self, tb);
            return PNone.NONE;
        }

        @Fallback
        static Object setTraceback(Object self, Object tb, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.MUST_BE_S_OR_S, "__traceback__", "a traceback", "None");
        }
    }

    @Builtin(name="__suppress_context__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    public static abstract class SuppressContextNode
    extends PythonBuiltinNode {
        @Specialization(guards={"isNoValue(value)"})
        static Object getSuppressContext(Object self, PNone value, @Bind(value="this") Node inliningTarget, @Cached ExceptionNodes.GetSuppressContextNode getSuppressContextNode) {
            return getSuppressContextNode.execute(inliningTarget, self);
        }

        @Specialization(guards={"!isNoValue(valueObj)"})
        static Object setSuppressContext(Object self, Object valueObj, @Bind(value="this") Node inliningTarget, @Cached ExceptionNodes.SetSuppressContextNode setSuppressContextNode, @Cached CastToJavaBooleanNode castToJavaBooleanNode, @Cached PRaiseNode.Lazy raiseNode) {
            boolean value;
            try {
                value = castToJavaBooleanNode.execute(inliningTarget, valueObj);
            }
            catch (CannotCastException e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.ATTR_VALUE_MUST_BE_BOOL);
            }
            setSuppressContextNode.execute(inliningTarget, self, value);
            return PNone.NONE;
        }
    }

    @Builtin(name="__context__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    public static abstract class ContextNode
    extends PythonBuiltinNode {
        @Specialization(guards={"isNoValue(value)"})
        public static Object getContext(Object self, PNone value, @Bind(value="this") Node inliningTarget, @Cached ExceptionNodes.GetContextNode getContextNode) {
            return getContextNode.execute(inliningTarget, self);
        }

        @Specialization(guards={"!isNoValue(value)", "check.execute(inliningTarget, value)"})
        public static Object setContext(Object self, Object value, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyExceptionInstanceCheckNode check, @Cached.Shared @Cached ExceptionNodes.SetContextNode setContextNode) {
            setContextNode.execute(inliningTarget, self, value);
            return PNone.NONE;
        }

        @Specialization(guards={"isNone(value)"})
        public static Object setContext(Object self, PNone value, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached ExceptionNodes.SetContextNode setContextNode) {
            setContextNode.execute(inliningTarget, self, PNone.NONE);
            return PNone.NONE;
        }

        @Specialization(guards={"!isNoValue(value)", "!check.execute(inliningTarget, value)"})
        public static Object context(Object self, Object value, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyExceptionInstanceCheckNode check, @Cached PRaiseNode raise) {
            throw raise.raise(PythonBuiltinClassType.TypeError, ErrorMessages.EXCEPTION_CONTEXT_MUST_BE_NONE_OR_DERIVE_FROM_BASE_EX);
        }
    }

    @Builtin(name="__cause__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    public static abstract class CauseNode
    extends PythonBuiltinNode {
        @Specialization(guards={"isNoValue(value)"})
        public static Object getCause(Object self, PNone value, @Bind(value="this") Node inliningTarget, @Cached ExceptionNodes.GetCauseNode getCauseNode) {
            return getCauseNode.execute(inliningTarget, self);
        }

        @Specialization(guards={"!isNoValue(value)", "check.execute(inliningTarget, value)"})
        public static Object setCause(Object self, Object value, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyExceptionInstanceCheckNode check, @Cached.Shared @Cached ExceptionNodes.SetCauseNode setCauseNode) {
            setCauseNode.execute(inliningTarget, self, value);
            return PNone.NONE;
        }

        @Specialization(guards={"isNone(value)"})
        public static Object setCause(Object self, PNone value, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached ExceptionNodes.SetCauseNode setCauseNode) {
            setCauseNode.execute(inliningTarget, self, PNone.NONE);
            return PNone.NONE;
        }

        @Specialization(guards={"!isNoValue(value)", "!check.execute(inliningTarget, value)"})
        public static Object cause(Object self, Object value, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyExceptionInstanceCheckNode check, @Cached PRaiseNode raise) {
            throw raise.raise(PythonBuiltinClassType.TypeError, ErrorMessages.EXCEPTION_CAUSE_MUST_BE_NONE_OR_DERIVE_FROM_BASE_EX);
        }
    }

    @Builtin(name="args", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    public static abstract class ArgsNode
    extends PythonBuiltinNode {
        @Specialization(guards={"isNoValue(none)"})
        static Object args(Object self, PNone none, @Bind(value="this") Node inliningTarget, @Cached ExceptionNodes.GetArgsNode getArgsNode) {
            return getArgsNode.execute(inliningTarget, self);
        }

        @Specialization(guards={"!isNoValue(value)"})
        static Object args(VirtualFrame frame, Object self, Object value, @Bind(value="this") Node inliningTarget, @Cached CastToListExpressionNode.CastToListNode castToList, @Cached SequenceStorageNodes.CopyInternalArrayNode copy, @Cached ExceptionNodes.SetArgsNode setArgsNode, @Cached PythonObjectFactory factory) {
            PList list = castToList.execute(frame, value);
            setArgsNode.execute(inliningTarget, self, factory.createTuple(copy.execute(inliningTarget, list.getSequenceStorage())));
            return PNone.NONE;
        }
    }

    @Builtin(name="__init__", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    public static abstract class BaseExceptionInitNode
    extends PythonVarargsBuiltinNode {
        @Node.Child
        private SplitArgsNode splitArgsNode;

        public final Object execute(Object self, Object[] args) {
            return this.execute(null, self, args, PKeyword.EMPTY_KEYWORDS);
        }

        @Override
        public Object varArgExecute(VirtualFrame frame, Object self, Object[] arguments, PKeyword[] keywords) throws PythonVarargsBuiltinNode.VarargsBuiltinDirectInvocationNotSupported {
            if (arguments.length == 0) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw PythonVarargsBuiltinNode.VarargsBuiltinDirectInvocationNotSupported.INSTANCE;
            }
            if (this.splitArgsNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.splitArgsNode = (SplitArgsNode)this.insert(SplitArgsNode.create());
            }
            Object[] argsWithoutSelf = this.splitArgsNode.executeCached(arguments);
            return this.execute(frame, arguments[0], argsWithoutSelf, keywords);
        }

        @Specialization(guards={"args.length == 0", "keywords.length == 0"})
        static Object doNoArguments(PBaseException self, Object[] args, PKeyword[] keywords) {
            self.setArgs(null);
            return PNone.NONE;
        }

        @Specialization(guards={"args.length != 0", "keywords.length == 0"})
        Object doWithArguments(PBaseException self, Object[] args, PKeyword[] keywords) {
            self.setArgs(this.factory().createTuple(args));
            return PNone.NONE;
        }

        @Specialization(replaces={"doNoArguments", "doWithArguments"})
        Object doGeneric(PBaseException self, Object[] args, PKeyword[] keywords) {
            if (keywords.length != 0) {
                throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.P_TAKES_NO_KEYWORD_ARGS, self);
            }
            if (args.length == 0) {
                self.setArgs(null);
            } else {
                self.setArgs(this.factory().createTuple(args));
            }
            return PNone.NONE;
        }

        @Specialization
        Object doNative(PythonAbstractNativeObject self, Object[] args, PKeyword[] keywords, @Bind(value="this") Node inliningTarget, @Cached ExceptionNodes.SetArgsNode setArgsNode) {
            if (keywords.length != 0) {
                throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.P_TAKES_NO_KEYWORD_ARGS, self);
            }
            if (args.length == 0) {
                setArgsNode.execute(inliningTarget, self, this.factory().createEmptyTuple());
            } else {
                setArgsNode.execute(inliningTarget, self, this.factory().createTuple(args));
            }
            return PNone.NONE;
        }
    }
}

