/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.csv;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.csv.CSVDialect;
import com.oracle.graal.python.builtins.modules.csv.CSVModuleBuiltins;
import com.oracle.graal.python.builtins.modules.csv.CSVReader;
import com.oracle.graal.python.builtins.modules.csv.CSVReaderBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.csv.QuoteStyle;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.lib.GetNextNode;
import com.oracle.graal.python.lib.PyNumberFloatNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.builtins.ListNodes;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import com.oracle.truffle.api.strings.TruffleStringIterator;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.CSVReader})
public final class CSVReaderBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return CSVReaderBuiltinsFactory.getFactories();
    }

    @Builtin(name="line_num", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class GetLineNumNode
    extends PythonUnaryBuiltinNode {
        GetLineNumNode() {
        }

        @Specialization
        static int doIt(CSVReader self) {
            return self.lineNum;
        }
    }

    @Builtin(name="dialect", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class GetDialectNode
    extends PythonUnaryBuiltinNode {
        GetDialectNode() {
        }

        @Specialization
        static CSVDialect doIt(CSVReader self) {
            return self.dialect;
        }
    }

    @Builtin(name="__next__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class NextReaderNode
    extends PythonUnaryBuiltinNode {
        private static final int EOL = -2;
        private static final int NEWLINE_CODEPOINT = 10;
        private static final int CARRIAGE_RETURN_CODEPOINT = 13;
        private static final int SPACE_CODEPOINT = 32;

        @Specialization
        static Object nextPos(VirtualFrame frame, CSVReader self, @Bind(value="this") Node inliningTarget, @Cached TruffleString.ByteIndexOfCodePointNode byteIndexOfCodePointNode, @Cached TruffleString.CreateCodePointIteratorNode createCodePointIteratorNode, @Cached TruffleStringIterator.NextNode nextNode, @Cached TruffleStringBuilder.AppendCodePointNode appendCodePointNode, @Cached TruffleStringBuilder.ToStringNode toStringNode, @Cached PyNumberFloatNode pyNumberFloatNode, @Cached ListNodes.AppendNode appendNode, @Cached GetNextNode getNextNode, @Cached CastToTruffleStringNode castToStringNode, @Cached GetClassNode getClassNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile isBuiltinClassProfile, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            PList fields = factory.createList();
            CSVModuleBuiltins csvModuleBuiltins = (CSVModuleBuiltins)PythonContext.get(inliningTarget).lookupBuiltinModule(CSVModuleBuiltins.T__CSV).getBuiltins();
            self.parseReset();
            do {
                TruffleString line;
                Object lineObj;
                try {
                    lineObj = getNextNode.execute((Frame)frame, self.inputIter);
                }
                catch (PException e) {
                    e.expectStopIteration(inliningTarget, isBuiltinClassProfile);
                    self.fieldLimit = csvModuleBuiltins.fieldLimit;
                    if (!self.field.isEmpty() || self.state == CSVReader.ReaderState.IN_QUOTED_FIELD) {
                        if (self.dialect.strict) {
                            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.CSVError, ErrorMessages.UNEXPECTED_END_OF_DATA);
                        }
                        try {
                            NextReaderNode.parseSaveField(inliningTarget, self, fields, toStringNode, pyNumberFloatNode, appendNode);
                            break;
                        }
                        catch (AbstractTruffleException ignored) {
                            throw e;
                        }
                    }
                    throw raiseNode.get(inliningTarget).raiseStopIteration();
                }
                self.fieldLimit = csvModuleBuiltins.fieldLimit;
                try {
                    line = castToStringNode.execute(inliningTarget, lineObj);
                }
                catch (CannotCastException e) {
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.CSVError, ErrorMessages.WRONG_ITERATOR_RETURN_TYPE, getClassNode.execute(inliningTarget, lineObj));
                }
                ++self.lineNum;
                TruffleStringIterator tsi = createCodePointIteratorNode.execute((AbstractTruffleString)line, PythonUtils.TS_ENCODING);
                while (tsi.hasNext()) {
                    int codepoint = nextNode.execute(tsi);
                    NextReaderNode.parseProcessCodePoint(inliningTarget, self, fields, codepoint, appendCodePointNode, toStringNode, pyNumberFloatNode, appendNode, raiseNode);
                }
                NextReaderNode.parseProcessCodePoint(inliningTarget, self, fields, -2, appendCodePointNode, toStringNode, pyNumberFloatNode, appendNode, raiseNode);
            } while (self.state != CSVReader.ReaderState.START_RECORD);
            return fields;
        }

        private static void parseProcessCodePoint(Node inliningTarget, CSVReader self, PList fields, int codePoint, TruffleStringBuilder.AppendCodePointNode appendCodePointNode, TruffleStringBuilder.ToStringNode toStringNode, PyNumberFloatNode pyNumberFloatNode, ListNodes.AppendNode appendNode, PRaiseNode.Lazy raiseNode) {
            CSVDialect dialect = self.dialect;
            switch (self.state) {
                case START_RECORD: {
                    if (codePoint == -2) break;
                    if (codePoint == 10 || codePoint == 13) {
                        self.state = CSVReader.ReaderState.EAT_CRNL;
                        break;
                    }
                    self.state = CSVReader.ReaderState.START_FIELD;
                }
                case START_FIELD: {
                    if (codePoint == 10 || codePoint == 13 || codePoint == -2) {
                        NextReaderNode.parseSaveField(inliningTarget, self, fields, toStringNode, pyNumberFloatNode, appendNode);
                        self.state = codePoint == -2 ? CSVReader.ReaderState.START_RECORD : CSVReader.ReaderState.EAT_CRNL;
                        break;
                    }
                    if (codePoint == dialect.quoteCharCodePoint && dialect.quoting != QuoteStyle.QUOTE_NONE) {
                        self.state = CSVReader.ReaderState.IN_QUOTED_FIELD;
                        break;
                    }
                    if (codePoint == dialect.escapeCharCodePoint) {
                        self.state = CSVReader.ReaderState.ESCAPED_CHAR;
                        break;
                    }
                    if (codePoint == 32 && dialect.skipInitialSpace) break;
                    if (codePoint == dialect.delimiterCodePoint) {
                        NextReaderNode.parseSaveField(inliningTarget, self, fields, toStringNode, pyNumberFloatNode, appendNode);
                        break;
                    }
                    if (dialect.quoting == QuoteStyle.QUOTE_NONNUMERIC) {
                        self.numericField = true;
                    }
                    NextReaderNode.parseAddCodePoint(inliningTarget, self, codePoint, appendCodePointNode, raiseNode);
                    self.state = CSVReader.ReaderState.IN_FIELD;
                    break;
                }
                case ESCAPED_CHAR: {
                    if (codePoint == 10 || codePoint == 13) {
                        NextReaderNode.parseAddCodePoint(inliningTarget, self, codePoint, appendCodePointNode, raiseNode);
                        self.state = CSVReader.ReaderState.AFTER_ESCAPED_CRNL;
                        break;
                    }
                    if (codePoint == -2) {
                        codePoint = 10;
                    }
                    NextReaderNode.parseAddCodePoint(inliningTarget, self, codePoint, appendCodePointNode, raiseNode);
                    self.state = CSVReader.ReaderState.IN_FIELD;
                    break;
                }
                case AFTER_ESCAPED_CRNL: {
                    if (codePoint == -2) break;
                }
                case IN_FIELD: {
                    if (codePoint == 10 || codePoint == 13 || codePoint == -2) {
                        NextReaderNode.parseSaveField(inliningTarget, self, fields, toStringNode, pyNumberFloatNode, appendNode);
                        self.state = codePoint == -2 ? CSVReader.ReaderState.START_RECORD : CSVReader.ReaderState.EAT_CRNL;
                        break;
                    }
                    if (codePoint == dialect.escapeCharCodePoint) {
                        self.state = CSVReader.ReaderState.ESCAPED_CHAR;
                        break;
                    }
                    if (codePoint == dialect.delimiterCodePoint) {
                        NextReaderNode.parseSaveField(inliningTarget, self, fields, toStringNode, pyNumberFloatNode, appendNode);
                        self.state = CSVReader.ReaderState.START_FIELD;
                        break;
                    }
                    NextReaderNode.parseAddCodePoint(inliningTarget, self, codePoint, appendCodePointNode, raiseNode);
                    break;
                }
                case IN_QUOTED_FIELD: {
                    if (codePoint == -2) break;
                    if (codePoint == dialect.escapeCharCodePoint) {
                        self.state = CSVReader.ReaderState.ESCAPE_IN_QUOTED_FIELD;
                        break;
                    }
                    if (codePoint == dialect.quoteCharCodePoint && dialect.quoting != QuoteStyle.QUOTE_NONE) {
                        if (dialect.doubleQuote) {
                            self.state = CSVReader.ReaderState.QUOTE_IN_QUOTED_FIELD;
                            break;
                        }
                        self.state = CSVReader.ReaderState.IN_FIELD;
                        break;
                    }
                    NextReaderNode.parseAddCodePoint(inliningTarget, self, codePoint, appendCodePointNode, raiseNode);
                    break;
                }
                case ESCAPE_IN_QUOTED_FIELD: {
                    if (codePoint == -2) {
                        codePoint = 10;
                    }
                    NextReaderNode.parseAddCodePoint(inliningTarget, self, codePoint, appendCodePointNode, raiseNode);
                    self.state = CSVReader.ReaderState.IN_QUOTED_FIELD;
                    break;
                }
                case QUOTE_IN_QUOTED_FIELD: {
                    if (dialect.quoting != QuoteStyle.QUOTE_NONE && codePoint == dialect.quoteCharCodePoint) {
                        NextReaderNode.parseAddCodePoint(inliningTarget, self, codePoint, appendCodePointNode, raiseNode);
                        self.state = CSVReader.ReaderState.IN_QUOTED_FIELD;
                        break;
                    }
                    if (codePoint == dialect.delimiterCodePoint) {
                        NextReaderNode.parseSaveField(inliningTarget, self, fields, toStringNode, pyNumberFloatNode, appendNode);
                        self.state = CSVReader.ReaderState.START_FIELD;
                        break;
                    }
                    if (codePoint == 10 || codePoint == 13 || codePoint == -2) {
                        NextReaderNode.parseSaveField(inliningTarget, self, fields, toStringNode, pyNumberFloatNode, appendNode);
                        self.state = codePoint == -2 ? CSVReader.ReaderState.START_RECORD : CSVReader.ReaderState.EAT_CRNL;
                        break;
                    }
                    if (!dialect.strict) {
                        NextReaderNode.parseAddCodePoint(inliningTarget, self, codePoint, appendCodePointNode, raiseNode);
                        self.state = CSVReader.ReaderState.IN_FIELD;
                        break;
                    }
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.CSVError, ErrorMessages.S_EXPECTED_AFTER_S, dialect.delimiter, dialect.quoteChar);
                }
                case EAT_CRNL: {
                    if (codePoint == 10 || codePoint == 13) break;
                    if (codePoint == -2) {
                        self.state = CSVReader.ReaderState.START_RECORD;
                        break;
                    }
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.CSVError, ErrorMessages.NEWLINE_IN_UNQOUTED_FIELD);
                }
            }
        }

        private static void parseSaveField(Node inliningTarget, CSVReader self, PList fields, TruffleStringBuilder.ToStringNode toStringNode, PyNumberFloatNode pyNumberFloatNode, ListNodes.AppendNode appendNode) {
            TruffleString field = toStringNode.execute(self.field);
            self.field = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
            if (self.numericField) {
                self.numericField = false;
                appendNode.execute(fields, pyNumberFloatNode.execute(inliningTarget, field));
            } else {
                appendNode.execute(fields, field);
            }
        }

        private static void parseAddCodePoint(Node inliningTarget, CSVReader self, int codePoint, TruffleStringBuilder.AppendCodePointNode appendCodePointNode, PRaiseNode.Lazy raise) {
            assert (PythonUtils.TS_ENCODING == TruffleString.Encoding.UTF_32);
            int cpLen = self.field.byteLength() / 4;
            if ((long)(cpLen + 1) > self.fieldLimit) {
                throw raise.get(inliningTarget).raise(PythonBuiltinClassType.CSVError, ErrorMessages.LARGER_THAN_FIELD_SIZE_LIMIT, self.fieldLimit);
            }
            appendCodePointNode.execute(self.field, codePoint, 1, true);
        }
    }

    @Builtin(name="__iter__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class IterReaderNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object iter(CSVReader self) {
            return self;
        }
    }
}

