/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.enterprise.builtins.objects.pickle;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.memoryview.MemoryViewNodes;
import com.oracle.graal.python.builtins.objects.memoryview.PMemoryView;
import com.oracle.graal.python.enterprise.builtins.nodes.EnterpriseErrorMessages;
import com.oracle.graal.python.enterprise.builtins.objects.pickle.PPickleBuffer;
import com.oracle.graal.python.enterprise.builtins.objects.pickle.PickleBufferBuiltinsFactory;
import com.oracle.graal.python.lib.PyMemoryViewFromObject;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.util.BufferFormat;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PickleBuffer})
public class PickleBufferBuiltins
extends PythonBuiltins {
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return PickleBufferBuiltinsFactory.getFactories();
    }

    @Builtin(name="release", minNumOfPositionalArgs=1, parameterNames={"$self"})
    @GenerateNodeFactory
    public static abstract class PickleBufferReleaseNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object release(PPickleBuffer self, @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib) {
            Object view = self.getView();
            if (view != null) {
                bufferLib.release(view);
                self.release();
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="raw", minNumOfPositionalArgs=1, parameterNames={"$self"})
    @GenerateNodeFactory
    public static abstract class PickleBufferRawNode
    extends PythonUnaryBuiltinNode {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        Object raw(VirtualFrame frame, PPickleBuffer self, @Bind(value="this") Node inliningTarget, @Cached PyMemoryViewFromObject memoryViewFromObject, @Cached MemoryViewNodes.ReleaseNode releaseNode) {
            Object view = self.getView();
            if (view == null) {
                throw this.raise(PythonBuiltinClassType.ValueError, EnterpriseErrorMessages.OP_FORBIDDEN_ON_OBJECT, new Object[]{"PickleBuffer"});
            }
            PMemoryView mv = memoryViewFromObject.execute(frame, (Object)self);
            try {
                if (!mv.isCContiguous() && !mv.isFortranContiguous()) {
                    throw this.raise(PythonBuiltinClassType.BufferError, EnterpriseErrorMessages.CANNOT_EXTRACT_RAW_BUFFER_FROM_NON_CONTIGUOUS);
                }
                int[] shape = new int[]{mv.getLength()};
                int[] strides = new int[]{1};
                PMemoryView pMemoryView = this.factory().createMemoryView(this.getContext(), mv.getLifecycleManager(), mv.getBuffer(), mv.getOwner(), mv.getLength(), mv.isReadOnly(), 1, BufferFormat.UINT_8, BufferFormat.T_UINT_8_TYPE_CODE, 1, mv.getBufferPointer(), mv.getOffset(), shape, strides, null, 6);
                return pMemoryView;
            }
            finally {
                releaseNode.execute(frame, mv);
            }
        }
    }
}

