/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jni;

import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.jni.CallVariant;
import com.oracle.svm.core.jni.functions.JNIFunctionTables;
import com.oracle.svm.core.jni.functions.JNIFunctions;
import com.oracle.svm.core.jni.functions.JNIFunctionsJDK19OrLater;
import com.oracle.svm.core.jni.functions.JNIInvocationInterface;
import com.oracle.svm.core.jni.headers.JNIInvokeInterface;
import com.oracle.svm.core.jni.headers.JNINativeInterface;
import com.oracle.svm.core.jni.headers.JNINativeInterfaceJDK19OrLater;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.c.info.ElementInfo;
import com.oracle.svm.hosted.c.info.StructFieldInfo;
import com.oracle.svm.hosted.c.info.StructInfo;
import com.oracle.svm.hosted.code.CEntryPointCallStubSupport;
import com.oracle.svm.hosted.code.CEntryPointData;
import com.oracle.svm.hosted.code.EntryPointCallStubMethod;
import com.oracle.svm.hosted.jni.JNIAccessFeature;
import com.oracle.svm.hosted.jni.JNICallTrampolineMethod;
import com.oracle.svm.hosted.jni.JNIFieldAccessorMethod;
import com.oracle.svm.hosted.jni.JNIPrimitiveArrayOperationMethod;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.lang.reflect.AnnotatedElement;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.AnnotationAccess;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.hosted.Feature;

public class JNIFunctionTablesFeature
implements Feature {
    private final EnumSet<JavaKind> jniKinds = EnumSet.of(JavaKind.Object, new JavaKind[]{JavaKind.Boolean, JavaKind.Byte, JavaKind.Char, JavaKind.Short, JavaKind.Int, JavaKind.Long, JavaKind.Float, JavaKind.Double, JavaKind.Void});
    private StructInfo functionTableMetadata;
    private StructInfo functionTableMetadataJDK19OrLater;
    private StructInfo invokeInterfaceMetadata;
    private ResolvedJavaMethod[] generatedMethods;

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return Arrays.asList(JNIAccessFeature.class);
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess arg) {
        FeatureImpl.BeforeAnalysisAccessImpl access = (FeatureImpl.BeforeAnalysisAccessImpl)arg;
        AnalysisMetaAccess metaAccess = access.getMetaAccess();
        JNIFunctionTables.create();
        NativeLibraries nativeLibraries = access.getNativeLibraries();
        AnalysisType invokeInterface = metaAccess.lookupJavaType(JNIInvokeInterface.class);
        this.invokeInterfaceMetadata = (StructInfo)nativeLibraries.findElementInfo((AnnotatedElement)invokeInterface);
        AnalysisType functionTable = metaAccess.lookupJavaType(JNINativeInterface.class);
        this.functionTableMetadata = (StructInfo)nativeLibraries.findElementInfo((AnnotatedElement)functionTable);
        if (JavaVersionUtil.JAVA_SPEC > 17) {
            this.functionTableMetadataJDK19OrLater = (StructInfo)nativeLibraries.findElementInfo((AnnotatedElement)metaAccess.lookupJavaType(JNINativeInterfaceJDK19OrLater.class));
        }
        AnalysisType invokes = metaAccess.lookupJavaType(JNIInvocationInterface.class);
        AnalysisType exports = metaAccess.lookupJavaType(JNIInvocationInterface.Exports.class);
        AnalysisType functions = metaAccess.lookupJavaType(JNIFunctions.class);
        AnalysisType functionsJDK19OrLater = JavaVersionUtil.JAVA_SPEC <= 17 ? null : metaAccess.lookupJavaType(JNIFunctionsJDK19OrLater.class);
        Stream analysisMethods = Stream.of(invokes, functions, functionsJDK19OrLater, exports).filter(type -> type != null).flatMap(type -> Stream.of(type.getDeclaredMethods()));
        Stream<AnalysisMethod> unimplementedMethods = Stream.of((AnalysisMethod)JNIFunctionTablesFeature.getSingleMethod((MetaAccessProvider)metaAccess, JNIFunctions.UnimplementedWithJNIEnvArgument.class), (AnalysisMethod)JNIFunctionTablesFeature.getSingleMethod((MetaAccessProvider)metaAccess, JNIFunctions.UnimplementedWithJavaVMArgument.class));
        Stream.concat(analysisMethods, unimplementedMethods).forEach(method -> {
            CEntryPoint annotation = (CEntryPoint)AnnotationAccess.getAnnotation((AnnotatedElement)method, CEntryPoint.class);
            assert (annotation != null) : "only entry points allowed in class";
            CEntryPointCallStubSupport.singleton().registerStubForMethod((AnalysisMethod)method, () -> {
                CEntryPointData data = CEntryPointData.create((ResolvedJavaMethod)method);
                if (!SubstrateOptions.JNIExportSymbols.getValue().booleanValue() && data.getPublishAs() != CEntryPoint.Publish.NotPublished) {
                    data = data.copyWithPublishAs(CEntryPoint.Publish.NotPublished);
                }
                return data;
            });
        });
        ArrayList<EntryPointCallStubMethod> generated = new ArrayList<EntryPointCallStubMethod>();
        MetaAccessProvider wrappedMetaAccess = metaAccess.getWrapped();
        ResolvedJavaType generatedMethodClass = wrappedMetaAccess.lookupJavaType(JNIFunctions.class);
        ConstantPool constantPool = generatedMethodClass.getDeclaredMethods()[0].getConstantPool();
        Object fldKinds = this.jniKinds.clone();
        ((AbstractCollection)fldKinds).remove(JavaKind.Void);
        Iterator iterator = ((AbstractCollection)fldKinds).iterator();
        while (iterator.hasNext()) {
            boolean[] trueFalse;
            JavaKind kind = (JavaKind)iterator.next();
            for (boolean isSetter : trueFalse = new boolean[]{true, false}) {
                for (boolean isStatic : trueFalse) {
                    JNIFieldAccessorMethod method2 = ((JNIFieldAccessorMethod.Factory)ImageSingletons.lookup(JNIFieldAccessorMethod.Factory.class)).create(kind, isSetter, isStatic, generatedMethodClass, constantPool, wrappedMetaAccess);
                    AnalysisMethod analysisMethod = access.getUniverse().lookup((JavaMethod)method2);
                    access.getBigBang().addRootMethod(analysisMethod, true).registerAsEntryPoint((Object)method2.createEntryPointData());
                    generated.add(method2);
                }
            }
        }
        Object primitiveArrayKinds = this.jniKinds.clone();
        ((AbstractCollection)primitiveArrayKinds).remove(JavaKind.Void);
        ((AbstractCollection)primitiveArrayKinds).remove(JavaKind.Object);
        Iterator iterator2 = ((AbstractCollection)primitiveArrayKinds).iterator();
        while (iterator2.hasNext()) {
            JavaKind kind = (JavaKind)iterator2.next();
            for (JNIPrimitiveArrayOperationMethod.Operation op : JNIPrimitiveArrayOperationMethod.Operation.values()) {
                JNIPrimitiveArrayOperationMethod method3 = new JNIPrimitiveArrayOperationMethod(kind, op, generatedMethodClass, constantPool, wrappedMetaAccess);
                AnalysisMethod analysisMethod = access.getUniverse().lookup((JavaMethod)method3);
                access.getBigBang().addRootMethod(analysisMethod, true).registerAsEntryPoint((Object)method3.createEntryPointData());
                generated.add(method3);
            }
        }
        this.generatedMethods = generated.toArray(new ResolvedJavaMethod[0]);
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess a) {
        FeatureImpl.BeforeCompilationAccessImpl access = (FeatureImpl.BeforeCompilationAccessImpl)a;
        this.fillJNIInvocationInterfaceTable(access);
        this.fillJNIFunctionsTable(access);
    }

    private static CFunctionPointer prepareCallTrampoline(FeatureImpl.CompilationAccessImpl access, CallVariant variant, boolean nonVirtual) {
        JNICallTrampolineMethod trampolineMethod = JNIAccessFeature.singleton().getCallTrampolineMethod(variant, nonVirtual);
        AnalysisMethod analysisTrampoline = access.getUniverse().getBigBang().getUniverse().lookup((JavaMethod)trampolineMethod);
        HostedMethod hostedTrampoline = access.getUniverse().lookup((JavaMethod)analysisTrampoline);
        hostedTrampoline.compilationInfo.setCustomParseFunction(trampolineMethod.createCustomParseFunction());
        hostedTrampoline.compilationInfo.setCustomCompileFunction(trampolineMethod.createCustomCompileFunction());
        return new MethodPointer(hostedTrampoline);
    }

    private static ResolvedJavaMethod getSingleMethod(MetaAccessProvider metaAccess, Class<?> holder) {
        ResolvedJavaMethod[] methods = metaAccess.lookupJavaType(holder).getDeclaredMethods();
        assert (methods.length == 1);
        return methods[0];
    }

    private static CFunctionPointer getStubFunctionPointer(FeatureImpl.CompilationAccessImpl access, HostedMethod method) {
        AnalysisMethod stub = CEntryPointCallStubSupport.singleton().getStubForMethod(method.getWrapped());
        return new MethodPointer(access.getUniverse().lookup((JavaMethod)stub));
    }

    private void fillJNIInvocationInterfaceTable(FeatureImpl.CompilationAccessImpl access) {
        CFunctionPointer unimplementedWithJavaVMArgument = JNIFunctionTablesFeature.getStubFunctionPointer(access, (HostedMethod)JNIFunctionTablesFeature.getSingleMethod((MetaAccessProvider)access.getMetaAccess(), JNIFunctions.UnimplementedWithJavaVMArgument.class));
        JNIFunctionTables.singleton().initInvokeInterfaceTable(unimplementedWithJavaVMArgument, access);
        ResolvedJavaType invokes = access.getMetaAccess().lookupJavaType((Class)JNIInvocationInterface.class);
        for (HostedMethod method : invokes.getDeclaredMethods()) {
            StructFieldInfo field = JNIFunctionTablesFeature.findFieldFor(this.invokeInterfaceMetadata, method.getName());
            int offset = field.getOffsetInfo().getProperty();
            JNIFunctionTables.singleton().initInvokeInterfaceEntry(offset, JNIFunctionTablesFeature.getStubFunctionPointer(access, method));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void fillJNIFunctionsTable(FeatureImpl.CompilationAccessImpl access) {
        int offset;
        StructFieldInfo field;
        JNIFunctionTables tables = JNIFunctionTables.singleton();
        CFunctionPointer unimplementedWithJNIEnvArgument = JNIFunctionTablesFeature.getStubFunctionPointer(access, (HostedMethod)JNIFunctionTablesFeature.getSingleMethod((MetaAccessProvider)access.getMetaAccess(), JNIFunctions.UnimplementedWithJNIEnvArgument.class));
        tables.initFunctionTable(unimplementedWithJNIEnvArgument, access);
        ResolvedJavaType functions = access.getMetaAccess().lookupJavaType((Class)JNIFunctions.class);
        for (HostedMethod hostedMethod : functions.getDeclaredMethods()) {
            field = JNIFunctionTablesFeature.findFieldFor(this.functionTableMetadata, hostedMethod.getName());
            int offset2 = field.getOffsetInfo().getProperty();
            tables.initFunctionEntry(offset2, JNIFunctionTablesFeature.getStubFunctionPointer(access, hostedMethod));
        }
        if (JavaVersionUtil.JAVA_SPEC > 17) {
            void var8_15;
            ResolvedJavaType resolvedJavaType = access.getMetaAccess().lookupJavaType((Class)JNIFunctionsJDK19OrLater.class);
            HostedMethod[] hostedMethodArray = resolvedJavaType.getDeclaredMethods();
            int n = hostedMethodArray.length;
            boolean bl = false;
            while (var8_15 < n) {
                HostedMethod method2 = hostedMethodArray[var8_15];
                StructFieldInfo field2 = JNIFunctionTablesFeature.findFieldFor(this.functionTableMetadataJDK19OrLater, method2.getName());
                int offset3 = field2.getOffsetInfo().getProperty();
                tables.initFunctionEntry(offset3, JNIFunctionTablesFeature.getStubFunctionPointer(access, method2));
                ++var8_15;
            }
        }
        for (ResolvedJavaMethod resolvedJavaMethod : this.generatedMethods) {
            field = JNIFunctionTablesFeature.findFieldFor(this.functionTableMetadata, resolvedJavaMethod.getName());
            AnalysisUniverse analysisUniverse = access.getUniverse().getBigBang().getUniverse();
            AnalysisMethod analysisMethod = analysisUniverse.lookup((JavaMethod)resolvedJavaMethod);
            HostedMethod hostedMethod = access.getUniverse().lookup((JavaMethod)analysisMethod);
            offset = field.getOffsetInfo().getProperty();
            tables.initFunctionEntry(offset, new MethodPointer(hostedMethod));
        }
        for (CallVariant callVariant : CallVariant.values()) {
            CFunctionPointer trampoline = JNIFunctionTablesFeature.prepareCallTrampoline(access, callVariant, false);
            String suffix = callVariant == CallVariant.ARRAY ? "A" : (callVariant == CallVariant.VA_LIST ? "V" : "");
            CFunctionPointer nonvirtualTrampoline = JNIFunctionTablesFeature.prepareCallTrampoline(access, callVariant, true);
            for (JavaKind kind : this.jniKinds) {
                String[] prefixes;
                for (String prefix : prefixes = new String[]{"Call", "CallStatic"}) {
                    StructFieldInfo field3 = JNIFunctionTablesFeature.findFieldFor(this.functionTableMetadata, prefix + kind.name() + "Method" + suffix);
                    int offset4 = field3.getOffsetInfo().getProperty();
                    tables.initFunctionEntry(offset4, trampoline);
                }
                StructFieldInfo field4 = JNIFunctionTablesFeature.findFieldFor(this.functionTableMetadata, "CallNonvirtual" + kind.name() + "Method" + suffix);
                int offset5 = field4.getOffsetInfo().getProperty();
                tables.initFunctionEntry(offset5, nonvirtualTrampoline);
            }
            StructFieldInfo field5 = JNIFunctionTablesFeature.findFieldFor(this.functionTableMetadata, "NewObject" + suffix);
            offset = field5.getOffsetInfo().getProperty();
            tables.initFunctionEntry(offset, trampoline);
        }
    }

    private static StructFieldInfo findFieldFor(StructInfo info, String name) {
        for (ElementInfo element : info.getChildren()) {
            StructFieldInfo field;
            if (!(element instanceof StructFieldInfo) || !(field = (StructFieldInfo)element).getName().equals(name)) continue;
            return field;
        }
        throw VMError.shouldNotReachHere("Cannot find JNI function table field for: " + name);
    }
}

