/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.heap;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.deopt.DeoptTest;
import com.oracle.svm.core.graal.nodes.DeoptEntryBeginNode;
import com.oracle.svm.core.graal.nodes.DeoptEntryNode;
import com.oracle.svm.core.graal.nodes.LoweredDeadEndNode;
import com.oracle.svm.core.graal.nodes.NewPodInstanceNode;
import com.oracle.svm.core.graal.nodes.TestDeoptimizeNode;
import com.oracle.svm.core.heap.Pod;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.annotation.CustomSubstitutionMethod;
import com.oracle.svm.hosted.code.SubstrateCompilationDirectives;
import com.oracle.svm.hosted.nodes.DeoptProxyNode;
import com.oracle.svm.hosted.phases.HostedGraphKit;
import java.util.Arrays;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.java.FrameStateBuilder;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.UnreachableBeginNode;
import org.graalvm.compiler.nodes.UnwindNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.java.ExceptionObjectNode;
import org.graalvm.compiler.nodes.java.LoadFieldNode;

final class PodFactorySubstitutionMethod
extends CustomSubstitutionMethod {
    PodFactorySubstitutionMethod(ResolvedJavaMethod original) {
        super(original);
    }

    @Override
    public boolean allowRuntimeCompilation() {
        return true;
    }

    @Override
    public int getModifiers() {
        return super.getModifiers() & 0xFFFFFEFF;
    }

    public StructuredGraph buildGraph(DebugContext debug, ResolvedJavaMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        HostedGraphKit kit = new HostedGraphKit(debug, providers, method, purpose);
        DeoptInfoProvider deoptInfo = null;
        if (MultiMethod.isDeoptTarget((ResolvedJavaMethod)method)) {
            deoptInfo = new DeoptInfoProvider((MultiMethod)method);
        }
        ResolvedJavaType factoryType = method.getDeclaringClass();
        Pod.RuntimeSupport.PodFactory annotation = (Pod.RuntimeSupport.PodFactory)factoryType.getAnnotation(Pod.RuntimeSupport.PodFactory.class);
        ResolvedJavaType podConcreteType = kit.getMetaAccess().lookupJavaType(annotation.podClass());
        ResolvedJavaMethod targetCtor = this.findMatchingConstructor(method, podConcreteType.getSuperclass());
        int instanceLocal = kit.getFrameState().localsSize() - 1;
        int nextDeoptIndex = PodFactorySubstitutionMethod.startMethod(kit, deoptInfo, 0);
        PodFactorySubstitutionMethod.instantiatePod(kit, providers, factoryType, podConcreteType, instanceLocal);
        if (this.isAnnotationPresent(DeoptTest.class)) {
            kit.append((ValueNode)new TestDeoptimizeNode());
        }
        nextDeoptIndex = PodFactorySubstitutionMethod.invokeConstructor(kit, method, deoptInfo, nextDeoptIndex, targetCtor, instanceLocal);
        kit.createReturn(kit.loadLocal(instanceLocal, JavaKind.Object), JavaKind.Object);
        return kit.finalizeGraph();
    }

    private ResolvedJavaMethod findMatchingConstructor(ResolvedJavaMethod method, ResolvedJavaType typeToSearch) {
        for (ResolvedJavaMethod ctor : typeToSearch.getDeclaredConstructors()) {
            if (!PodFactorySubstitutionMethod.parameterTypesMatch(method, ctor)) continue;
            return ctor;
        }
        throw new GraalError("Matching constructor not found: %s", new Object[]{this.getSignature()});
    }

    private static boolean shouldInsertDeoptEntry(DeoptInfoProvider deoptInfo, int bci, boolean duringCall, boolean rethrowException) {
        if (deoptInfo != null) {
            return deoptInfo.isDeoptEntry(bci, duringCall, rethrowException);
        }
        return false;
    }

    private static int startMethod(HostedGraphKit kit, DeoptInfoProvider deoptInfo, int nextDeoptIndex) {
        if (deoptInfo != null) {
            FrameState initialState = kit.getGraph().start().stateAfter();
            if (PodFactorySubstitutionMethod.shouldInsertDeoptEntry(deoptInfo, initialState.bci, false, false)) {
                return PodFactorySubstitutionMethod.appendDeoptWithExceptionUnwind(kit, initialState, initialState.bci, nextDeoptIndex);
            }
        }
        return nextDeoptIndex;
    }

    private static void instantiatePod(HostedGraphKit kit, HostedProviders providers, ResolvedJavaType factoryType, ResolvedJavaType podConcreteType, int instanceLocal) {
        ResolvedJavaType podType = kit.getMetaAccess().lookupJavaType(Pod.class);
        ValueNode receiver = kit.loadLocal(0, JavaKind.Object);
        ValueNode pod = PodFactorySubstitutionMethod.loadNonNullField(kit, receiver, PodFactorySubstitutionMethod.findField(factoryType, "pod"));
        LoadFieldNode arrayLength = kit.createLoadField(pod, PodFactorySubstitutionMethod.findField(podType, "arrayLength"));
        ValueNode refMap = PodFactorySubstitutionMethod.loadNonNullField(kit, pod, PodFactorySubstitutionMethod.findField(podType, "referenceMap"));
        ConstantNode hub = kit.createConstant(providers.getConstantReflection().asObjectHub(podConcreteType), JavaKind.Object);
        ValueNode instance = kit.append((ValueNode)new NewPodInstanceNode(podConcreteType, (ValueNode)hub, (ValueNode)arrayLength, refMap));
        kit.storeLocal(instanceLocal, JavaKind.Object, instance);
    }

    private static ValueNode loadNonNullField(HostedGraphKit kit, ValueNode object, ResolvedJavaField field) {
        return kit.append(PiNode.create((ValueNode)kit.createLoadField(object, field), (Stamp)StampFactory.objectNonNull()));
    }

    private static int invokeConstructor(HostedGraphKit kit, ResolvedJavaMethod method, DeoptInfoProvider deoptInfo, int nextDeoptIndex, ResolvedJavaMethod targetCtor, int instanceLocal) {
        ValueNode instance = kit.loadLocal(instanceLocal, JavaKind.Object);
        ValueNode[] originalArgs = kit.loadArguments(method.toParameterTypes()).toArray(ValueNode.EMPTY_ARRAY);
        ValueNode[] invokeArgs = Arrays.copyOf(originalArgs, originalArgs.length);
        invokeArgs[0] = instance;
        return PodFactorySubstitutionMethod.invokeWithDeoptAndExceptionUnwind(kit, deoptInfo, nextDeoptIndex, targetCtor, CallTargetNode.InvokeKind.Special, invokeArgs);
    }

    private static int invokeWithDeoptAndExceptionUnwind(HostedGraphKit kit, DeoptInfoProvider deoptInfo, int initialNextDeoptIndex, ResolvedJavaMethod target, CallTargetNode.InvokeKind invokeKind, ValueNode ... args) {
        int bci = kit.bci();
        InvokeWithExceptionNode invoke = kit.startInvokeWithException(target, invokeKind, kit.getFrameState(), bci, args);
        invoke.setNodeSourcePosition(NodeSourcePosition.placeholder((ResolvedJavaMethod)kit.getGraph().method(), (int)bci));
        kit.exceptionPart();
        ExceptionObjectNode exception = kit.exceptionObject();
        if (deoptInfo == null) {
            kit.append((ValueNode)new UnwindNode((ValueNode)exception));
            kit.endInvokeWithException();
            return initialNextDeoptIndex;
        }
        int nextDeoptIndex = initialNextDeoptIndex;
        if (PodFactorySubstitutionMethod.shouldInsertDeoptEntry(deoptInfo, bci, false, true)) {
            DeoptEntryNode exceptionDeopt = (DeoptEntryNode)kit.add((ValueNode)new DeoptEntryNode());
            exceptionDeopt.setStateAfter(exception.stateAfter().duplicate());
            DeoptEntryBeginNode exceptionDeoptBegin = (DeoptEntryBeginNode)kit.add((ValueNode)new DeoptEntryBeginNode());
            int exceptionDeoptIndex = nextDeoptIndex++;
            ValueNode exceptionProxy = PodFactorySubstitutionMethod.createDeoptProxy(kit, exceptionDeoptIndex, (FixedNode)exceptionDeopt, (ValueNode)exception);
            UnwindNode unwind = (UnwindNode)kit.append((ValueNode)new UnwindNode(exceptionProxy));
            exception.setNext((FixedNode)exceptionDeopt);
            exceptionDeopt.setNext(exceptionDeoptBegin);
            exceptionDeoptBegin.setNext((FixedNode)unwind);
            UnreachableBeginNode exceptionDeoptExceptionEdge = (UnreachableBeginNode)kit.add((ValueNode)new UnreachableBeginNode());
            exceptionDeoptExceptionEdge.setNext((FixedNode)kit.add((ValueNode)new LoweredDeadEndNode()));
            exceptionDeopt.setExceptionEdge((AbstractBeginNode)exceptionDeoptExceptionEdge);
        } else {
            kit.append((ValueNode)new UnwindNode((ValueNode)exception));
        }
        if (PodFactorySubstitutionMethod.shouldInsertDeoptEntry(deoptInfo, invoke.stateAfter().bci, false, false)) {
            kit.noExceptionPart();
            nextDeoptIndex = PodFactorySubstitutionMethod.appendDeoptWithExceptionUnwind(kit, invoke.stateAfter(), invoke.stateAfter().bci, nextDeoptIndex);
        } else {
            VMError.guarantee(!PodFactorySubstitutionMethod.shouldInsertDeoptEntry(deoptInfo, bci, true, false), "need to add support for inserting DeoptProxyAnchorNode");
        }
        kit.endInvokeWithException();
        return nextDeoptIndex;
    }

    private static int appendDeoptWithExceptionUnwind(HostedGraphKit kit, FrameState state, int exceptionBci, int nextDeoptIndex) {
        DeoptEntryNode entry = (DeoptEntryNode)kit.add((ValueNode)new DeoptEntryNode());
        entry.setStateAfter(state.duplicate());
        DeoptEntryBeginNode begin = (DeoptEntryBeginNode)kit.append((ValueNode)new DeoptEntryBeginNode());
        ((FixedWithNextNode)begin.predecessor()).setNext((FixedNode)entry);
        entry.setNext(begin);
        ExceptionObjectNode exception = (ExceptionObjectNode)kit.add((ValueNode)new ExceptionObjectNode(kit.getMetaAccess()));
        entry.setExceptionEdge((AbstractBeginNode)exception);
        FrameStateBuilder exState = kit.getFrameState().copy();
        exState.clearStack();
        exState.push(JavaKind.Object, (ValueNode)exception);
        exState.setRethrowException(true);
        exception.setStateAfter(exState.create(exceptionBci, (StateSplit)exception));
        exception.setNext((FixedNode)kit.add((ValueNode)new UnwindNode((ValueNode)exception)));
        kit.getFrameState().insertProxies(value -> PodFactorySubstitutionMethod.createDeoptProxy(kit, nextDeoptIndex, (FixedNode)entry, value));
        return nextDeoptIndex + 1;
    }

    private static ValueNode createDeoptProxy(HostedGraphKit kit, int nextDeoptIndex, FixedNode deoptTarget, ValueNode value) {
        return (ValueNode)kit.getGraph().addOrUniqueWithInputs((Node)DeoptProxyNode.create(value, (ValueNode)deoptTarget, nextDeoptIndex));
    }

    private static boolean parameterTypesMatch(ResolvedJavaMethod method, ResolvedJavaMethod ctor) {
        int paramsCount = method.getSignature().getParameterCount(false);
        if (paramsCount != ctor.getSignature().getParameterCount(false)) {
            return false;
        }
        for (int i = 0; i < paramsCount; ++i) {
            if (ctor.getSignature().getParameterType(i, ctor.getDeclaringClass()).equals(method.getSignature().getParameterType(i, method.getDeclaringClass()))) continue;
            return false;
        }
        return true;
    }

    private static ResolvedJavaField findField(ResolvedJavaType type, String name) {
        for (ResolvedJavaField field : type.getInstanceFields(false)) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        throw GraalError.shouldNotReachHere((String)("Required field " + name + " not found in " + type));
    }

    private static class DeoptInfoProvider {
        final MultiMethod method;

        DeoptInfoProvider(MultiMethod method) {
            this.method = method;
        }

        boolean isDeoptEntry(int bci, boolean duringCall, boolean rethrowException) {
            return SubstrateCompilationDirectives.singleton().isDeoptEntry(this.method, bci, duringCall, rethrowException);
        }
    }
}

