/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.analysis;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.reports.AnalysisReportsOptions;
import com.oracle.graal.pointsto.reports.CallTreePrinter;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.NativeImageOptions;

public class UserLimitationsChecker {
    public static void check(BigBang bb) {
        HostedOptionKey<Integer> maxReachableTypesOption = NativeImageOptions.MaxReachableTypes;
        int maxReachableTypes = maxReachableTypesOption.getValue();
        if (maxReachableTypes >= 0) {
            CallTreePrinter callTreePrinter = new CallTreePrinter(bb);
            callTreePrinter.buildCallTree();
            int numberOfTypes = callTreePrinter.classesSet(false).size();
            if (numberOfTypes > maxReachableTypes) {
                throw UserError.abort("Reachable %d types but only %d allowed (because the %s option is set). To see all reachable types use %s; to change the maximum number of allowed types use %s.", numberOfTypes, maxReachableTypes, maxReachableTypesOption.getName(), AnalysisReportsOptions.PrintAnalysisCallTree.getName(), maxReachableTypesOption.getName());
            }
        }
    }
}

