/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.hosted;

import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.svm.graal.GraalSupport;
import com.oracle.svm.graal.meta.SubstrateConstantFieldProvider;
import com.oracle.svm.graal.meta.SubstrateConstantReflectionProvider;
import com.oracle.svm.graal.meta.SubstrateMetaAccess;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.spi.ConstantFieldProvider;
import org.graalvm.compiler.core.common.spi.ForeignCallsProvider;

public class SubstrateProviders {
    private final SubstrateMetaAccess metaAccess;
    private final ConstantFieldProvider constantFieldProvider;
    private final ConstantReflectionProvider constantReflection;

    SubstrateProviders(AnalysisMetaAccess aMetaAccess, SubstrateMetaAccess metaAccess) {
        this.metaAccess = metaAccess;
        this.constantFieldProvider = new SubstrateConstantFieldProvider((MetaAccessProvider)aMetaAccess);
        this.constantReflection = new SubstrateConstantReflectionProvider(this.metaAccess);
    }

    protected SubstrateProviders(SubstrateMetaAccess metaAccess, ConstantFieldProvider constantFieldProvider, ConstantReflectionProvider constantReflection) {
        this.metaAccess = metaAccess;
        this.constantFieldProvider = constantFieldProvider;
        this.constantReflection = constantReflection;
    }

    public MetaAccessProvider getMetaAccessProvider() {
        return this.metaAccess;
    }

    public ConstantFieldProvider getConstantFieldProvider() {
        return this.constantFieldProvider;
    }

    public ConstantReflectionProvider getConstantReflectionProvider() {
        return this.constantReflection;
    }

    public SnippetReflectionProvider getSnippetReflectionProvider() {
        return GraalSupport.getRuntimeConfig().getSnippetReflection();
    }

    public ForeignCallsProvider getForeignCallsProvider() {
        return GraalSupport.getRuntimeConfig().getProviders().getForeignCalls();
    }
}

