/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.darwin;

import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.graal.stackvalue.UnsafeStackValue;
import com.oracle.svm.core.posix.PosixProcessPropertiesSupport;
import com.oracle.svm.core.posix.headers.darwin.DarwinDyld;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.PinnedObject;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.impl.ProcessPropertiesSupport;
import org.graalvm.word.WordFactory;

@AutomaticallyRegisteredImageSingleton(value={ProcessPropertiesSupport.class})
public class DarwinProcessPropertiesSupport
extends PosixProcessPropertiesSupport {
    public String getExecutableName() {
        CIntPointer sizePointer = UnsafeStackValue.get(CIntPointer.class);
        sizePointer.write(0);
        if (DarwinDyld._NSGetExecutablePath((CCharPointer)WordFactory.nullPointer(), sizePointer) != -1) {
            VMError.shouldNotReachHere("DarwinProcessPropertiesSupport.getExecutableName: Executable path length is 0?");
        }
        byte[] byteBuffer = new byte[sizePointer.read()];
        try (PinnedObject pinnedBuffer = PinnedObject.create((Object)byteBuffer);){
            CCharPointer bufferPointer = (CCharPointer)pinnedBuffer.addressOfArrayElement(0);
            if (DarwinDyld._NSGetExecutablePath(bufferPointer, sizePointer) == -1) {
                String string = null;
                return string;
            }
            String executableString = CTypeConversion.toJavaString((CCharPointer)bufferPointer);
            String string = DarwinProcessPropertiesSupport.realpath(executableString);
            return string;
        }
    }
}

