/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.hub.PredefinedClassesSupport;
import com.oracle.svm.core.jdk.JDK11OrEarlier;
import com.oracle.svm.core.jdk.LoadAverageSupport;
import com.oracle.svm.core.os.VirtualMemoryProvider;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.Field;
import java.security.ProtectionDomain;
import org.graalvm.compiler.nodes.extended.MembarNode;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.impl.UnsafeMemorySupport;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

@TargetClass(className="jdk.internal.misc.Unsafe")
final class Target_jdk_internal_misc_Unsafe_Core {
    Target_jdk_internal_misc_Unsafe_Core() {
    }

    @Substitute
    private long allocateMemory0(long bytes) {
        return UnmanagedMemory.malloc((UnsignedWord)WordFactory.unsigned((long)bytes)).rawValue();
    }

    @Substitute
    private long reallocateMemory0(long address, long bytes) {
        return UnmanagedMemory.realloc((PointerBase)((PointerBase)WordFactory.unsigned((long)address)), (UnsignedWord)WordFactory.unsigned((long)bytes)).rawValue();
    }

    @Substitute
    private void freeMemory0(long address) {
        UnmanagedMemory.free((PointerBase)((PointerBase)WordFactory.unsigned((long)address)));
    }

    @Substitute
    private void copyMemory0(Object srcBase, long srcOffset, Object destBase, long destOffset, long bytes) {
        UnsafeMemorySupport.get().unsafeCopyMemory(srcBase, srcOffset, destBase, destOffset, bytes);
    }

    @Substitute
    private void copySwapMemory0(Object srcBase, long srcOffset, Object destBase, long destOffset, long bytes, long elemSize) {
        UnsafeMemorySupport.get().unsafeCopySwapMemory(srcBase, srcOffset, destBase, destOffset, bytes, elemSize);
    }

    @Substitute
    private void setMemory0(Object destBase, long destOffset, long bytes, byte bvalue) {
        UnsafeMemorySupport.get().unsafeSetMemory(destBase, destOffset, bytes, bvalue);
    }

    @Substitute
    private int addressSize() {
        return ConfigurationValues.getTarget().wordSize;
    }

    @Substitute
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    int pageSize() {
        return (int)VirtualMemoryProvider.get().getGranularity().rawValue();
    }

    @Substitute
    public int arrayBaseOffset(Class<?> clazz) {
        return (int)LayoutEncoding.getArrayBaseOffset(DynamicHub.fromClass(clazz).getLayoutEncoding()).rawValue();
    }

    @Substitute
    public int arrayIndexScale(Class<?> clazz) {
        return LayoutEncoding.getArrayIndexScale(DynamicHub.fromClass(clazz).getLayoutEncoding());
    }

    @Substitute
    private void throwException(Throwable t) throws Throwable {
        throw t;
    }

    @Substitute
    public void loadFence() {
        MembarNode.memoryBarrier((MembarNode.FenceKind)MembarNode.FenceKind.LOAD_ACQUIRE);
    }

    @Substitute
    public void storeFence() {
        MembarNode.memoryBarrier((MembarNode.FenceKind)MembarNode.FenceKind.STORE_RELEASE);
    }

    @Substitute
    public void fullFence() {
        MembarNode.memoryBarrier((MembarNode.FenceKind)MembarNode.FenceKind.FULL);
    }

    @Substitute
    boolean shouldBeInitialized(Class<?> c) {
        return !DynamicHub.fromClass(c).isInitialized();
    }

    @Substitute
    public void ensureClassInitialized(Class<?> c) {
        DynamicHub.fromClass(c).ensureInitialized();
    }

    @Substitute
    private Class<?> defineClass(String name, byte[] b, int off, int len, ClassLoader loader, ProtectionDomain protectionDomain) {
        return PredefinedClassesSupport.loadClass(loader, name, b, off, len, protectionDomain);
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrEarlier.class})
    private Class<?> defineAnonymousClass(Class<?> hostClass, byte[] data, Object[] cpPatches) {
        throw VMError.unsupportedFeature("Defining anonymous classes at runtime is not supported.");
    }

    @Substitute
    private int getLoadAverage0(double[] loadavg, int nelems) {
        if (ImageSingletons.contains(LoadAverageSupport.class)) {
            return ((LoadAverageSupport)ImageSingletons.lookup(LoadAverageSupport.class)).getLoadAverage(loadavg, nelems);
        }
        return -1;
    }

    @Delete
    private static native void registerNatives();

    @Delete
    private native long objectFieldOffset0(Field var1);

    @Delete
    private native long objectFieldOffset1(Class<?> var1, String var2);

    @Delete
    private native long staticFieldOffset0(Field var1);

    @Delete
    private native Object staticFieldBase0(Field var1);

    @Delete
    private native boolean shouldBeInitialized0(Class<?> var1);

    @Delete
    private native void ensureClassInitialized0(Class<?> var1);

    @Delete
    private native int arrayBaseOffset0(Class<?> var1);

    @Delete
    private native int arrayIndexScale0(Class<?> var1);

    @Delete
    @TargetElement(onlyWith={JDK11OrEarlier.class})
    private native int addressSize0();

    @Substitute
    private Class<?> defineClass0(String name, byte[] b, int off, int len, ClassLoader loader, ProtectionDomain protectionDomain) {
        throw VMError.unsupportedFeature("Target_Unsafe_Core.defineClass0(String, byte[], int, int, ClassLoader, ProtectionDomain)");
    }

    @Delete
    @TargetElement(onlyWith={JDK11OrEarlier.class})
    private native Class<?> defineAnonymousClass0(Class<?> var1, byte[] var2, Object[] var3);

    @Delete
    @TargetElement(onlyWith={JDK11OrEarlier.class})
    private native boolean unalignedAccess0();

    @Delete
    @TargetElement(onlyWith={JDK11OrEarlier.class})
    private native boolean isBigEndian0();
}

