/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.containers;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.containers.CgroupUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public interface CgroupSubsystemController {
    public static final String EMPTY_STR = "";

    public String path();

    public static String getStringValue(CgroupSubsystemController controller, String param) {
        if (controller == null) {
            return null;
        }
        try {
            return CgroupUtil.readStringValue(controller, param);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static long getLongValueMatchingLine(CgroupSubsystemController controller, String param, String match, Function<String, Long> conversion, long defaultRetval) {
        long retval = defaultRetval;
        if (controller == null) {
            return retval;
        }
        try {
            Path filePath = Paths.get(controller.path(), param);
            List<String> lines = CgroupUtil.readAllLinesPrivileged(filePath);
            for (String line : lines) {
                if (!line.startsWith(match)) continue;
                retval = conversion.apply(line);
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return retval;
    }

    public static long getLongValue(CgroupSubsystemController controller, String param, Function<String, Long> conversion, long defaultRetval) {
        String strval = CgroupSubsystemController.getStringValue(controller, param);
        if (strval == null) {
            return defaultRetval;
        }
        return conversion.apply(strval);
    }

    public static double getDoubleValue(CgroupSubsystemController controller, String param, double defaultRetval) {
        String strval = CgroupSubsystemController.getStringValue(controller, param);
        if (strval == null) {
            return defaultRetval;
        }
        double retval = Double.parseDouble(strval);
        return retval;
    }

    public static long getLongEntry(CgroupSubsystemController controller, String param, String entryname, long defaultRetval) {
        if (controller == null) {
            return defaultRetval;
        }
        try {
            Optional<Object> result = Optional.empty();
            for (String line : CgroupUtil.readAllLinesPrivileged(Paths.get(controller.path(), param))) {
                String[] tokens = SubstrateUtil.split(line, " ");
                if (tokens.length != 2 || !tokens[0].equals(entryname)) continue;
                result = Optional.of(tokens[1]);
                break;
            }
            return result.isPresent() ? Long.parseLong((String)result.get()) : defaultRetval;
        }
        catch (IOException e) {
            return defaultRetval;
        }
    }

    public static int[] stringRangeToIntArray(String range) {
        String[] strs;
        if (range == null || EMPTY_STR.equals(range)) {
            return null;
        }
        ArrayList<Integer> results = new ArrayList<Integer>();
        for (String str : strs = SubstrateUtil.split(range, ",")) {
            if (str.contains("-")) {
                String[] lohi = SubstrateUtil.split(str, "-");
                if (lohi.length != 2) continue;
                int lo = Integer.parseInt(lohi[0]);
                int hi = Integer.parseInt(lohi[1]);
                for (int i = lo; i <= hi; ++i) {
                    results.add(i);
                }
                continue;
            }
            results.add(Integer.parseInt(str));
        }
        results.sort(null);
        int[] ints = new int[results.size()];
        int i = 0;
        for (Integer n : results) {
            ints[i++] = n;
        }
        return ints;
    }

    public static long convertStringToLong(String strval, long overflowRetval, long defaultRetval) {
        long retval;
        block3: {
            retval = defaultRetval;
            if (strval == null) {
                return retval;
            }
            try {
                retval = Long.parseLong(strval);
            }
            catch (NumberFormatException e) {
                if (strval.length() <= 0 || strval.charAt(0) == '-') break block3;
                return overflowRetval;
            }
        }
        return retval;
    }
}

