/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.debugentry.range;

import com.oracle.objectfile.debugentry.MethodEntry;
import com.oracle.objectfile.debugentry.range.PrimaryRange;
import com.oracle.objectfile.debugentry.range.Range;
import com.oracle.objectfile.debuginfo.DebugInfoProvider;

public abstract class SubRange
extends Range {
    private static final DebugInfoProvider.DebugLocalInfo[] EMPTY_LOCAL_INFOS = new DebugInfoProvider.DebugLocalInfo[0];
    private final PrimaryRange primary;
    protected Range caller;
    protected SubRange siblingCallee;
    private DebugInfoProvider.DebugLocalValueInfo[] localValueInfos;
    private DebugInfoProvider.DebugLocalInfo[] localInfos;

    protected SubRange(MethodEntry methodEntry, int lo, int hi, int line, PrimaryRange primary, Range caller) {
        super(methodEntry, lo, hi, line, caller == null ? 0 : caller.depth + 1);
        this.caller = caller;
        if (caller != null) {
            caller.addCallee(this);
        }
        assert (primary != null);
        this.primary = primary;
    }

    public Range getPrimary() {
        return this.primary;
    }

    @Override
    public boolean isPrimary() {
        return false;
    }

    public Range getCaller() {
        return this.caller;
    }

    @Override
    public abstract SubRange getFirstCallee();

    @Override
    public abstract boolean isLeaf();

    public int getLocalValueCount() {
        return this.localValueInfos.length;
    }

    public DebugInfoProvider.DebugLocalValueInfo getLocalValue(int i) {
        assert (i >= 0 && i < this.localValueInfos.length) : "bad index";
        return this.localValueInfos[i];
    }

    public DebugInfoProvider.DebugLocalInfo getLocal(int i) {
        assert (i >= 0 && i < this.localInfos.length) : "bad index";
        return this.localInfos[i];
    }

    public void setLocalValueInfo(DebugInfoProvider.DebugLocalValueInfo[] localValueInfos) {
        int len = localValueInfos.length;
        this.localValueInfos = localValueInfos;
        this.localInfos = len > 0 ? new DebugInfoProvider.DebugLocalInfo[len] : EMPTY_LOCAL_INFOS;
        for (int i = 0; i < len; ++i) {
            this.localInfos[i] = this.methodEntry.recordLocal(localValueInfos[i]);
        }
    }

    public DebugInfoProvider.DebugLocalValueInfo lookupValue(DebugInfoProvider.DebugLocalInfo local) {
        int localValueCount = this.getLocalValueCount();
        for (int i = 0; i < localValueCount; ++i) {
            if (this.getLocal(i) != local) continue;
            return this.getLocalValue(i);
        }
        return null;
    }

    public SubRange getSiblingCallee() {
        return this.siblingCallee;
    }
}

