/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.conf;

import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import org.flowable.ui.admin.conf.AdminDatabaseConfiguration;
import org.flowable.ui.admin.conf.DispatcherServletConfiguration;
import org.flowable.ui.admin.properties.FlowableAdminAppProperties;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.lang.NonNull;
import org.springframework.util.ClassUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration(proxyBeanMethods=false)
@ComponentScan(basePackages={"org.flowable.ui.admin.repository", "org.flowable.ui.common.repository"})
@Import(value={AdminDatabaseConfiguration.class})
@EnableConfigurationProperties(value={FlowableAdminAppProperties.class})
public class ApplicationConfiguration
implements ApplicationContextAware {
    protected ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Bean
    public ServletRegistrationBean<DispatcherServlet> flowableAdminAppServlet(ObjectProvider<MultipartConfigElement> multipartConfig) {
        AnnotationConfigWebApplicationContext dispatcherServletConfiguration = new AnnotationConfigWebApplicationContext();
        dispatcherServletConfiguration.setParent(this.applicationContext);
        dispatcherServletConfiguration.register(new Class[]{DispatcherServletConfiguration.class});
        DispatcherServlet servlet = new DispatcherServlet((WebApplicationContext)dispatcherServletConfiguration);
        ServletRegistrationBean registrationBean = new ServletRegistrationBean((Servlet)servlet, new String[]{"/admin-app/*"});
        registrationBean.setName("Flowable Admin App");
        registrationBean.setLoadOnStartup(1);
        registrationBean.setAsyncSupported(true);
        multipartConfig.ifAvailable(arg_0 -> ((ServletRegistrationBean)registrationBean).setMultipartConfig(arg_0));
        return registrationBean;
    }

    @Bean
    public WebMvcConfigurer adminApplicationWebMvcConfigurer() {
        return new WebMvcConfigurer(){

            public void addViewControllers(@NonNull ViewControllerRegistry registry) {
                if (!ClassUtils.isPresent((String)"org.flowable.ui.task.conf.ApplicationConfiguration", (ClassLoader)this.getClass().getClassLoader())) {
                    registry.addViewController("/").setViewName("redirect:/admin/");
                }
                registry.addViewController("/admin").setViewName("redirect:/admin/");
                registry.addViewController("/admin/").setViewName("forward:/admin/index.html");
            }
        };
    }
}

