/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.validation.validator.impl;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.CompensateEventDefinition;
import org.flowable.bpmn.model.Event;
import org.flowable.bpmn.model.EventDefinition;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.MessageEventDefinition;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SignalEventDefinition;
import org.flowable.bpmn.model.TimerEventDefinition;
import org.flowable.validation.ValidationError;
import org.flowable.validation.validator.ProcessLevelValidator;

public class EventValidator
extends ProcessLevelValidator {
    @Override
    protected void executeValidation(BpmnModel bpmnModel, Process process, List<ValidationError> errors) {
        List events = process.findFlowElementsOfType(Event.class);
        for (Event event : events) {
            if (event.getEventDefinitions() == null) continue;
            for (EventDefinition eventDefinition : event.getEventDefinitions()) {
                if (eventDefinition instanceof MessageEventDefinition) {
                    this.handleMessageEventDefinition(bpmnModel, process, event, eventDefinition, errors);
                    continue;
                }
                if (eventDefinition instanceof SignalEventDefinition) {
                    this.handleSignalEventDefinition(bpmnModel, process, event, eventDefinition, errors);
                    continue;
                }
                if (eventDefinition instanceof TimerEventDefinition) {
                    this.handleTimerEventDefinition(process, event, eventDefinition, errors);
                    continue;
                }
                if (!(eventDefinition instanceof CompensateEventDefinition)) continue;
                this.handleCompensationEventDefinition(bpmnModel, process, event, eventDefinition, errors);
            }
        }
    }

    protected void handleMessageEventDefinition(BpmnModel bpmnModel, Process process, Event event, EventDefinition eventDefinition, List<ValidationError> errors) {
        MessageEventDefinition messageEventDefinition = (MessageEventDefinition)eventDefinition;
        if (StringUtils.isEmpty((CharSequence)messageEventDefinition.getMessageRef())) {
            if (StringUtils.isEmpty((CharSequence)messageEventDefinition.getMessageExpression())) {
                this.addError(errors, "flowable-message-event-missing-message-ref", process, (FlowElement)event, (BaseElement)messageEventDefinition, "attribute 'messageRef' or 'messageExpression' is required");
            }
        } else if (!bpmnModel.containsMessageId(messageEventDefinition.getMessageRef())) {
            this.addError(errors, "flowable-message-event-invalid-message-ref", process, (FlowElement)event, (BaseElement)messageEventDefinition, "Invalid 'messageRef': no message with that id can be found in the model");
        }
    }

    protected void handleSignalEventDefinition(BpmnModel bpmnModel, Process process, Event event, EventDefinition eventDefinition, List<ValidationError> errors) {
        SignalEventDefinition signalEventDefinition = (SignalEventDefinition)eventDefinition;
        if (StringUtils.isEmpty((CharSequence)signalEventDefinition.getSignalRef())) {
            if (StringUtils.isEmpty((CharSequence)signalEventDefinition.getSignalExpression())) {
                this.addError(errors, "flowable-signal-event-missing-signal-ref", process, (FlowElement)event, (BaseElement)signalEventDefinition, "signalEventDefinition does not have a 'signalRef' or a 'signalExpression'");
            }
        } else if (!bpmnModel.containsSignalId(signalEventDefinition.getSignalRef())) {
            this.addError(errors, "flowable-signal-event-invalid-signal-ref", process, (FlowElement)event, (BaseElement)signalEventDefinition, "Invalid 'signalRef': no signal with that id can be found in the model");
        }
    }

    protected void handleTimerEventDefinition(Process process, Event event, EventDefinition eventDefinition, List<ValidationError> errors) {
        TimerEventDefinition timerEventDefinition = (TimerEventDefinition)eventDefinition;
        if (StringUtils.isEmpty((CharSequence)timerEventDefinition.getTimeDate()) && StringUtils.isEmpty((CharSequence)timerEventDefinition.getTimeCycle()) && StringUtils.isEmpty((CharSequence)timerEventDefinition.getTimeDuration())) {
            this.addError(errors, "flowable-event-timer-missing-configuration", process, (FlowElement)event, (BaseElement)timerEventDefinition, "Timer needs configuration (either timeDate, timeCycle or timeDuration is needed)");
        }
    }

    protected void handleCompensationEventDefinition(BpmnModel bpmnModel, Process process, Event event, EventDefinition eventDefinition, List<ValidationError> errors) {
        CompensateEventDefinition compensateEventDefinition = (CompensateEventDefinition)eventDefinition;
        if (StringUtils.isNotEmpty((CharSequence)compensateEventDefinition.getActivityRef()) && process.getFlowElement(compensateEventDefinition.getActivityRef(), true) == null) {
            this.addError(errors, "flowable-compensate-event-invalid-activity-ref", process, (FlowElement)event, (BaseElement)compensateEventDefinition, "Invalid attribute value for 'activityRef': no activity with the given id");
        }
    }
}

