/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.identitylink.service.impl.persistence.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.flowable.common.engine.impl.AbstractServiceConfiguration;
import org.flowable.common.engine.impl.persistence.entity.AbstractServiceEngineEntityManager;
import org.flowable.common.engine.impl.persistence.entity.Entity;
import org.flowable.common.engine.impl.persistence.entity.data.DataManager;
import org.flowable.identitylink.api.history.HistoricIdentityLink;
import org.flowable.identitylink.service.IdentityLinkEventHandler;
import org.flowable.identitylink.service.IdentityLinkServiceConfiguration;
import org.flowable.identitylink.service.impl.persistence.entity.IdentityLinkEntity;
import org.flowable.identitylink.service.impl.persistence.entity.IdentityLinkEntityManager;
import org.flowable.identitylink.service.impl.persistence.entity.data.IdentityLinkDataManager;

public class IdentityLinkEntityManagerImpl
extends AbstractServiceEngineEntityManager<IdentityLinkServiceConfiguration, IdentityLinkEntity, IdentityLinkDataManager>
implements IdentityLinkEntityManager {
    public IdentityLinkEntityManagerImpl(IdentityLinkServiceConfiguration identityLinkServiceConfiguration, IdentityLinkDataManager identityLinkDataManager) {
        super((AbstractServiceConfiguration)identityLinkServiceConfiguration, identityLinkServiceConfiguration.getEngineName(), (DataManager)identityLinkDataManager);
    }

    @Override
    public IdentityLinkEntity createIdentityLinkFromHistoricIdentityLink(HistoricIdentityLink historicIdentityLink) {
        return ((IdentityLinkDataManager)this.dataManager).createIdentityLinkFromHistoricIdentityLink(historicIdentityLink);
    }

    public void insert(IdentityLinkEntity entity, boolean fireCreateEvent) {
        super.insert((Entity)entity, fireCreateEvent);
        IdentityLinkEventHandler identityLinkEventHandler = this.getIdentityLinkEventHandler();
        if (identityLinkEventHandler != null) {
            identityLinkEventHandler.handleIdentityLinkAddition(entity);
        }
    }

    public void delete(IdentityLinkEntity entity, boolean fireDeleteEvent) {
        super.delete((Entity)entity, fireDeleteEvent);
        IdentityLinkEventHandler identityLinkEventHandler = this.getIdentityLinkEventHandler();
        if (identityLinkEventHandler != null) {
            this.getIdentityLinkEventHandler().handleIdentityLinkDeletion(entity);
        }
    }

    @Override
    public List<IdentityLinkEntity> findIdentityLinksByTaskId(String taskId) {
        return ((IdentityLinkDataManager)this.dataManager).findIdentityLinksByTaskId(taskId);
    }

    @Override
    public List<IdentityLinkEntity> findIdentityLinksByProcessInstanceId(String processInstanceId) {
        return ((IdentityLinkDataManager)this.dataManager).findIdentityLinksByProcessInstanceId(processInstanceId);
    }

    @Override
    public List<IdentityLinkEntity> findIdentityLinksByScopeIdAndType(String scopeId, String scopeType) {
        return ((IdentityLinkDataManager)this.dataManager).findIdentityLinksByScopeIdAndType(scopeId, scopeType);
    }

    @Override
    public List<IdentityLinkEntity> findIdentityLinksBySubScopeIdAndType(String subScopeId, String scopeType) {
        return ((IdentityLinkDataManager)this.dataManager).findIdentityLinksBySubScopeIdAndType(subScopeId, scopeType);
    }

    @Override
    public List<IdentityLinkEntity> findIdentityLinksByProcessDefinitionId(String processDefinitionId) {
        return ((IdentityLinkDataManager)this.dataManager).findIdentityLinksByProcessDefinitionId(processDefinitionId);
    }

    @Override
    public List<IdentityLinkEntity> findIdentityLinksByScopeDefinitionIdAndType(String scopeDefinitionId, String scopeType) {
        return ((IdentityLinkDataManager)this.dataManager).findIdentityLinksByScopeDefinitionIdAndType(scopeDefinitionId, scopeType);
    }

    @Override
    public List<IdentityLinkEntity> findIdentityLinkByTaskUserGroupAndType(String taskId, String userId, String groupId, String type) {
        return ((IdentityLinkDataManager)this.dataManager).findIdentityLinkByTaskUserGroupAndType(taskId, userId, groupId, type);
    }

    @Override
    public List<IdentityLinkEntity> findIdentityLinkByProcessInstanceUserGroupAndType(String processInstanceId, String userId, String groupId, String type) {
        return ((IdentityLinkDataManager)this.dataManager).findIdentityLinkByProcessInstanceUserGroupAndType(processInstanceId, userId, groupId, type);
    }

    @Override
    public List<IdentityLinkEntity> findIdentityLinkByProcessDefinitionUserAndGroup(String processDefinitionId, String userId, String groupId) {
        return ((IdentityLinkDataManager)this.dataManager).findIdentityLinkByProcessDefinitionUserAndGroup(processDefinitionId, userId, groupId);
    }

    @Override
    public List<IdentityLinkEntity> findIdentityLinkByScopeIdScopeTypeUserGroupAndType(String scopeId, String scopeType, String userId, String groupId, String type) {
        return ((IdentityLinkDataManager)this.dataManager).findIdentityLinkByScopeIdScopeTypeUserGroupAndType(scopeId, scopeType, userId, groupId, type);
    }

    @Override
    public List<IdentityLinkEntity> findIdentityLinkByScopeDefinitionScopeTypeUserAndGroup(String scopeDefinitionId, String scopeType, String userId, String groupId) {
        return ((IdentityLinkDataManager)this.dataManager).findIdentityLinkByScopeDefinitionScopeTypeUserAndGroup(scopeDefinitionId, scopeType, userId, groupId);
    }

    @Override
    public IdentityLinkEntity addProcessInstanceIdentityLink(String processInstanceId, String userId, String groupId, String type) {
        IdentityLinkEntity identityLinkEntity = (IdentityLinkEntity)((IdentityLinkDataManager)this.dataManager).create();
        identityLinkEntity.setProcessInstanceId(processInstanceId);
        identityLinkEntity.setUserId(userId);
        identityLinkEntity.setGroupId(groupId);
        identityLinkEntity.setType(type);
        this.insert(identityLinkEntity);
        return identityLinkEntity;
    }

    @Override
    public IdentityLinkEntity addScopeIdentityLink(String scopeDefinitionId, String scopeId, String scopeType, String userId, String groupId, String type) {
        IdentityLinkEntity identityLinkEntity = (IdentityLinkEntity)((IdentityLinkDataManager)this.dataManager).create();
        identityLinkEntity.setScopeDefinitionId(scopeDefinitionId);
        identityLinkEntity.setScopeId(scopeId);
        identityLinkEntity.setScopeType(scopeType);
        identityLinkEntity.setUserId(userId);
        identityLinkEntity.setGroupId(groupId);
        identityLinkEntity.setType(type);
        this.insert(identityLinkEntity);
        return identityLinkEntity;
    }

    @Override
    public IdentityLinkEntity addSubScopeIdentityLink(String scopeDefinitionId, String scopeId, String subScopeId, String scopeType, String userId, String groupId, String type) {
        IdentityLinkEntity identityLinkEntity = (IdentityLinkEntity)((IdentityLinkDataManager)this.dataManager).create();
        identityLinkEntity.setScopeDefinitionId(scopeDefinitionId);
        identityLinkEntity.setScopeId(scopeId);
        identityLinkEntity.setSubScopeId(subScopeId);
        identityLinkEntity.setScopeType(scopeType);
        identityLinkEntity.setUserId(userId);
        identityLinkEntity.setGroupId(groupId);
        identityLinkEntity.setType(type);
        this.insert(identityLinkEntity);
        return identityLinkEntity;
    }

    @Override
    public IdentityLinkEntity addTaskIdentityLink(String taskId, String userId, String groupId, String type) {
        IdentityLinkEntity identityLinkEntity = (IdentityLinkEntity)((IdentityLinkDataManager)this.dataManager).create();
        identityLinkEntity.setTaskId(taskId);
        identityLinkEntity.setUserId(userId);
        identityLinkEntity.setGroupId(groupId);
        identityLinkEntity.setType(type);
        this.insert(identityLinkEntity);
        return identityLinkEntity;
    }

    @Override
    public IdentityLinkEntity addProcessDefinitionIdentityLink(String processDefinitionId, String userId, String groupId) {
        IdentityLinkEntity identityLinkEntity = (IdentityLinkEntity)((IdentityLinkDataManager)this.dataManager).create();
        identityLinkEntity.setProcessDefId(processDefinitionId);
        identityLinkEntity.setUserId(userId);
        identityLinkEntity.setGroupId(groupId);
        identityLinkEntity.setType("candidate");
        this.insert(identityLinkEntity);
        return identityLinkEntity;
    }

    @Override
    public IdentityLinkEntity addScopeDefinitionIdentityLink(String scopeDefinitionId, String scopeType, String userId, String groupId) {
        IdentityLinkEntity identityLinkEntity = (IdentityLinkEntity)((IdentityLinkDataManager)this.dataManager).create();
        identityLinkEntity.setScopeDefinitionId(scopeDefinitionId);
        identityLinkEntity.setScopeType(scopeType);
        identityLinkEntity.setUserId(userId);
        identityLinkEntity.setGroupId(groupId);
        identityLinkEntity.setType("candidate");
        this.insert(identityLinkEntity);
        return identityLinkEntity;
    }

    @Override
    public IdentityLinkEntity addCandidateUser(String taskId, String userId) {
        return this.addTaskIdentityLink(taskId, userId, null, "candidate");
    }

    @Override
    public List<IdentityLinkEntity> addCandidateUsers(String taskId, Collection<String> candidateUsers) {
        ArrayList<IdentityLinkEntity> identityLinks = new ArrayList<IdentityLinkEntity>();
        for (String candidateUser : candidateUsers) {
            identityLinks.add(this.addCandidateUser(taskId, candidateUser));
        }
        return identityLinks;
    }

    @Override
    public IdentityLinkEntity addCandidateGroup(String taskId, String groupId) {
        return this.addTaskIdentityLink(taskId, null, groupId, "candidate");
    }

    @Override
    public List<IdentityLinkEntity> addCandidateGroups(String taskId, Collection<String> candidateGroups) {
        ArrayList<IdentityLinkEntity> identityLinks = new ArrayList<IdentityLinkEntity>();
        for (String candidateGroup : candidateGroups) {
            identityLinks.add(this.addCandidateGroup(taskId, candidateGroup));
        }
        return identityLinks;
    }

    @Override
    public List<IdentityLinkEntity> deleteProcessInstanceIdentityLink(String processInstanceId, String userId, String groupId, String type) {
        List<IdentityLinkEntity> identityLinks = this.findIdentityLinkByProcessInstanceUserGroupAndType(processInstanceId, userId, groupId, type);
        for (IdentityLinkEntity identityLink : identityLinks) {
            this.delete(identityLink);
        }
        return identityLinks;
    }

    @Override
    public List<IdentityLinkEntity> deleteScopeIdentityLink(String scopeId, String scopeType, String userId, String groupId, String type) {
        List<IdentityLinkEntity> identityLinks = this.findIdentityLinkByScopeIdScopeTypeUserGroupAndType(scopeId, scopeType, userId, groupId, type);
        for (IdentityLinkEntity identityLink : identityLinks) {
            this.deleteIdentityLink(identityLink);
        }
        return identityLinks;
    }

    @Override
    public List<IdentityLinkEntity> deleteTaskIdentityLink(String taskId, List<IdentityLinkEntity> currentIdentityLinks, String userId, String groupId, String type) {
        List<IdentityLinkEntity> identityLinks = this.findIdentityLinkByTaskUserGroupAndType(taskId, userId, groupId, type);
        ArrayList<IdentityLinkEntity> removedIdentityLinkEntities = new ArrayList<IdentityLinkEntity>();
        for (IdentityLinkEntity identityLink : identityLinks) {
            this.delete(identityLink);
            removedIdentityLinkEntities.add(identityLink);
        }
        if (currentIdentityLinks != null) {
            for (IdentityLinkEntity identityLinkEntity : currentIdentityLinks) {
                if (!type.equals(identityLinkEntity.getType()) || this.contains(removedIdentityLinkEntities, identityLinkEntity.getId()) || (userId == null || !userId.equals(identityLinkEntity.getUserId())) && (groupId == null || !groupId.equals(identityLinkEntity.getGroupId()))) continue;
                this.delete(identityLinkEntity);
                removedIdentityLinkEntities.add(identityLinkEntity);
            }
        }
        return removedIdentityLinkEntities;
    }

    protected boolean contains(List<IdentityLinkEntity> identityLinkEntities, String identityLinkId) {
        return identityLinkEntities.stream().anyMatch(identityLinkEntity -> Objects.equals(identityLinkId, identityLinkEntity.getId()));
    }

    @Override
    public List<IdentityLinkEntity> deleteProcessDefinitionIdentityLink(String processDefinitionId, String userId, String groupId) {
        List<IdentityLinkEntity> identityLinks = this.findIdentityLinkByProcessDefinitionUserAndGroup(processDefinitionId, userId, groupId);
        for (IdentityLinkEntity identityLink : identityLinks) {
            this.delete(identityLink);
        }
        return identityLinks;
    }

    @Override
    public List<IdentityLinkEntity> deleteScopeDefinitionIdentityLink(String scopeDefinitionId, String scopeType, String userId, String groupId) {
        List<IdentityLinkEntity> identityLinks = this.findIdentityLinkByScopeDefinitionScopeTypeUserAndGroup(scopeDefinitionId, scopeType, userId, groupId);
        for (IdentityLinkEntity identityLink : identityLinks) {
            this.deleteIdentityLink(identityLink);
        }
        return identityLinks;
    }

    public void deleteIdentityLink(IdentityLinkEntity identityLink) {
        this.delete(identityLink);
    }

    @Override
    public void deleteIdentityLinksByTaskId(String taskId) {
        ((IdentityLinkDataManager)this.dataManager).deleteIdentityLinksByTaskId(taskId);
    }

    @Override
    public void deleteIdentityLinksByProcDef(String processDefId) {
        ((IdentityLinkDataManager)this.dataManager).deleteIdentityLinksByProcDef(processDefId);
    }

    @Override
    public void deleteIdentityLinksByProcessInstanceId(String processInstanceId) {
        ((IdentityLinkDataManager)this.dataManager).deleteIdentityLinksByProcessInstanceId(processInstanceId);
    }

    @Override
    public void deleteIdentityLinksByScopeIdAndScopeType(String scopeId, String scopeType) {
        ((IdentityLinkDataManager)this.dataManager).deleteIdentityLinksByScopeIdAndScopeType(scopeId, scopeType);
    }

    @Override
    public void deleteIdentityLinksByScopeDefinitionIdAndScopeType(String scopeDefinitionId, String scopeType) {
        ((IdentityLinkDataManager)this.dataManager).deleteIdentityLinksByScopeDefinitionIdAndScopeType(scopeDefinitionId, scopeType);
    }

    @Override
    public void bulkDeleteIdentityLinksForScopeIdsAndScopeType(Collection<String> scopeIds, String scopeType) {
        ((IdentityLinkDataManager)this.dataManager).bulkDeleteIdentityLinksForScopeIdsAndScopeType(scopeIds, scopeType);
    }

    protected IdentityLinkEventHandler getIdentityLinkEventHandler() {
        return ((IdentityLinkServiceConfiguration)this.serviceConfiguration).getIdentityLinkEventHandler();
    }
}

