/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.rest.service.api.repository;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.servlet.http.HttpServletResponse;
import org.flowable.dmn.rest.service.api.repository.BaseDmnDeploymentResourceDataResource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Deployment"}, description="Manage Decision Table Deployments", authorizations={@Authorization(value="basicAuth")})
public class DmnDeploymentResourceDataResource
extends BaseDmnDeploymentResourceDataResource {
    @ApiOperation(value="Get a decision table deployment resource content", tags={"Deployment"}, nickname="getDecisionTableDeploymentResource", notes="The response body will contain the binary resource-content for the requested resource. The response content-type will be the same as the type returned in the resources mimeType property. Also, a content-disposition header is set, allowing browsers to download the file instead of displaying it.")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates both deployment and resource have been found and the resource data has been returned."), @ApiResponse(code=404, message="Indicates the requested deployment was not found or there is no resource with the given id present in the deployment. The status-description contains additional information.")})
    @GetMapping(value={"/dmn-repository/deployments/{deploymentId}/resourcedata/{resourceName}"})
    @ResponseBody
    public byte[] getDmnDeploymentResource(@ApiParam(name="deploymentId") @PathVariable(value="deploymentId") String deploymentId, @PathVariable(value="resourceName") String resourceName, HttpServletResponse response) {
        return this.getDmnDeploymentResourceData(deploymentId, resourceName, response);
    }
}

