/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.rest.service.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.rest.variable.BooleanRestVariableConverter;
import org.flowable.common.rest.variable.DateRestVariableConverter;
import org.flowable.common.rest.variable.DoubleRestVariableConverter;
import org.flowable.common.rest.variable.EngineRestVariable;
import org.flowable.common.rest.variable.InstantRestVariableConverter;
import org.flowable.common.rest.variable.IntegerRestVariableConverter;
import org.flowable.common.rest.variable.LocalDateRestVariableConverter;
import org.flowable.common.rest.variable.LocalDateTimeRestVariableConverter;
import org.flowable.common.rest.variable.LongRestVariableConverter;
import org.flowable.common.rest.variable.RestVariableConverter;
import org.flowable.common.rest.variable.ShortRestVariableConverter;
import org.flowable.common.rest.variable.StringRestVariableConverter;
import org.flowable.dmn.api.DmnDecisionTable;
import org.flowable.dmn.api.DmnDeployment;
import org.flowable.dmn.api.DmnHistoricDecisionExecution;
import org.flowable.dmn.rest.service.api.DmnRestUrlBuilder;
import org.flowable.dmn.rest.service.api.DmnRestUrls;
import org.flowable.dmn.rest.service.api.decision.DmnRuleServiceResponse;
import org.flowable.dmn.rest.service.api.decision.DmnRuleServiceSingleResponse;
import org.flowable.dmn.rest.service.api.history.HistoricDecisionExecutionResponse;
import org.flowable.dmn.rest.service.api.repository.DecisionTableResponse;
import org.flowable.dmn.rest.service.api.repository.DmnDeploymentResponse;

public class DmnRestResponseFactory {
    public static final String BYTE_ARRAY_VARIABLE_TYPE = "binary";
    public static final String SERIALIZABLE_VARIABLE_TYPE = "serializable";
    protected List<RestVariableConverter> variableConverters = new ArrayList<RestVariableConverter>();

    public DmnRestResponseFactory() {
        this.initializeVariableConverters();
    }

    public DecisionTableResponse createDecisionTableResponse(DmnDecisionTable decisionTable) {
        return this.createDecisionTableResponse(decisionTable, this.createUrlBuilder());
    }

    public DecisionTableResponse createDecisionTableResponse(DmnDecisionTable decisionTable, DmnRestUrlBuilder urlBuilder) {
        DecisionTableResponse response = new DecisionTableResponse(decisionTable);
        response.setUrl(urlBuilder.buildUrl(DmnRestUrls.URL_DECISION_TABLE, decisionTable.getId()));
        return response;
    }

    public List<DecisionTableResponse> createDecisionTableResponseList(List<DmnDecisionTable> decisionTables) {
        DmnRestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<DecisionTableResponse> responseList = new ArrayList<DecisionTableResponse>();
        for (DmnDecisionTable instance : decisionTables) {
            responseList.add(this.createDecisionTableResponse(instance, urlBuilder));
        }
        return responseList;
    }

    public List<DmnDeploymentResponse> createDmnDeploymentResponseList(List<DmnDeployment> deployments) {
        DmnRestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<DmnDeploymentResponse> responseList = new ArrayList<DmnDeploymentResponse>();
        for (DmnDeployment instance : deployments) {
            responseList.add(this.createDmnDeploymentResponse(instance, urlBuilder));
        }
        return responseList;
    }

    public DmnDeploymentResponse createDmnDeploymentResponse(DmnDeployment deployment) {
        return this.createDmnDeploymentResponse(deployment, this.createUrlBuilder());
    }

    public DmnDeploymentResponse createDmnDeploymentResponse(DmnDeployment deployment, DmnRestUrlBuilder urlBuilder) {
        return new DmnDeploymentResponse(deployment, urlBuilder.buildUrl(DmnRestUrls.URL_DEPLOYMENT, deployment.getId()));
    }

    public DmnRuleServiceResponse createDmnRuleServiceResponse(List<Map<String, Object>> executionResults) {
        return this.createDmnRuleServiceResponse(executionResults, this.createUrlBuilder());
    }

    public DmnRuleServiceSingleResponse createDmnRuleServiceResponse(Map<String, Object> executionResult) {
        return this.createDmnRuleServiceResponse(executionResult, this.createUrlBuilder());
    }

    public DmnRuleServiceResponse createDmnRuleServiceResponse(List<Map<String, Object>> executionResults, DmnRestUrlBuilder urlBuilder) {
        DmnRuleServiceResponse response = new DmnRuleServiceResponse();
        if (executionResults != null && !executionResults.isEmpty()) {
            for (Map<String, Object> executionResult : executionResults) {
                ArrayList<EngineRestVariable> ruleResults = new ArrayList<EngineRestVariable>();
                for (String name : executionResult.keySet()) {
                    ruleResults.add(this.createRestVariable(name, executionResult.get(name), false));
                }
                response.addResultVariables(ruleResults);
            }
        }
        response.setUrl(urlBuilder.buildUrl(DmnRestUrls.URL_RULE_SERVICE_EXECUTE, new Object[0]));
        return response;
    }

    public DmnRuleServiceSingleResponse createDmnRuleServiceResponse(Map<String, Object> executionResult, DmnRestUrlBuilder urlBuilder) {
        DmnRuleServiceSingleResponse response = new DmnRuleServiceSingleResponse();
        if (executionResult != null) {
            for (String name : executionResult.keySet()) {
                response.addResultVariable(this.createRestVariable(name, executionResult.get(name), false));
            }
        }
        response.setUrl(urlBuilder.buildUrl(DmnRestUrls.URL_RULE_SERVICE_EXECUTE, new Object[0]));
        return response;
    }

    public List<HistoricDecisionExecutionResponse> createHistoricDecisionExecutionResponseList(List<DmnHistoricDecisionExecution> historicDecisionExecutions) {
        DmnRestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<HistoricDecisionExecutionResponse> responseList = new ArrayList<HistoricDecisionExecutionResponse>();
        for (DmnHistoricDecisionExecution execution : historicDecisionExecutions) {
            responseList.add(this.createHistoryDecisionExecutionResponse(execution, urlBuilder));
        }
        return responseList;
    }

    public HistoricDecisionExecutionResponse createHistoryDecisionExecutionResponse(DmnHistoricDecisionExecution execution) {
        return this.createHistoryDecisionExecutionResponse(execution, this.createUrlBuilder());
    }

    public HistoricDecisionExecutionResponse createHistoryDecisionExecutionResponse(DmnHistoricDecisionExecution execution, DmnRestUrlBuilder urlBuilder) {
        HistoricDecisionExecutionResponse response = new HistoricDecisionExecutionResponse(execution);
        response.setUrl(urlBuilder.buildUrl(DmnRestUrls.URL_HISTORIC_DECISION_EXECUTION, execution.getId()));
        return response;
    }

    public Object getVariableValue(EngineRestVariable restVariable) {
        Object value = null;
        if (restVariable.getType() != null) {
            RestVariableConverter converter = null;
            for (RestVariableConverter conv : this.variableConverters) {
                if (!conv.getRestTypeName().equals(restVariable.getType())) continue;
                converter = conv;
                break;
            }
            if (converter == null) {
                throw new FlowableIllegalArgumentException("Variable '" + restVariable.getName() + "' has unsupported type: '" + restVariable.getType() + "'.");
            }
            value = converter.getVariableValue(restVariable);
        } else {
            value = restVariable.getValue();
        }
        return value;
    }

    public EngineRestVariable createRestVariable(String name, Object value, boolean includeBinaryValue) {
        return this.createRestVariable(name, value, includeBinaryValue, this.createUrlBuilder());
    }

    public EngineRestVariable createRestVariable(String name, Object value, boolean includeBinaryValue, DmnRestUrlBuilder urlBuilder) {
        RestVariableConverter converter = null;
        EngineRestVariable restVar = new EngineRestVariable();
        restVar.setName(name);
        if (value != null) {
            for (RestVariableConverter c : this.variableConverters) {
                if (!c.getVariableType().isAssignableFrom(value.getClass())) continue;
                converter = c;
                break;
            }
            if (converter != null) {
                converter.convertVariableValue(value, restVar);
                restVar.setType(converter.getRestTypeName());
            } else {
                if (value instanceof Byte[] || value instanceof byte[]) {
                    restVar.setType(BYTE_ARRAY_VARIABLE_TYPE);
                } else {
                    restVar.setType(SERIALIZABLE_VARIABLE_TYPE);
                }
                if (includeBinaryValue) {
                    restVar.setValue(value);
                }
            }
        }
        return restVar;
    }

    protected void initializeVariableConverters() {
        this.variableConverters.add((RestVariableConverter)new StringRestVariableConverter());
        this.variableConverters.add((RestVariableConverter)new IntegerRestVariableConverter());
        this.variableConverters.add((RestVariableConverter)new LongRestVariableConverter());
        this.variableConverters.add((RestVariableConverter)new ShortRestVariableConverter());
        this.variableConverters.add((RestVariableConverter)new DoubleRestVariableConverter());
        this.variableConverters.add((RestVariableConverter)new BooleanRestVariableConverter());
        this.variableConverters.add((RestVariableConverter)new DateRestVariableConverter());
        this.variableConverters.add((RestVariableConverter)new InstantRestVariableConverter());
        this.variableConverters.add((RestVariableConverter)new LocalDateRestVariableConverter());
        this.variableConverters.add((RestVariableConverter)new LocalDateTimeRestVariableConverter());
    }

    protected DmnRestUrlBuilder createUrlBuilder() {
        return DmnRestUrlBuilder.fromCurrentRequest();
    }
}

