/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.content.engine.impl.test;

import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractContentTestCase
extends TestCase {
    protected static final String EMPTY_LINE = "\n";
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractContentTestCase.class);
    protected boolean isEmptyLinesEnabled = true;

    public void assertTextPresent(String expected, String actual) {
        if (actual == null || !actual.contains(expected)) {
            throw new AssertionFailedError("expected presence of [" + expected + "], but was [" + actual + "]");
        }
    }

    public void assertTextPresentIgnoreCase(String expected, String actual) {
        this.assertTextPresent(expected.toLowerCase(), actual.toLowerCase());
    }

    protected void runTest() throws Throwable {
        if (LOGGER.isDebugEnabled()) {
            if (this.isEmptyLinesEnabled) {
                LOGGER.debug(EMPTY_LINE);
            }
            LOGGER.debug("#### START {}.{} ###########################################################", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)this.getName());
        }
        try {
            super.runTest();
        }
        catch (AssertionFailedError e) {
            LOGGER.error(EMPTY_LINE);
            LOGGER.error("ASSERTION FAILED: {}", (Object)e, (Object)e);
            throw e;
        }
        catch (Throwable e) {
            LOGGER.error(EMPTY_LINE);
            LOGGER.error("EXCEPTION: {}", (Object)e, (Object)e);
            throw e;
        }
        finally {
            LOGGER.debug("#### END {}.{} #############################################################", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)this.getName());
        }
    }
}

