/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.content.engine.impl.cmd;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.content.engine.impl.util.CommandContextUtil;

public class DeleteContentItemsCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processInstanceId;
    protected String taskId;
    protected String caseId;

    public DeleteContentItemsCmd(String processInstanceId, String taskId, String caseId) {
        this.processInstanceId = processInstanceId;
        this.taskId = taskId;
        this.caseId = caseId;
    }

    public Void execute(CommandContext commandContext) {
        if (this.processInstanceId == null && this.taskId == null && this.caseId == null) {
            throw new FlowableIllegalArgumentException("taskId, processInstanceId and caseId are null");
        }
        if (this.processInstanceId != null) {
            CommandContextUtil.getContentItemEntityManager().deleteContentItemsByProcessInstanceId(this.processInstanceId);
        } else if (StringUtils.isNotEmpty((CharSequence)this.caseId)) {
            CommandContextUtil.getContentItemEntityManager().deleteContentItemsByScopeIdAndScopeType(this.caseId, "cmmn");
        } else {
            CommandContextUtil.getContentItemEntityManager().deleteContentItemsByTaskId(this.taskId);
        }
        return null;
    }
}

