/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.rest.exception;

import jakarta.servlet.http.HttpServletRequest;
import java.util.UUID;
import org.flowable.common.engine.api.FlowableForbiddenException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableIllegalStateException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.api.FlowableTaskAlreadyClaimedException;
import org.flowable.common.rest.exception.ErrorInfo;
import org.flowable.common.rest.exception.FlowableConflictException;
import org.flowable.common.rest.exception.FlowableContentNotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice
public class BaseExceptionHandlerAdvice {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected boolean sendFullErrorException = true;

    @ResponseStatus(value=HttpStatus.UNSUPPORTED_MEDIA_TYPE)
    @ExceptionHandler(value={FlowableContentNotSupportedException.class})
    @ResponseBody
    public ErrorInfo handleNotSupported(FlowableContentNotSupportedException e, HttpServletRequest request) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Content is not supported. Message: {}, Request: {} {}", new Object[]{e.getMessage(), request.getMethod(), request.getRequestURI()});
        }
        return new ErrorInfo("Content is not supported", (Exception)((Object)e));
    }

    @ResponseStatus(value=HttpStatus.CONFLICT)
    @ExceptionHandler(value={FlowableConflictException.class})
    @ResponseBody
    public ErrorInfo handleConflict(FlowableConflictException e, HttpServletRequest request) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Conflict. Message: {}, Request: {} {}", new Object[]{e.getMessage(), request.getMethod(), request.getRequestURI()});
        }
        return new ErrorInfo("Conflict", (Exception)((Object)e));
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ExceptionHandler(value={FlowableObjectNotFoundException.class})
    @ResponseBody
    public ErrorInfo handleNotFound(FlowableObjectNotFoundException e, HttpServletRequest request) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Not found. Message: {}, Request: {} {}", new Object[]{e.getMessage(), request.getMethod(), request.getRequestURI()});
        }
        return new ErrorInfo("Not found", (Exception)e);
    }

    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ExceptionHandler(value={FlowableForbiddenException.class})
    @ResponseBody
    public ErrorInfo handleForbidden(FlowableForbiddenException e, HttpServletRequest request) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Forbidden. Message: {}, Request: {} {}", new Object[]{e.getMessage(), request.getMethod(), request.getRequestURI()});
        }
        return new ErrorInfo("Forbidden", (Exception)e);
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={FlowableIllegalArgumentException.class})
    @ResponseBody
    public ErrorInfo handleIllegalArgument(FlowableIllegalArgumentException e, HttpServletRequest request) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Illegal argument. Message: {}, Request: {} {}", new Object[]{e.getMessage(), request.getMethod(), request.getRequestURI()});
        }
        return new ErrorInfo("Bad request", (Exception)e);
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={FlowableIllegalStateException.class})
    @ResponseBody
    public ErrorInfo handleIllegalState(FlowableIllegalStateException e, HttpServletRequest request) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Illegal state. Message: {}, Request: {} {}", new Object[]{e.getMessage(), request.getMethod(), request.getRequestURI()});
        }
        return new ErrorInfo("Bad request", (Exception)e);
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={HttpMessageConversionException.class})
    @ResponseBody
    public ErrorInfo handleBadMessageConversion(HttpMessageConversionException e, HttpServletRequest request) {
        if (this.sendFullErrorException) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Invalid message conversion. Message: {}, Request: {} {}", new Object[]{e.getMessage(), request.getMethod(), request.getRequestURI()});
            }
            return new ErrorInfo("Bad request", (Exception)e);
        }
        String errorIdentifier = UUID.randomUUID().toString();
        this.logger.warn("Invalid Message conversion exception. Error ID: {}. Message: {}, Request: {} {}", new Object[]{errorIdentifier, e.getMessage(), request.getMethod(), request.getRequestURI()});
        ErrorInfo errorInfo = new ErrorInfo("Bad request", null);
        errorInfo.setException("Invalid HTTP message. Error ID: " + errorIdentifier);
        return errorInfo;
    }

    @ResponseStatus(value=HttpStatus.CONFLICT)
    @ExceptionHandler(value={FlowableTaskAlreadyClaimedException.class})
    @ResponseBody
    public ErrorInfo handleTaskAlreadyClaimed(FlowableTaskAlreadyClaimedException e, HttpServletRequest request) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Task was already claimed. Message: {}, Request: {} {}", new Object[]{e.getMessage(), request.getMethod(), request.getRequestURI()});
        }
        return new ErrorInfo("Task was already claimed", (Exception)e);
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public ErrorInfo handleOtherException(Exception e, HttpServletRequest request) {
        if (this.sendFullErrorException) {
            this.logger.error("Unhandled exception. Request: {} {}", new Object[]{request.getMethod(), request.getRequestURI(), e});
            return new ErrorInfo("Internal server error", e);
        }
        String errorIdentifier = UUID.randomUUID().toString();
        this.logger.error("Unhandled exception. Error ID: {}. Request: {} {}", new Object[]{errorIdentifier, request.getMethod(), request.getRequestURI(), e});
        ErrorInfo errorInfo = new ErrorInfo("Internal server error", e);
        errorInfo.setException("Error with ID: " + errorIdentifier);
        return errorInfo;
    }

    public boolean isSendFullErrorException() {
        return this.sendFullErrorException;
    }

    public void setSendFullErrorException(boolean sendFullErrorException) {
        this.sendFullErrorException = sendFullErrorException;
    }
}

