/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.behavior.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.delegate.DelegatePlanItemInstance;
import org.flowable.cmmn.engine.impl.behavior.PlanItemActivityBehavior;
import org.flowable.cmmn.engine.impl.behavior.impl.TaskActivityBehavior;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.task.TaskHelper;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.HumanTask;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.identitylink.service.impl.persistence.entity.IdentityLinkEntity;
import org.flowable.task.service.TaskService;
import org.flowable.task.service.impl.persistence.CountingTaskEntity;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;

public class HumanTaskActivityBehavior
extends TaskActivityBehavior
implements PlanItemActivityBehavior {
    protected HumanTask humanTask;

    public HumanTaskActivityBehavior(HumanTask humanTask) {
        super(humanTask.isBlocking(), humanTask.getBlockingExpression());
        this.humanTask = humanTask;
    }

    @Override
    public void execute(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        if (this.evaluateIsBlocking(planItemInstanceEntity)) {
            TaskService taskService = CommandContextUtil.getTaskService(commandContext);
            ExpressionManager expressionManager = CommandContextUtil.getExpressionManager(commandContext);
            TaskEntity taskEntity = taskService.createTask();
            taskEntity.setScopeId(planItemInstanceEntity.getCaseInstanceId());
            taskEntity.setSubScopeId(planItemInstanceEntity.getId());
            taskEntity.setScopeDefinitionId(planItemInstanceEntity.getCaseDefinitionId());
            taskEntity.setScopeType("cmmn");
            taskEntity.setTenantId(planItemInstanceEntity.getTenantId());
            taskEntity.setTaskDefinitionKey(this.humanTask.getId());
            this.handleTaskName(planItemInstanceEntity, expressionManager, taskEntity);
            this.handleTaskDescription(planItemInstanceEntity, expressionManager, taskEntity);
            this.handleAssignee(planItemInstanceEntity, taskService, expressionManager, taskEntity);
            this.handleOwner(planItemInstanceEntity, taskService, expressionManager, taskEntity);
            this.handlePriority(planItemInstanceEntity, expressionManager, taskEntity);
            this.handleFormKey(planItemInstanceEntity, expressionManager, taskEntity);
            this.handleDueDate(commandContext, planItemInstanceEntity, expressionManager, taskEntity);
            this.handleCategory(planItemInstanceEntity, expressionManager, taskEntity);
            TaskHelper.insertTask(taskEntity, true);
            this.handleCandidateUsers(commandContext, planItemInstanceEntity, expressionManager, taskEntity);
            this.handleCandidateGroups(commandContext, planItemInstanceEntity, expressionManager, taskEntity);
            CommandContextUtil.getCmmnHistoryManager(commandContext).recordTaskCreated(taskEntity);
        } else {
            CommandContextUtil.getAgenda(commandContext).planCompletePlanItemInstanceOperation(planItemInstanceEntity);
        }
    }

    protected void handleTaskName(PlanItemInstanceEntity planItemInstanceEntity, ExpressionManager expressionManager, TaskEntity taskEntity) {
        Object name;
        if (StringUtils.isNotEmpty((CharSequence)this.humanTask.getName()) && (name = expressionManager.createExpression(this.humanTask.getName()).getValue((VariableContainer)planItemInstanceEntity)) != null) {
            if (name instanceof String) {
                taskEntity.setName((String)name);
            } else {
                throw new FlowableIllegalArgumentException("name expression does not resolve to a string: " + this.humanTask.getName());
            }
        }
    }

    protected void handleTaskDescription(PlanItemInstanceEntity planItemInstanceEntity, ExpressionManager expressionManager, TaskEntity taskEntity) {
        Object description;
        if (StringUtils.isNotEmpty((CharSequence)this.humanTask.getDocumentation()) && (description = expressionManager.createExpression(this.humanTask.getDocumentation()).getValue((VariableContainer)planItemInstanceEntity)) != null) {
            if (description instanceof String) {
                taskEntity.setDescription((String)description);
            } else {
                throw new FlowableIllegalArgumentException("documentation expression does not resolve to a string: " + this.humanTask.getDocumentation());
            }
        }
    }

    protected void handleAssignee(PlanItemInstanceEntity planItemInstanceEntity, TaskService taskService, ExpressionManager expressionManager, TaskEntity taskEntity) {
        if (StringUtils.isNotEmpty((CharSequence)this.humanTask.getAssignee())) {
            Object assigneeExpressionValue = expressionManager.createExpression(this.humanTask.getAssignee()).getValue((VariableContainer)planItemInstanceEntity);
            String assigneeValue = null;
            if (assigneeExpressionValue != null) {
                assigneeValue = assigneeExpressionValue.toString();
            }
            taskService.changeTaskAssignee(taskEntity, assigneeValue);
        }
    }

    protected void handleOwner(PlanItemInstanceEntity planItemInstanceEntity, TaskService taskService, ExpressionManager expressionManager, TaskEntity taskEntity) {
        if (StringUtils.isNotEmpty((CharSequence)this.humanTask.getOwner())) {
            Object ownerExpressionValue = expressionManager.createExpression(this.humanTask.getOwner()).getValue((VariableContainer)planItemInstanceEntity);
            String ownerValue = null;
            if (ownerExpressionValue != null) {
                ownerValue = ownerExpressionValue.toString();
            }
            taskService.changeTaskOwner(taskEntity, ownerValue);
        }
    }

    protected void handlePriority(PlanItemInstanceEntity planItemInstanceEntity, ExpressionManager expressionManager, TaskEntity taskEntity) {
        Object priority;
        if (StringUtils.isNotEmpty((CharSequence)this.humanTask.getPriority()) && (priority = expressionManager.createExpression(this.humanTask.getPriority()).getValue((VariableContainer)planItemInstanceEntity)) != null) {
            if (priority instanceof String) {
                try {
                    taskEntity.setPriority(Integer.valueOf((String)priority).intValue());
                }
                catch (NumberFormatException e) {
                    throw new FlowableIllegalArgumentException("Priority does not resolve to a number: " + this.humanTask.getPriority(), (Throwable)e);
                }
            } else if (priority instanceof Number) {
                taskEntity.setPriority(((Number)priority).intValue());
            } else {
                throw new FlowableIllegalArgumentException("Priority expression does not resolve to a number: " + this.humanTask.getPriority());
            }
        }
    }

    protected void handleFormKey(PlanItemInstanceEntity planItemInstanceEntity, ExpressionManager expressionManager, TaskEntity taskEntity) {
        Object formKey;
        if (StringUtils.isNotEmpty((CharSequence)this.humanTask.getFormKey()) && (formKey = expressionManager.createExpression(this.humanTask.getFormKey()).getValue((VariableContainer)planItemInstanceEntity)) != null) {
            if (formKey instanceof String) {
                taskEntity.setFormKey((String)formKey);
            } else {
                throw new FlowableIllegalArgumentException("FormKey expression does not resolve to a string: " + this.humanTask.getFormKey());
            }
        }
    }

    protected void handleDueDate(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity, ExpressionManager expressionManager, TaskEntity taskEntity) {
        Object dueDate;
        if (StringUtils.isNotEmpty((CharSequence)this.humanTask.getDueDate()) && (dueDate = expressionManager.createExpression(this.humanTask.getDueDate()).getValue((VariableContainer)planItemInstanceEntity)) != null) {
            if (dueDate instanceof Date) {
                taskEntity.setDueDate((Date)dueDate);
            } else if (dueDate instanceof String) {
                String dueDateString = (String)dueDate;
                if (dueDateString.startsWith("P")) {
                    taskEntity.setDueDate(new DateTime((Object)CommandContextUtil.getCmmnEngineConfiguration(commandContext).getClock().getCurrentTime()).plus((ReadablePeriod)Period.parse((String)dueDateString)).toDate());
                } else {
                    taskEntity.setDueDate(DateTime.parse((String)dueDateString).toDate());
                }
            } else {
                throw new FlowableIllegalArgumentException("Due date expression does not resolve to a Date or Date string: " + this.humanTask.getDueDate());
            }
        }
    }

    protected void handleCategory(PlanItemInstanceEntity planItemInstanceEntity, ExpressionManager expressionManager, TaskEntity taskEntity) {
        Object category;
        if (StringUtils.isNotEmpty((CharSequence)this.humanTask.getCategory()) && (category = expressionManager.createExpression(this.humanTask.getCategory()).getValue((VariableContainer)planItemInstanceEntity)) != null) {
            if (category instanceof String) {
                taskEntity.setCategory((String)category);
            } else {
                throw new FlowableIllegalArgumentException("Category expression does not resolve to a string: " + this.humanTask.getCategory());
            }
        }
    }

    protected void handleCandidateUsers(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity, ExpressionManager expressionManager, TaskEntity taskEntity) {
        List candidateUsers = this.humanTask.getCandidateUsers();
        if (candidateUsers != null && !candidateUsers.isEmpty()) {
            for (String candidateUser : candidateUsers) {
                Expression userIdExpr = expressionManager.createExpression(candidateUser);
                Object value = userIdExpr.getValue((VariableContainer)planItemInstanceEntity);
                if (value instanceof String) {
                    List<String> candidates = this.extractCandidates((String)value);
                    this.handleIdentityLinks(commandContext, taskEntity, CommandContextUtil.getIdentityLinkService().addCandidateUsers(taskEntity.getId(), candidates));
                    continue;
                }
                if (value instanceof Collection) {
                    this.handleIdentityLinks(commandContext, taskEntity, CommandContextUtil.getIdentityLinkService().addCandidateUsers(taskEntity.getId(), (Collection)value));
                    continue;
                }
                throw new FlowableException("Expression did not resolve to a string or collection of strings");
            }
        }
    }

    protected void handleCandidateGroups(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity, ExpressionManager expressionManager, TaskEntity taskEntity) {
        List candidateGroups = this.humanTask.getCandidateGroups();
        if (candidateGroups != null && !candidateGroups.isEmpty()) {
            for (String candidateGroup : candidateGroups) {
                Expression groupIdExpr = expressionManager.createExpression(candidateGroup);
                Object value = groupIdExpr.getValue((VariableContainer)planItemInstanceEntity);
                if (value instanceof String) {
                    List<String> candidates = this.extractCandidates((String)value);
                    this.handleIdentityLinks(commandContext, taskEntity, CommandContextUtil.getIdentityLinkService().addCandidateGroups(taskEntity.getId(), candidates));
                    continue;
                }
                if (value instanceof Collection) {
                    this.handleIdentityLinks(commandContext, taskEntity, CommandContextUtil.getIdentityLinkService().addCandidateGroups(taskEntity.getId(), (Collection)value));
                    continue;
                }
                throw new FlowableIllegalArgumentException("Expression did not resolve to a string or collection of strings");
            }
        }
    }

    protected void handleIdentityLinks(CommandContext commandContext, TaskEntity taskEntity, List<IdentityLinkEntity> identityLinkEntities) {
        for (IdentityLinkEntity identityLinkEntity : identityLinkEntities) {
            CountingTaskEntity countingTaskEntity;
            if (CommandContextUtil.getCmmnEngineConfiguration().isEnableTaskRelationshipCounts() && (countingTaskEntity = (CountingTaskEntity)taskEntity).isCountEnabled()) {
                countingTaskEntity.setIdentityLinkCount(countingTaskEntity.getIdentityLinkCount() + 1);
            }
            taskEntity.getIdentityLinks().add(identityLinkEntity);
        }
    }

    protected List<String> extractCandidates(String str) {
        return Arrays.asList(str.split("[\\s]*,[\\s]*"));
    }

    @Override
    public void trigger(CommandContext commandContext, PlanItemInstanceEntity planItemInstance) {
        if (!"active".equals(planItemInstance.getState())) {
            throw new FlowableException("Can only trigger a human task plan item that is in the ACTIVE state");
        }
        TaskService taskService = CommandContextUtil.getTaskService(commandContext);
        List taskEntities = taskService.findTasksBySubScopeIdScopeType(planItemInstance.getId(), "cmmn");
        if (taskEntities == null || taskEntities.isEmpty()) {
            throw new FlowableException("No task entity found for plan item instance " + planItemInstance.getId());
        }
        for (TaskEntity taskEntity : taskEntities) {
            if (taskEntity.isDeleted()) continue;
            TaskHelper.deleteTask(taskEntity, null, false, true);
        }
        CommandContextUtil.getAgenda(commandContext).planCompletePlanItemInstanceOperation(planItemInstance);
    }

    @Override
    public void onStateTransition(CommandContext commandContext, DelegatePlanItemInstance planItemInstance, String transition) {
        if ("terminate".equals(transition) || "exit".equals(transition)) {
            TaskService taskService = CommandContextUtil.getTaskService(commandContext);
            List taskEntities = taskService.findTasksBySubScopeIdScopeType(planItemInstance.getId(), "cmmn");
            for (TaskEntity taskEntity : taskEntities) {
                TaskHelper.deleteTask(taskEntity, "cmmn-state-transition-" + transition, false, true);
            }
        }
    }
}

