/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.nodes;

import org.eclipse.milo.opcua.sdk.core.nodes.ViewNode;
import org.eclipse.milo.opcua.sdk.core.nodes.ViewNodeProperties;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.jetbrains.annotations.Nullable;

public class UaViewNode
extends UaNode
implements ViewNode {
    private volatile Boolean containsNoLoops;
    private volatile UByte eventNotifier;

    public UaViewNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, Boolean containsNoLoops, UByte eventNotifier) {
        super(context, nodeId, NodeClass.View, browseName, displayName, description, writeMask, userWriteMask);
        this.containsNoLoops = containsNoLoops;
        this.eventNotifier = eventNotifier;
    }

    public Boolean getContainsNoLoops() {
        return this.containsNoLoops;
    }

    public UByte getEventNotifier() {
        return this.eventNotifier;
    }

    public synchronized void setContainsNoLoops(Boolean containsNoLoops) {
        this.containsNoLoops = containsNoLoops;
        this.fireAttributeChanged(AttributeId.ContainsNoLoops, containsNoLoops);
    }

    public synchronized void setEventNotifier(UByte eventNotifier) {
        this.eventNotifier = eventNotifier;
        this.fireAttributeChanged(AttributeId.EventNotifier, eventNotifier);
    }

    @Override
    public synchronized Object getAttribute(AttributeId attributeId) {
        switch (attributeId) {
            case ContainsNoLoops: {
                return this.containsNoLoops;
            }
            case EventNotifier: {
                return this.eventNotifier;
            }
        }
        return super.getAttribute(attributeId);
    }

    @Override
    public synchronized void setAttribute(AttributeId attributeId, Object value) {
        switch (attributeId) {
            case ContainsNoLoops: {
                this.containsNoLoops = (Boolean)value;
                break;
            }
            case EventNotifier: {
                this.eventNotifier = (UByte)value;
                break;
            }
            default: {
                super.setAttribute(attributeId, value);
                return;
            }
        }
        this.fireAttributeChanged(attributeId, value);
    }

    @Nullable
    public String getNodeVersion() {
        return this.getProperty(ViewNodeProperties.NodeVersion).orElse(null);
    }

    @Nullable
    public UInteger getViewVersion() {
        return this.getProperty(ViewNodeProperties.ViewVersion).orElse(null);
    }

    public void setNodeVersion(String nodeVersion) {
        this.setProperty(ViewNodeProperties.NodeVersion, nodeVersion);
    }

    public void setViewVersion(UInteger viewVersion) {
        this.setProperty(ViewNodeProperties.ViewVersion, viewVersion);
    }
}

