/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.nodes;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.sdk.core.QualifiedProperty;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.core.util.StreamUtil;
import org.eclipse.milo.opcua.sdk.server.api.AddressSpaceManager;
import org.eclipse.milo.opcua.sdk.server.api.nodes.Node;
import org.eclipse.milo.opcua.sdk.server.api.nodes.ObjectNode;
import org.eclipse.milo.opcua.sdk.server.api.nodes.ObjectTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaMethodNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NamingRuleType;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;

public class UaObjectNode
extends UaNode
implements ObjectNode {
    private volatile UByte eventNotifier = Unsigned.ubyte((int)0);
    public static final QualifiedProperty<String> NodeVersion = new QualifiedProperty("http://opcfoundation.org/UA/", "NodeVersion", Identifiers.String, Integer.valueOf(-1), String.class);
    public static final QualifiedProperty<ByteString> Icon = new QualifiedProperty("http://opcfoundation.org/UA/", "Icon", Identifiers.Image, Integer.valueOf(-1), ByteString.class);
    public static final QualifiedProperty<NamingRuleType> NamingRule = new QualifiedProperty("http://opcfoundation.org/UA/", "NamingRule", Identifiers.NamingRuleType, Integer.valueOf(-1), NamingRuleType.class);

    public UaObjectNode(UaNodeContext context, NodeId nodeId, ObjectTypeNode objectTypeNode) {
        this(context, nodeId, objectTypeNode.getBrowseName(), objectTypeNode.getDisplayName());
        this.setDescription(objectTypeNode.getDescription());
        this.setWriteMask(objectTypeNode.getWriteMask());
        this.setUserWriteMask(objectTypeNode.getUserWriteMask());
    }

    public UaObjectNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName) {
        super(context, nodeId, NodeClass.Object, browseName, displayName);
    }

    public UaObjectNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask) {
        super(context, nodeId, NodeClass.Object, browseName, displayName, description, writeMask, userWriteMask);
    }

    public UaObjectNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, UByte eventNotifier) {
        super(context, nodeId, NodeClass.Object, browseName, displayName, description, writeMask, userWriteMask);
        this.eventNotifier = eventNotifier;
    }

    @Override
    public UByte getEventNotifier() {
        return this.eventNotifier;
    }

    @Override
    public synchronized void setEventNotifier(UByte eventNotifier) {
        this.eventNotifier = eventNotifier;
        this.fireAttributeChanged(AttributeId.EventNotifier, eventNotifier);
    }

    @Nullable
    public UaMethodNode findMethodNode(NodeId methodId) {
        List<UaMethodNode> methodNodes = this.getMethodNodes();
        for (UaMethodNode methodNode : methodNodes) {
            if (methodId.equals((Object)methodNode.getNodeId())) {
                return methodNode;
            }
            NodeId typeDefinitionId = this.getTypeDefinitionNode().getNodeId();
            NodeId methodDeclarationId = this.findMethodDeclarationId(typeDefinitionId, methodNode.getBrowseName());
            if (!methodId.equals((Object)methodDeclarationId)) continue;
            return methodNode;
        }
        return null;
    }

    private NodeId findMethodDeclarationId(NodeId typeDefinitionId, QualifiedName methodName) {
        AddressSpaceManager asm = this.getNodeContext().getServer().getAddressSpaceManager();
        NamespaceTable namespaceTable = this.getNodeContext().getServer().getNamespaceTable();
        NodeId nodeId = asm.getManagedReferences(typeDefinitionId).stream().filter(Reference.HAS_COMPONENT_PREDICATE).flatMap(r -> StreamUtil.opt2stream(this.getManagedNode(r.getTargetNodeId()))).filter(n -> n instanceof UaMethodNode && Objects.equals(n.getBrowseName(), methodName)).findFirst().map(Node::getNodeId).orElse(NodeId.NULL_VALUE);
        if (nodeId.isNull()) {
            NodeId parentTypeId = asm.getManagedReferences(typeDefinitionId).stream().filter(Reference.SUBTYPE_OF).flatMap(r -> StreamUtil.opt2stream((Optional)r.getTargetNodeId().local(namespaceTable))).findFirst().orElse(null);
            if (parentTypeId != null) {
                return this.findMethodDeclarationId(parentTypeId, methodName);
            }
            return nodeId;
        }
        return nodeId;
    }

    public List<UaNode> getComponentNodes() {
        return this.getReferences().stream().filter(Reference.HAS_COMPONENT_PREDICATE).flatMap(r -> StreamUtil.opt2stream(this.getManagedNode(r.getTargetNodeId()))).collect(Collectors.toList());
    }

    public List<UaNode> getPropertyNodes() {
        return this.getReferences().stream().filter(Reference.HAS_PROPERTY_PREDICATE).flatMap(r -> StreamUtil.opt2stream(this.getManagedNode(r.getTargetNodeId()))).collect(Collectors.toList());
    }

    public List<UaMethodNode> getMethodNodes() {
        return this.getReferences().stream().filter(Reference.HAS_COMPONENT_PREDICATE).flatMap(r -> StreamUtil.opt2stream(this.getManagedNode(r.getTargetNodeId()))).filter(n -> n instanceof UaMethodNode).map(UaMethodNode.class::cast).collect(Collectors.toList());
    }

    public ObjectTypeNode getTypeDefinitionNode() {
        Node node = this.getReferences().stream().filter(Reference.HAS_TYPE_DEFINITION_PREDICATE).findFirst().flatMap(r -> this.getManagedNode(r.getTargetNodeId())).orElse(null);
        return node instanceof ObjectTypeNode ? (ObjectTypeNode)node : null;
    }

    public List<Node> getEventSourceNodes() {
        return this.getReferences().stream().filter(Reference.HAS_EVENT_SOURCE_PREDICATE).flatMap(r -> StreamUtil.opt2stream(this.getManagedNode(r.getTargetNodeId()))).collect(Collectors.toList());
    }

    public List<Node> getNotifierNodes() {
        return this.getReferences().stream().filter(Reference.HAS_NOTIFIER_PREDICATE).flatMap(r -> StreamUtil.opt2stream(this.getManagedNode(r.getTargetNodeId()))).collect(Collectors.toList());
    }

    public List<Node> getOrganizesNodes() {
        return this.getReferences().stream().filter(Reference.ORGANIZES_PREDICATE).flatMap(r -> StreamUtil.opt2stream(this.getManagedNode(r.getTargetNodeId()))).collect(Collectors.toList());
    }

    public Optional<Node> getDescriptionNode() {
        Optional<Node> node = this.getReferences().stream().filter(Reference.HAS_DESCRIPTION_PREDICATE).findFirst().flatMap(r -> this.getManagedNode(r.getTargetNodeId()));
        return node.map(n -> n);
    }

    public void addComponent(UaNode node) {
        this.addReference(new Reference(this.getNodeId(), Identifiers.HasComponent, node.getNodeId().expanded(), true));
    }

    public void removeComponent(UaNode node) {
        this.removeReference(new Reference(this.getNodeId(), Identifiers.HasComponent, node.getNodeId().expanded(), true));
    }

    @Nullable
    public String getNodeVersion() {
        return this.getProperty(NodeVersion).orElse(null);
    }

    @Nullable
    public ByteString getIcon() {
        return this.getProperty(Icon).orElse(null);
    }

    @Nullable
    public NamingRuleType getNamingRule() {
        return this.getProperty(NamingRule).orElse(null);
    }

    public void setNodeVersion(String nodeVersion) {
        this.setProperty(NodeVersion, nodeVersion);
    }

    public void setIcon(ByteString icon) {
        this.setProperty(Icon, icon);
    }

    public void setNamingRule(NamingRuleType namingRule) {
        this.setProperty(NamingRule, namingRule);
    }

    public static UaObjectNodeBuilder builder(UaNodeContext context) {
        return new UaObjectNodeBuilder(context);
    }

    public static class UaObjectNodeBuilder
    implements Supplier<UaObjectNode> {
        private final List<Reference> references = Lists.newArrayList();
        private NodeId nodeId;
        private QualifiedName browseName;
        private LocalizedText displayName;
        private LocalizedText description = LocalizedText.NULL_VALUE;
        private UInteger writeMask = UInteger.MIN;
        private UInteger userWriteMask = UInteger.MIN;
        private UByte eventNotifier = Unsigned.ubyte((int)0);
        private final UaNodeContext context;

        public UaObjectNodeBuilder(UaNodeContext context) {
            this.context = context;
        }

        @Override
        public UaObjectNode get() {
            return this.build();
        }

        public UaObjectNode build() {
            Preconditions.checkNotNull((Object)this.nodeId, (Object)"NodeId cannot be null");
            Preconditions.checkNotNull((Object)this.browseName, (Object)"BrowseName cannot be null");
            Preconditions.checkNotNull((Object)this.displayName, (Object)"DisplayName cannot be null");
            long hasTypeDefinitionCount = this.references.stream().filter(r -> Identifiers.HasTypeDefinition.equals((Object)r.getReferenceTypeId())).count();
            Preconditions.checkState((hasTypeDefinitionCount == 1L ? 1 : 0) != 0, (Object)"Object Node must have exactly one HasTypeDefinition reference.");
            UaObjectNode node = new UaObjectNode(this.context, this.nodeId, this.browseName, this.displayName, this.description, this.writeMask, this.userWriteMask, this.eventNotifier);
            this.references.forEach(node::addReference);
            return node;
        }

        public UaObjectNodeBuilder setNodeId(NodeId nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public UaObjectNodeBuilder setBrowseName(QualifiedName browseName) {
            this.browseName = browseName;
            return this;
        }

        public UaObjectNodeBuilder setDisplayName(LocalizedText displayName) {
            this.displayName = displayName;
            return this;
        }

        public UaObjectNodeBuilder setDescription(LocalizedText description) {
            this.description = description;
            return this;
        }

        public UaObjectNodeBuilder setWriteMask(UInteger writeMask) {
            this.writeMask = writeMask;
            return this;
        }

        public UaObjectNodeBuilder setUserWriteMask(UInteger userWriteMask) {
            this.userWriteMask = userWriteMask;
            return this;
        }

        public UaObjectNodeBuilder setEventNotifier(UByte eventNotifier) {
            this.eventNotifier = eventNotifier;
            return this;
        }

        public UaObjectNodeBuilder addReference(Reference reference) {
            this.references.add(reference);
            return this;
        }

        public UaObjectNodeBuilder setTypeDefinition(NodeId typeDefinition) {
            Objects.requireNonNull(this.nodeId, "NodeId cannot be null");
            this.references.add(new Reference(this.nodeId, Identifiers.HasTypeDefinition, new ExpandedNodeId(typeDefinition), true));
            return this;
        }
    }
}

