/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.nodes;

import javax.annotation.Nullable;
import org.eclipse.milo.opcua.sdk.core.QualifiedProperty;
import org.eclipse.milo.opcua.sdk.server.api.nodes.DataTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.EnumValueType;

public class UaDataTypeNode
extends UaNode
implements DataTypeNode {
    private volatile Boolean isAbstract;
    public static final QualifiedProperty<String> NodeVersion = new QualifiedProperty("http://opcfoundation.org/UA/", "NodeVersion", Identifiers.String, Integer.valueOf(-1), String.class);
    public static final QualifiedProperty<LocalizedText[]> EnumStrings = new QualifiedProperty("http://opcfoundation.org/UA/", "EnumStrings", Identifiers.LocalizedText, Integer.valueOf(1), LocalizedText[].class);
    public static final QualifiedProperty<EnumValueType[]> EnumValues = new QualifiedProperty("http://opcfoundation.org/UA/", "EnumValues", Identifiers.EnumValueType, Integer.valueOf(1), EnumValueType[].class);

    public UaDataTypeNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, boolean isAbstract) {
        super(context, nodeId, NodeClass.DataType, browseName, displayName, description, writeMask, userWriteMask);
        this.isAbstract = isAbstract;
    }

    @Override
    public Boolean getIsAbstract() {
        return this.isAbstract;
    }

    @Override
    public synchronized void setIsAbstract(Boolean isAbstract) {
        this.isAbstract = isAbstract;
        this.fireAttributeChanged(AttributeId.IsAbstract, isAbstract);
    }

    @Nullable
    public String getNodeVersion() {
        return this.getProperty(NodeVersion).orElse(null);
    }

    @Nullable
    public LocalizedText[] getEnumStrings() {
        return this.getProperty(EnumStrings).orElse(null);
    }

    @Nullable
    public EnumValueType[] getEnumValues() {
        return this.getProperty(EnumValues).orElse(null);
    }

    public void setNodeVersion(String nodeVersion) {
        this.setProperty(NodeVersion, nodeVersion);
    }

    public void setEnumStrings(LocalizedText[] enumStrings) {
        this.setProperty(EnumStrings, enumStrings);
    }

    public void setEnumValues(EnumValueType[] enumValues) {
        this.setProperty(EnumValues, enumValues);
    }
}

