/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.identity;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.function.Predicate;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.identity.AbstractIdentityValidator;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.security.SecurityAlgorithm;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.structured.AnonymousIdentityToken;
import org.eclipse.milo.opcua.stack.core.types.structured.SignatureData;
import org.eclipse.milo.opcua.stack.core.types.structured.UserNameIdentityToken;
import org.eclipse.milo.opcua.stack.core.types.structured.UserTokenPolicy;

public class UsernameIdentityValidator
extends AbstractIdentityValidator {
    private final boolean allowAnonymous;
    private final Predicate<AuthenticationChallenge> predicate;

    public UsernameIdentityValidator(boolean allowAnonymous, Predicate<AuthenticationChallenge> predicate) {
        this.allowAnonymous = allowAnonymous;
        this.predicate = predicate;
    }

    @Override
    public Object validateAnonymousToken(Session session, AnonymousIdentityToken token, UserTokenPolicy tokenPolicy, SignatureData tokenSignature) throws UaException {
        if (this.allowAnonymous) {
            return String.format("anonymous_%s_%s", session.getSessionName(), session.getSessionId().toParseableString());
        }
        throw new UaException(2149515264L);
    }

    @Override
    public Object validateUsernameToken(Session session, UserNameIdentityToken token, UserTokenPolicy tokenPolicy, SignatureData tokenSignature) throws UaException {
        return this.validateUserNameIdentityToken(session, token);
    }

    private String validateUserNameIdentityToken(Session session, UserNameIdentityToken token) throws UaException {
        SecurityAlgorithm algorithm;
        SecurityPolicy securityPolicy = session.getSecurityConfiguration().getSecurityPolicy();
        String username = token.getUserName();
        ByteString lastNonce = session.getLastNonce();
        int lastNonceLength = lastNonce.length();
        if (username == null || username.isEmpty()) {
            throw new UaException(0x80200000L);
        }
        String algorithmUri = token.getEncryptionAlgorithm();
        if (algorithmUri == null || algorithmUri.isEmpty()) {
            algorithm = securityPolicy.getAsymmetricEncryptionAlgorithm();
        } else {
            try {
                algorithm = SecurityAlgorithm.fromUri((String)algorithmUri);
            }
            catch (UaException e) {
                throw new UaException(0x80200000L);
            }
            if (algorithm != SecurityAlgorithm.Rsa15 && algorithm != SecurityAlgorithm.RsaOaepSha1 && algorithm != SecurityAlgorithm.RsaOaepSha256) {
                throw new UaException(0x80200000L);
            }
        }
        byte[] tokenBytes = token.getPassword().bytes();
        if (tokenBytes == null) {
            tokenBytes = new byte[]{};
        }
        if (algorithm != SecurityAlgorithm.None) {
            byte[] plainTextBytes = this.decryptTokenData(session, algorithm, tokenBytes);
            long length = ((long)plainTextBytes[3] & 0xFFL) << 24 | ((long)plainTextBytes[2] & 0xFFL) << 16 | ((long)plainTextBytes[1] & 0xFFL) << 8 | (long)plainTextBytes[0] & 0xFFL;
            if (length > (long)(plainTextBytes.length - 4)) {
                throw new UaException(0x80200000L, "invalid token data");
            }
            int passwordLength = (int)length - lastNonceLength;
            if (passwordLength < 0) {
                throw new UaException(0x80200000L, "invalid password length");
            }
            if ((long)passwordLength > session.getServer().getConfig().getLimits().getMaxPasswordLength().longValue()) {
                throw new UaException(0x80080000L, "password length exceeds limits");
            }
            byte[] passwordBytes = new byte[passwordLength];
            byte[] nonceBytes = new byte[lastNonceLength];
            System.arraycopy(plainTextBytes, 4, passwordBytes, 0, passwordBytes.length);
            System.arraycopy(plainTextBytes, 4 + passwordBytes.length, nonceBytes, 0, lastNonceLength);
            String password = new String(passwordBytes, Charset.forName("UTF-8"));
            AuthenticationChallenge challenge = new AuthenticationChallenge(username, password);
            if (Arrays.equals(lastNonce.bytes(), nonceBytes) && this.predicate.test(challenge)) {
                return username;
            }
            throw new UaException(2149515264L);
        }
        String password = new String(tokenBytes, Charset.forName("UTF-8"));
        AuthenticationChallenge challenge = new AuthenticationChallenge(username, password);
        if (this.predicate.test(challenge)) {
            return username;
        }
        throw new UaException(2149515264L);
    }

    public static final class AuthenticationChallenge {
        private final String username;
        private final String password;

        public AuthenticationChallenge(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

