/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.conversions;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.BuiltinDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;

final class StatusCodeConversions {
    private StatusCodeConversions() {
    }

    @Nonnull
    static Short statusCodeToInt16(@Nonnull StatusCode s) {
        return (short)(s.getValue() >>> 16 & 0xFFFFL);
    }

    @Nonnull
    static Integer statusCodeToInt32(@Nonnull StatusCode s) {
        return (int)s.getValue();
    }

    @Nonnull
    static Long statusCodeToInt64(@Nonnull StatusCode s) {
        return s.getValue();
    }

    @Nonnull
    static UShort statusCodeToUInt16(@Nonnull StatusCode s) {
        return Unsigned.ushort((short)StatusCodeConversions.statusCodeToInt16(s));
    }

    @Nonnull
    static UInteger statusCodeToUInt32(@Nonnull StatusCode s) {
        return Unsigned.uint((int)StatusCodeConversions.statusCodeToInt32(s));
    }

    @Nonnull
    static ULong statusCodeToUInt64(@Nonnull StatusCode s) {
        return Unsigned.ulong((long)s.getValue());
    }

    @Nullable
    static Object convert(@Nonnull Object o, BuiltinDataType targetType, boolean implicit) {
        if (o instanceof StatusCode) {
            StatusCode s = (StatusCode)o;
            return implicit ? StatusCodeConversions.implicitConversion(s, targetType) : StatusCodeConversions.explicitConversion(s, targetType);
        }
        return null;
    }

    @Nullable
    static Object explicitConversion(@Nonnull StatusCode s, BuiltinDataType targetType) {
        switch (targetType) {
            case Int16: {
                return StatusCodeConversions.statusCodeToInt16(s);
            }
            case UInt16: {
                return StatusCodeConversions.statusCodeToUInt16(s);
            }
        }
        return StatusCodeConversions.implicitConversion(s, targetType);
    }

    @Nullable
    static Object implicitConversion(@Nonnull StatusCode s, BuiltinDataType targetType) {
        switch (targetType) {
            case Int32: {
                return StatusCodeConversions.statusCodeToInt32(s);
            }
            case Int64: {
                return StatusCodeConversions.statusCodeToInt64(s);
            }
            case UInt32: {
                return StatusCodeConversions.statusCodeToUInt32(s);
            }
            case UInt64: {
                return StatusCodeConversions.statusCodeToUInt64(s);
            }
        }
        return null;
    }
}

