/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.conversions;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.BuiltinDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;

final class SByteConversions {
    private SByteConversions() {
    }

    @Nonnull
    static Boolean sByteToBoolean(@Nonnull Byte b) {
        return b != 0;
    }

    @Nullable
    static UByte sByteToByte(@Nonnull Byte b) {
        if (b >= 0) {
            return Unsigned.ubyte((byte)b);
        }
        return null;
    }

    @Nonnull
    static Double sByteToDouble(@Nonnull Byte b) {
        return b.doubleValue();
    }

    @Nonnull
    static Float sByteToFloat(@Nonnull Byte b) {
        return Float.valueOf(b.floatValue());
    }

    @Nonnull
    static Short sByteToInt16(@Nonnull Byte b) {
        return b.shortValue();
    }

    @Nonnull
    static Integer sByteToInt32(@Nonnull Byte b) {
        return b.intValue();
    }

    @Nonnull
    static Long sByteToInt64(@Nonnull Byte b) {
        return b.longValue();
    }

    @Nonnull
    static String sByteToString(@Nonnull Byte b) {
        return b.toString();
    }

    @Nullable
    static UShort sByteToUInt16(@Nonnull Byte b) {
        if (b >= 0) {
            return Unsigned.ushort((short)b.byteValue());
        }
        return null;
    }

    @Nullable
    static UInteger sByteToUInt32(@Nonnull Byte b) {
        if (b >= 0) {
            return Unsigned.uint((int)b.byteValue());
        }
        return null;
    }

    @Nullable
    static ULong sByteToUInt64(@Nonnull Byte b) {
        if (b >= 0) {
            return Unsigned.ulong((long)b.byteValue());
        }
        return null;
    }

    @Nullable
    static Object convert(@Nonnull Object o, BuiltinDataType targetType, boolean implicit) {
        if (o instanceof Byte) {
            Byte b = (Byte)o;
            return implicit ? SByteConversions.implicitConversion(b, targetType) : SByteConversions.explicitConversion(b, targetType);
        }
        return null;
    }

    @Nullable
    static Object explicitConversion(@Nonnull Byte b, BuiltinDataType targetType) {
        switch (targetType) {
            case Boolean: {
                return SByteConversions.sByteToBoolean(b);
            }
            case Byte: {
                return SByteConversions.sByteToByte(b);
            }
            case String: {
                return SByteConversions.sByteToString(b);
            }
        }
        return SByteConversions.implicitConversion(b, targetType);
    }

    @Nullable
    static Object implicitConversion(@Nonnull Byte b, BuiltinDataType targetType) {
        switch (targetType) {
            case Double: {
                return SByteConversions.sByteToDouble(b);
            }
            case Float: {
                return SByteConversions.sByteToFloat(b);
            }
            case Int16: {
                return SByteConversions.sByteToInt16(b);
            }
            case Int32: {
                return SByteConversions.sByteToInt32(b);
            }
            case Int64: {
                return SByteConversions.sByteToInt64(b);
            }
            case UInt16: {
                return SByteConversions.sByteToUInt16(b);
            }
            case UInt32: {
                return SByteConversions.sByteToUInt32(b);
            }
            case UInt64: {
                return SByteConversions.sByteToUInt64(b);
            }
        }
        return null;
    }
}

