/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.conversions;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.BuiltinDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;

final class QualifiedNameConversions {
    private QualifiedNameConversions() {
    }

    @Nullable
    static String qualifiedNameToString(@Nonnull QualifiedName name) {
        return name.getName();
    }

    @Nonnull
    static LocalizedText qualifiedNameToLocalizedText(@Nonnull QualifiedName name) {
        return new LocalizedText("", name.getName());
    }

    @Nullable
    static Object convert(@Nonnull Object o, BuiltinDataType targetType, boolean implicit) {
        if (o instanceof QualifiedName) {
            QualifiedName name = (QualifiedName)o;
            return implicit ? QualifiedNameConversions.implicitConversion(name, targetType) : QualifiedNameConversions.explicitConversion(name, targetType);
        }
        return null;
    }

    @Nullable
    static Object explicitConversion(@Nonnull QualifiedName name, BuiltinDataType targetType) {
        return QualifiedNameConversions.implicitConversion(name, targetType);
    }

    @Nullable
    static Object implicitConversion(@Nonnull QualifiedName name, BuiltinDataType targetType) {
        switch (targetType) {
            case String: {
                return QualifiedNameConversions.qualifiedNameToString(name);
            }
            case LocalizedText: {
                return QualifiedNameConversions.qualifiedNameToLocalizedText(name);
            }
        }
        return null;
    }
}

