/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.nodes;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.AddressSpace;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.methods.UaMethod;
import org.eclipse.milo.opcua.sdk.client.nodes.UaMethodNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaObjectTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaVariableNode;
import org.eclipse.milo.opcua.sdk.core.nodes.ObjectNode;
import org.eclipse.milo.opcua.sdk.core.nodes.ObjectNodeProperties;
import org.eclipse.milo.opcua.sdk.core.util.StreamUtil;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseDirection;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseResultMask;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NamingRuleType;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.Argument;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseResult;
import org.eclipse.milo.opcua.stack.core.types.structured.ReferenceDescription;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;

public class UaObjectNode
extends UaNode
implements ObjectNode {
    private UByte eventNotifier;

    public UaObjectNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask);
        this.eventNotifier = eventNotifier;
    }

    public synchronized UByte getEventNotifier() {
        return this.eventNotifier;
    }

    public void setEventNotifier(UByte eventNotifier) {
        this.eventNotifier = eventNotifier;
    }

    public UByte readEventNotifier() throws UaException {
        DataValue value = this.readAttribute(AttributeId.EventNotifier);
        StatusCode statusCode = value.getStatusCode();
        if (statusCode != null && statusCode.isBad()) {
            throw new UaException(statusCode, "read EventNotifier failed");
        }
        UByte eventNotifier = (UByte)value.getValue().getValue();
        this.setEventNotifier(eventNotifier);
        return eventNotifier;
    }

    public void writeEventNotifier(UByte eventNotifier) throws UaException {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)eventNotifier));
        StatusCode statusCode = this.writeAttribute(AttributeId.EventNotifier, value);
        if (statusCode != null && !statusCode.isGood()) {
            throw new UaException(statusCode, "write EventNotifier failed");
        }
        this.setEventNotifier(eventNotifier);
    }

    public Variant[] callMethod(String methodName, Variant[] inputs) throws UaException {
        return this.getMethod(methodName).call(inputs);
    }

    public Variant[] callMethod(QualifiedName methodName, Variant[] inputs) throws UaException {
        return this.getMethod(methodName).call(inputs);
    }

    public CompletableFuture<Variant[]> callMethodAsync(String methodName, Variant[] inputs) {
        return this.getMethodAsync(methodName).thenCompose(m -> m.callAsync(inputs));
    }

    public CompletableFuture<Variant[]> callMethodAsync(QualifiedName methodName, Variant[] inputs) {
        return this.getMethodAsync(methodName).thenCompose(m -> m.callAsync(inputs));
    }

    public UaMethod getMethod(String methodName) throws UaException {
        UShort namespaceIndex = this.getNodeId().getNamespaceIndex();
        return this.getMethod(new QualifiedName(namespaceIndex, methodName));
    }

    public UaMethod getMethod(QualifiedName methodName) throws UaException {
        try {
            return this.getMethodAsync(methodName).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<UaMethod> getMethodAsync(String methodName) {
        UShort namespaceIndex = this.getNodeId().getNamespaceIndex();
        return this.getMethodAsync(new QualifiedName(namespaceIndex, methodName));
    }

    public CompletableFuture<UaMethod> getMethodAsync(QualifiedName methodName) {
        UInteger nodeClassMask = Unsigned.uint((int)NodeClass.Method.getValue());
        UInteger resultMask = Unsigned.uint((int)BrowseResultMask.All.getValue());
        CompletableFuture<BrowseResult> future = this.client.browse(new BrowseDescription(this.getNodeId(), BrowseDirection.Forward, Identifiers.HasComponent, Boolean.valueOf(true), nodeClassMask, resultMask));
        return future.thenCompose(result -> {
            StatusCode statusCode = result.getStatusCode();
            if (statusCode != null && statusCode.isGood()) {
                Optional<ExpandedNodeId> methodNodeId = ConversionUtil.l((Object[])result.getReferences()).stream().filter(rd -> Objects.equals(methodName, rd.getBrowseName())).findFirst().map(ReferenceDescription::getNodeId);
                return methodNodeId.map(xni -> {
                    AddressSpace addressSpace = this.client.getAddressSpace();
                    return addressSpace.toNodeIdAsync((ExpandedNodeId)xni).thenCompose(nodeId -> addressSpace.getNodeAsync((NodeId)nodeId).thenCompose(node -> {
                        UaMethodNode methodNode = (UaMethodNode)node;
                        return methodNode.readInputArgumentsAsync().thenCombine(methodNode.readOutputArgumentsAsync(), (in, out) -> new UaMethod(this.client, this, methodNode, (Argument[])in, (Argument[])out));
                    }));
                }).orElse(FutureUtils.failedFuture((Throwable)new UaException(2151546880L, "method not found: " + methodName)));
            }
            return FutureUtils.failedFuture((Throwable)new UaException(statusCode, "browsing for MethodNodes failed"));
        });
    }

    public UaObjectNode getObjectComponent(String name) throws UaException {
        try {
            return this.getObjectComponentAsync(name).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public UaObjectNode getObjectComponent(String namespaceUri, String name) throws UaException {
        try {
            return this.getObjectComponentAsync(namespaceUri, name).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public UaObjectNode getObjectComponent(QualifiedName browseName) throws UaException {
        try {
            return this.getObjectComponentAsync(browseName).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends UaObjectNode> getObjectComponentAsync(String name) {
        return this.getObjectComponentAsync(new QualifiedName(this.getNodeId().getNamespaceIndex(), name));
    }

    public CompletableFuture<? extends UaObjectNode> getObjectComponentAsync(String namespaceUri, String name) {
        UShort namespaceIndex = this.client.getNamespaceTable().getIndex(namespaceUri);
        if (namespaceIndex != null) {
            return this.getObjectComponentAsync(new QualifiedName(namespaceIndex, name));
        }
        return FutureUtils.failedUaFuture((long)2151546880L);
    }

    public CompletableFuture<? extends UaObjectNode> getObjectComponentAsync(QualifiedName browseName) {
        return this.getComponentAsync(browseName, NodeClass.Object).thenApply(UaObjectNode.class::cast);
    }

    public UaVariableNode getVariableComponent(String name) throws UaException {
        try {
            return this.getVariableComponentAsync(name).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public UaVariableNode getVariableComponent(String namespaceUri, String name) throws UaException {
        try {
            return this.getVariableComponentAsync(namespaceUri, name).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public UaVariableNode getVariableComponent(QualifiedName browseName) throws UaException {
        try {
            return this.getVariableComponentAsync(browseName).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends UaVariableNode> getVariableComponentAsync(String name) {
        return this.getVariableComponentAsync(new QualifiedName(this.getNodeId().getNamespaceIndex(), name));
    }

    public CompletableFuture<? extends UaVariableNode> getVariableComponentAsync(String namespaceUri, String name) {
        UShort namespaceIndex = this.client.getNamespaceTable().getIndex(namespaceUri);
        if (namespaceIndex != null) {
            return this.getVariableComponentAsync(new QualifiedName(namespaceIndex, name));
        }
        return FutureUtils.failedUaFuture((long)2151546880L);
    }

    public CompletableFuture<? extends UaVariableNode> getVariableComponentAsync(QualifiedName browseName) {
        return this.getComponentAsync(browseName, NodeClass.Variable).thenApply(UaVariableNode.class::cast);
    }

    public UaObjectTypeNode getTypeDefinition() throws UaException {
        try {
            return this.getTypeDefinitionAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends UaObjectTypeNode> getTypeDefinitionAsync() {
        UInteger nodeClassMask = Unsigned.uint((int)NodeClass.ObjectType.getValue());
        UInteger resultMask = Unsigned.uint((int)BrowseResultMask.All.getValue());
        CompletableFuture<BrowseResult> future = this.client.browse(new BrowseDescription(this.getNodeId(), BrowseDirection.Forward, Identifiers.HasTypeDefinition, Boolean.valueOf(false), nodeClassMask, resultMask));
        return future.thenCompose(result -> {
            List references = ConversionUtil.l((Object[])result.getReferences());
            Optional node = references.stream().flatMap(r -> {
                Optional<CompletableFuture> opt = r.getNodeId().toNodeId(this.client.getNamespaceTable()).map(id -> this.client.getAddressSpace().getNodeAsync((NodeId)id).thenApply(n -> (UaObjectTypeNode)n));
                return StreamUtil.opt2stream(opt);
            }).findFirst();
            return node.orElse(FutureUtils.failedUaFuture((long)2151546880L));
        });
    }

    public CompletableFuture<String> getNodeVersion() {
        return this.getProperty(ObjectNodeProperties.NodeVersion);
    }

    public CompletableFuture<ByteString> getIcon() {
        return this.getProperty(ObjectNodeProperties.Icon);
    }

    public CompletableFuture<NamingRuleType> getNamingRuleAsync() {
        return this.getProperty(ObjectNodeProperties.NamingRule);
    }

    public CompletableFuture<StatusCode> setNodeVersion(String nodeVersion) {
        return this.setProperty(ObjectNodeProperties.NodeVersion, nodeVersion);
    }

    public CompletableFuture<StatusCode> setIcon(ByteString icon) {
        return this.setProperty(ObjectNodeProperties.Icon, icon);
    }

    public CompletableFuture<StatusCode> setNamingRuleAsync(NamingRuleType namingRule) {
        return this.setProperty(ObjectNodeProperties.NamingRule, namingRule);
    }

    @Override
    protected DataValue getAttributeValue(AttributeId attributeId) {
        switch (attributeId) {
            case EventNotifier: {
                return DataValue.valueOnly((Variant)new Variant((Object)this.getEventNotifier()));
            }
        }
        return super.getAttributeValue(attributeId);
    }

    @Override
    protected void setAttributeValue(AttributeId attributeId, DataValue value) {
        switch (attributeId) {
            case EventNotifier: {
                this.setEventNotifier((UByte)value.getValue().getValue());
                break;
            }
            default: {
                super.setAttributeValue(attributeId, value);
            }
        }
    }
}

