/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.nodes;

import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.core.nodes.MethodNode;
import org.eclipse.milo.opcua.sdk.core.nodes.MethodNodeProperties;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.Argument;

public class UaMethodNode
extends UaNode
implements MethodNode {
    private Boolean executable;
    private Boolean userExecutable;

    public UaMethodNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, Boolean executable, Boolean userExecutable) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask);
        this.executable = executable;
        this.userExecutable = userExecutable;
    }

    public synchronized Boolean isExecutable() {
        return this.executable;
    }

    public synchronized Boolean isUserExecutable() {
        return this.userExecutable;
    }

    public synchronized void setExecutable(Boolean executable) {
        this.executable = executable;
    }

    public synchronized void setUserExecutable(Boolean userExecutable) {
        this.userExecutable = userExecutable;
    }

    public Boolean readExecutable() throws UaException {
        DataValue value = this.readAttribute(AttributeId.Executable);
        StatusCode statusCode = value.getStatusCode();
        if (statusCode != null && statusCode.isBad()) {
            throw new UaException(statusCode, "read Executable failed");
        }
        Boolean executable = (Boolean)value.getValue().getValue();
        this.setExecutable(executable);
        return executable;
    }

    public Boolean readUserExecutable() throws UaException {
        DataValue value = this.readAttribute(AttributeId.UserExecutable);
        StatusCode statusCode = value.getStatusCode();
        if (statusCode != null && statusCode.isBad()) {
            throw new UaException(statusCode, "read UserExecutable failed");
        }
        Boolean userExecutable = (Boolean)value.getValue().getValue();
        this.setUserExecutable(userExecutable);
        return userExecutable;
    }

    public void writeExecutable(Boolean executable) throws UaException {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)executable));
        StatusCode statusCode = this.writeAttribute(AttributeId.Executable, value);
        if (statusCode != null && statusCode.isBad()) {
            throw new UaException(statusCode, "write Executable failed");
        }
        this.setExecutable(executable);
    }

    public void writeUserExecutable(Boolean userExecutable) throws UaException {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)userExecutable));
        StatusCode statusCode = this.writeAttribute(AttributeId.UserExecutable, value);
        if (statusCode != null && statusCode.isBad()) {
            throw new UaException(statusCode, "write UserExecutable failed");
        }
        this.setUserExecutable(userExecutable);
    }

    public CompletableFuture<? extends String> readNodeVersionAsync() {
        return this.getProperty(MethodNodeProperties.NodeVersion);
    }

    public CompletableFuture<? extends Argument[]> readInputArgumentsAsync() {
        return this.getProperty(MethodNodeProperties.InputArguments);
    }

    public CompletableFuture<? extends Argument[]> readOutputArgumentsAsync() {
        return this.getProperty(MethodNodeProperties.OutputArguments);
    }

    public CompletableFuture<StatusCode> writeNodeVersionAsync(String nodeVersion) {
        return this.setProperty(MethodNodeProperties.NodeVersion, nodeVersion);
    }

    public CompletableFuture<StatusCode> writeInputArgumentsAsync(Argument[] inputArguments) {
        return this.setProperty(MethodNodeProperties.InputArguments, inputArguments);
    }

    public CompletableFuture<StatusCode> writeOutputArgumentsAsync(Argument[] outputArguments) {
        return this.setProperty(MethodNodeProperties.OutputArguments, outputArguments);
    }

    @Override
    protected DataValue getAttributeValue(AttributeId attributeId) {
        switch (attributeId) {
            case Executable: {
                return DataValue.valueOnly((Variant)new Variant((Object)this.isExecutable()));
            }
            case UserExecutable: {
                return DataValue.valueOnly((Variant)new Variant((Object)this.isUserExecutable()));
            }
        }
        return super.getAttributeValue(attributeId);
    }

    @Override
    protected void setAttributeValue(AttributeId attributeId, DataValue value) {
        switch (attributeId) {
            case Executable: {
                this.setExecutable((Boolean)value.getValue().getValue());
                break;
            }
            case UserExecutable: {
                this.setUserExecutable((Boolean)value.getValue().getValue());
                break;
            }
            default: {
                super.setAttributeValue(attributeId, value);
            }
        }
    }
}

