/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.methods;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.methods.UaMethodException;
import org.eclipse.milo.opcua.sdk.client.nodes.UaMethodNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaObjectNode;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.structured.Argument;
import org.eclipse.milo.opcua.stack.core.types.structured.CallMethodRequest;

public class UaMethod {
    private final OpcUaClient client;
    private final UaObjectNode objectNode;
    private final UaMethodNode methodNode;
    private final Argument[] inputArguments;
    private final Argument[] outputArguments;

    public UaMethod(OpcUaClient client, UaObjectNode objectNode, UaMethodNode methodNode, Argument[] inputArguments, Argument[] outputArguments) {
        this.client = client;
        this.objectNode = objectNode;
        this.methodNode = methodNode;
        this.inputArguments = inputArguments;
        this.outputArguments = outputArguments;
    }

    public UaObjectNode getObjectNode() {
        return this.objectNode;
    }

    public UaMethodNode getMethodNode() {
        return this.methodNode;
    }

    public Argument[] getInputArguments() {
        return this.inputArguments;
    }

    public Argument[] getOutputArguments() {
        return this.outputArguments;
    }

    public Variant[] call(Variant[] inputs) throws UaException {
        try {
            return this.callAsync(inputs).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<Variant[]> callAsync(Variant[] inputs) {
        CallMethodRequest request = new CallMethodRequest(this.objectNode.getNodeId(), this.methodNode.getNodeId(), inputs);
        return this.client.call(request).thenApply(result -> {
            StatusCode statusCode = result.getStatusCode();
            if (statusCode.isGood()) {
                return result.getOutputArguments();
            }
            throw new RuntimeException((Throwable)((Object)new UaMethodException(statusCode, result.getInputArgumentResults(), result.getInputArgumentDiagnosticInfos())));
        });
    }
}

