/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.mutable.primitive;

import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.factory.stack.primitive.MutableFloatStackFactory;
import org.eclipse.collections.api.stack.primitive.MutableFloatStack;
import org.eclipse.collections.impl.factory.primitive.FloatStacks;
import org.eclipse.collections.impl.stack.mutable.primitive.FloatArrayStack;
import org.eclipse.collections.impl.utility.Iterate;

public class MutableFloatStackFactoryImpl
implements MutableFloatStackFactory {
    public static final MutableFloatStackFactory INSTANCE = new MutableFloatStackFactoryImpl();

    public MutableFloatStack empty() {
        return new FloatArrayStack();
    }

    public MutableFloatStack of() {
        return this.empty();
    }

    public MutableFloatStack with() {
        return this.empty();
    }

    public MutableFloatStack of(float ... items) {
        return this.with(items);
    }

    public MutableFloatStack with(float ... items) {
        if (items.length == 0) {
            return this.empty();
        }
        return FloatArrayStack.newStackWith(items);
    }

    public MutableFloatStack ofAll(FloatIterable items) {
        return this.withAll(items);
    }

    public MutableFloatStack withAll(FloatIterable items) {
        if (items.isEmpty()) {
            return this.empty();
        }
        return FloatArrayStack.newStack(items);
    }

    public MutableFloatStack ofAll(Iterable<Float> iterable) {
        return this.withAll(iterable);
    }

    public MutableFloatStack withAll(Iterable<Float> iterable) {
        MutableFloatStack stack = FloatStacks.mutable.empty();
        Iterate.forEach(iterable, arg_0 -> ((MutableFloatStack)stack).push(arg_0));
        return stack;
    }

    public MutableFloatStack ofAllReversed(FloatIterable items) {
        return this.withAllReversed(items);
    }

    public MutableFloatStack withAllReversed(FloatIterable items) {
        if (items.isEmpty()) {
            return this.empty();
        }
        return FloatArrayStack.newStackFromTopToBottom(items);
    }
}

